/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.cornutum.annotation.ToString;

public class JarEntryReader {
    private JarFile file_;
    private JarEntry entry_;

    public JarEntryReader(JarFile file, JarEntry entry) {
        this.file_ = file;
        this.entry_ = entry;
    }

    public JarFile getFile() {
        return this.file_;
    }

    public JarEntry getEntry() {
        return this.entry_;
    }

    public InputStream getInputStream() {
        try {
            return this.getFile().getInputStream(this.getEntry());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("JAR=%s: Can't open entry=%s", this.getFile(), this.getEntry().getName()), e);
        }
    }

    private String getJarName() {
        return new File(this.getFile().getName()).getName();
    }

    public String toString() {
        return ToString.of(this).append("jar", this.getJarName()).append("entry", this.getEntry().getName()).toString();
    }
}

