/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ClassData;
import org.cornutum.annotation.ToString;

public class PackageFilter
implements AnnotationFilter {
    private Map<String, String> annotations_ = new LinkedHashMap<String, String>();
    private Set<String> packages_ = new HashSet<String>();

    public PackageFilter() {
    }

    @SafeVarargs
    public PackageFilter(Class<? extends Annotation> ... annotations) {
        this.annotation(annotations);
    }

    public PackageFilter(String ... annotations) {
        this.annotation(annotations);
    }

    @SafeVarargs
    public final PackageFilter annotation(Class<? extends Annotation> ... annotations) {
        return this.annotation((String[])Arrays.stream(annotations).map(Class::getName).toArray(String[]::new));
    }

    public PackageFilter annotation(String ... annotations) {
        for (String annotation : annotations) {
            this.annotations_.put(ClassData.rawTypeName(annotation), annotation);
        }
        return this;
    }

    public PackageFilter inPackage(String ... packageNames) {
        return this.inPackage(Arrays.asList(packageNames));
    }

    public PackageFilter inPackage(Collection<String> packageNames) {
        this.packages_.addAll(packageNames);
        return this;
    }

    public Set<String> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations_.values().stream().collect(Collectors.toSet()));
    }

    public Set<String> getPackages() {
        return Collections.unmodifiableSet(this.packages_);
    }

    @Override
    public Optional<String> acceptAnnotation(String rawTypeName) {
        return Optional.ofNullable(this.annotations_.get(rawTypeName));
    }

    @Override
    public boolean acceptClass(String className) {
        return this.packages_.isEmpty() || this.packages_.contains(ClassData.classPackage(className));
    }

    public String toString() {
        return ToString.of(this).append("annotations", this.getAnnotations().stream().map(ToString::simpleClassName).collect(Collectors.toList())).append("packages", this.getPackages()).toString();
    }
}

