/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.benchmark.generator;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.graphannis.QueryToJSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConverterController
implements Initializable {
    private static final Logger log = LoggerFactory.getLogger(QueryConverterController.class);
    @FXML
    private TextArea aqlInput;
    @FXML
    private TextArea jsonOutput;
    @FXML
    private Button convertButton;
    private AnnisParserAntlr parser;

    public void initialize(URL url, ResourceBundle rb) {
        this.parser = new AnnisParserAntlr();
        this.parser.setPrecedenceBound(50);
    }

    @FXML
    private void aqlKeyTyped(KeyEvent evt) {
        if (evt.getCode() == KeyCode.ENTER && evt.isControlDown()) {
            evt.consume();
            this.convert();
        }
    }

    @FXML
    public void convert() {
        this.jsonOutput.textProperty().set((Object)"converting...");
        this.convertButton.disableProperty().set(true);
        Task<String> task = new Task<String>(){

            protected String call() throws Exception {
                QueryData queryData = QueryConverterController.this.parser.parse((String)QueryConverterController.this.aqlInput.textProperty().get(), null);
                return QueryToJSON.serializeQuery((List)queryData.getAlternatives(), (List)queryData.getMetaData());
            }

            protected void done() {
                super.failed();
                Platform.runLater(() -> QueryConverterController.this.convertButton.disableProperty().set(false));
            }

            protected void failed() {
                super.failed();
                Platform.runLater(() -> QueryConverterController.this.jsonOutput.textProperty().set((Object)("ERROR:\n" + this.getException().getMessage())));
            }

            protected void succeeded() {
                super.succeeded();
                Platform.runLater(() -> {
                    try {
                        QueryConverterController.this.jsonOutput.textProperty().setValue((String)this.get());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        log.error(null, (Throwable)ex);
                    }
                });
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }
}

