/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.benchmark.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.corpus_tools.annis.benchmark.generator.OptionalLongConverter;
import org.corpus_tools.annis.benchmark.generator.Query;
import org.corpus_tools.annis.benchmark.generator.QueryLogParser;
import org.corpus_tools.annis.benchmark.generator.QuerySetPersistance;
import org.corpus_tools.annis.benchmark.generator.StringSetConverter;
import org.corpus_tools.annis.benchmark.generator.TextAreaTableCell;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.graphannis.QueryToJSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySetViewController
implements Initializable {
    private final Logger log = LoggerFactory.getLogger(QuerySetViewController.class);
    @FXML
    private Parent root;
    private final FileChooser fileChooser = new FileChooser();
    private final DirectoryChooser dirChooser = new DirectoryChooser();
    private final FileChooser.ExtensionFilter logFilter = new FileChooser.ExtensionFilter("Query log (*.log)", new String[]{"*.log"});
    private final FileChooser.ExtensionFilter txtFilter = new FileChooser.ExtensionFilter("Text files (*.txt)", new String[]{"*.txt"});
    @FXML
    private TableView<Query> tableView;
    @FXML
    private TableColumn<Query, String> nameColumn;
    @FXML
    private TableColumn<Query, String> aqlColumn;
    @FXML
    private TableColumn<Query, Set<String>> corpusColumn;
    @FXML
    private TableColumn<Query, Optional<Long>> execTimeColumn;
    @FXML
    private TableColumn<Query, Boolean> validColumn;
    @FXML
    private TableColumn<Query, Optional<Long>> nrResultsColumn;
    @FXML
    private TextField corpusFilter;
    @FXML
    private CheckBox oneCorpusFilter;
    @FXML
    private CheckBox onlyValidFilter;
    @FXML
    private Label counterLabel;
    private final ObservableList<Query> queries = FXCollections.observableArrayList();
    private AnnisParserAntlr parser;

    public void initialize(URL url, ResourceBundle rb) {
        this.parser = new AnnisParserAntlr();
        this.parser.setPrecedenceBound(50);
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.aqlColumn.setCellValueFactory((Callback)new PropertyValueFactory("aql"));
        this.corpusColumn.setCellValueFactory((Callback)new PropertyValueFactory("corpora"));
        this.execTimeColumn.setCellValueFactory((Callback)new PropertyValueFactory("executionTime"));
        this.nrResultsColumn.setCellValueFactory((Callback)new PropertyValueFactory("count"));
        this.nameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.aqlColumn.setCellFactory(TextAreaTableCell.forTableColumn());
        this.corpusColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringSetConverter()));
        this.execTimeColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new OptionalLongConverter()));
        this.nrResultsColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new OptionalLongConverter()));
        this.validColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)(((Query)param.getValue()).getJson() != null ? 1 : 0)));
        this.execTimeColumn.setComparator((o1, o2) -> ComparisonChain.start().compare((Comparable)o1.orElse(Long.MIN_VALUE), (Comparable)o2.orElse(Long.MIN_VALUE)).result());
        this.nameColumn.setOnEditCommit(event -> ((Query)event.getRowValue()).setName((String)event.getNewValue()));
        this.aqlColumn.setOnEditCommit(event -> ((Query)event.getRowValue()).setAql((String)event.getNewValue()));
        this.corpusColumn.setOnEditCommit(event -> ((Query)event.getRowValue()).setCorpora((Set)event.getNewValue()));
        this.execTimeColumn.setOnEditCommit(event -> ((Query)event.getRowValue()).setExecutionTime((Optional)event.getNewValue()));
        this.nrResultsColumn.setOnEditCommit(event -> ((Query)event.getRowValue()).setCount((Optional)event.getNewValue()));
        FilteredList filteredQueries = new FilteredList(this.queries, p -> true);
        SortedList sortedQueries = new SortedList((ObservableList)filteredQueries);
        sortedQueries.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.corpusFilter.textProperty().addListener(observable -> this.setFilterPredicate((FilteredList<Query>)filteredQueries));
        this.oneCorpusFilter.selectedProperty().addListener(observable -> this.setFilterPredicate((FilteredList<Query>)filteredQueries));
        this.onlyValidFilter.selectedProperty().addListener(observable -> this.setFilterPredicate((FilteredList<Query>)filteredQueries));
        this.tableView.setItems((ObservableList)sortedQueries);
        filteredQueries.addListener(change -> this.counterLabel.textProperty().set((Object)("" + filteredQueries.size())));
    }

    private void setFilterPredicate(FilteredList<Query> filteredQueries) {
        if (filteredQueries != null) {
            filteredQueries.setPredicate(query -> {
                String corpusFilterText = (String)this.corpusFilter.textProperty().get();
                boolean allowSingleCorpusOnly = this.oneCorpusFilter.selectedProperty().get();
                boolean allowWithJsonOnly = this.onlyValidFilter.selectedProperty().get();
                if (allowSingleCorpusOnly && query.getCorpora().size() > 1) {
                    return false;
                }
                if (allowWithJsonOnly && query.getJson() == null) {
                    return false;
                }
                return corpusFilterText == null || corpusFilterText.isEmpty() || query.getCorpora().contains(corpusFilterText);
            });
        }
    }

    @FXML
    public void filterByCorpusOfQuery(ActionEvent evt) {
        Query q = (Query)this.tableView.getSelectionModel().getSelectedItem();
        if (q != null && !q.getCorpora().isEmpty()) {
            evt.consume();
            this.oneCorpusFilter.selectedProperty().set(true);
            this.corpusFilter.textProperty().set((Object)q.getCorpora().iterator().next());
        }
    }

    @FXML
    public void copySelectedQuery(ActionEvent evt) {
        Query q = (Query)this.tableView.getSelectionModel().getSelectedItem();
        if (q != null && q.getAql() != null) {
            evt.consume();
            ClipboardContent content = new ClipboardContent();
            content.putString(q.getAql());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    public void addNewQuery(ActionEvent evt) {
        this.queries.add((Object)new Query());
    }

    @FXML
    public void deleteSelectedQuery(ActionEvent evt) {
        ObservableList q = this.tableView.getSelectionModel().getSelectedItems();
        if (q != null && !q.isEmpty()) {
            evt.consume();
            this.queries.removeAll((Collection)q);
        }
    }

    @FXML
    public void loadQueryLog(ActionEvent evt) {
        this.fileChooser.setTitle("Open Query Log");
        this.fileChooser.getExtensionFilters().clear();
        this.fileChooser.getExtensionFilters().add((Object)this.logFilter);
        this.fileChooser.setSelectedExtensionFilter(this.logFilter);
        File selectedFile = this.fileChooser.showOpenDialog(this.root.getScene().getWindow());
        if (selectedFile != null) {
            try {
                List parsedQueries = (List)Files.readLines((File)selectedFile, (Charset)StandardCharsets.UTF_8, (LineProcessor)new QueryLogParser());
                this.queries.clear();
                this.queries.addAll((Collection)parsedQueries);
            }
            catch (IOException ex) {
                this.log.error(null, (Throwable)ex);
                new Alert(Alert.AlertType.ERROR, "Could not parse file: " + ex.getMessage(), new ButtonType[]{ButtonType.OK}).showAndWait();
            }
        }
    }

    @FXML
    public void load(ActionEvent evt) {
        this.dirChooser.setTitle("Set directory");
        File dir = this.dirChooser.showDialog(this.root.getScene().getWindow());
        if (dir != null) {
            List<Query> loaded = QuerySetPersistance.loadQuerySet(dir);
            this.queries.clear();
            this.queries.addAll(loaded);
        }
    }

    @FXML
    public void exportCpp(ActionEvent evt) {
        this.dirChooser.setTitle("Set export directory");
        File dir = this.dirChooser.showDialog(this.root.getScene().getWindow());
        if (dir != null) {
            int successCounter = QuerySetPersistance.writeQuerySet(dir, (Collection<Query>)this.tableView.getItems());
            int errorCounter = this.tableView.getItems().size() - successCounter;
            if (errorCounter == 0) {
                new Alert(Alert.AlertType.INFORMATION, "All queries exported successfully", new ButtonType[]{ButtonType.OK}).showAndWait();
            } else {
                new Alert(Alert.AlertType.ERROR, "" + errorCounter + " had errors", new ButtonType[]{ButtonType.OK}).showAndWait();
            }
        }
    }

    @FXML
    public void exportAnnis3(ActionEvent evt) {
        this.fileChooser.setTitle("Set export file");
        this.fileChooser.getExtensionFilters().clear();
        this.fileChooser.getExtensionFilters().add((Object)this.txtFilter);
        this.fileChooser.setSelectedExtensionFilter(this.txtFilter);
        File file = this.fileChooser.showSaveDialog(this.root.getScene().getWindow());
        if (file != null) {
            try (OutputStreamWriter o = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                o.write("set clear-caches to false\n");
                o.write("record\n");
                ObservableList visibleQueries = this.tableView.getItems();
                String corpusName = null;
                for (Query q : visibleQueries) {
                    Preconditions.checkState((q.getCorpora().size() == 1 ? 1 : 0) != 0);
                    if (corpusName == null) {
                        corpusName = q.getCorpora().iterator().next();
                        continue;
                    }
                    Preconditions.checkState((boolean)corpusName.equals(q.getCorpora().iterator().next()));
                }
                Preconditions.checkNotNull(corpusName);
                o.write("corpus " + corpusName + "\n\n");
                for (Query q : visibleQueries) {
                    o.write("benchmarkName " + q.getName() + "\n");
                    o.write("count " + q.getAql().replace('\n', ' ') + "\n");
                }
                o.write("\nbenchmark 5\n");
            }
            catch (Exception ex) {
                this.log.error(null, (Throwable)ex);
                new Alert(Alert.AlertType.ERROR, "error on export: ", new ButtonType[]{ButtonType.OK}).showAndWait();
            }
        }
    }

    @FXML
    public void parseJSON(ActionEvent evt) {
        this.tableView.getItems().stream().forEach(q -> {
            try {
                q.setJson(null);
                QueryData queryData = this.parser.parse(q.getAql(), null);
                queryData.setMaxWidth(((List)queryData.getAlternatives().get(0)).size());
                String asJSON = QueryToJSON.serializeQuery((List)queryData.getAlternatives(), (List)queryData.getMetaData());
                q.setJson(asJSON);
            }
            catch (Exception ex) {
                this.log.error("Could not create json", (Throwable)ex);
            }
        });
        this.validColumn.setVisible(false);
        this.validColumn.setVisible(true);
    }
}

