/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis.console;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.corpus_tools.graphannis.API;
import org.corpus_tools.graphannis.QueryToJSON;

public class Console {
    private final API.CorpusStorageManager mgr;

    public Console(String databaseDir) {
        this.mgr = new API.CorpusStorageManager(databaseDir);
    }

    private void list() {
        API.StringVector result = this.mgr.list();
        for (long i = 0L; i < result.size(); ++i) {
            String corpus = result.get(i).getString();
            API.CorpusStorageManager.CorpusInfo info = this.mgr.info(corpus);
            double memoryBytes = info.memoryUsageInBytes();
            String memoryInMB = String.format("%.2f", memoryBytes / 1048576.0);
            System.out.println(result.get(i).getString() + ": " + info.loadStatus().getString() + " (" + memoryInMB + " MB)");
        }
    }

    private void count(String argsRaw) {
        List args = Splitter.on((String)" ").limit(2).omitEmptyStrings().trimResults().splitToList((CharSequence)argsRaw);
        if (args.size() != 2) {
            System.out.println("You must give the corpus name and the query as argument");
            return;
        }
        long result = this.mgr.count(new API.StringVector(new String[]{(String)args.get(0)}), QueryToJSON.aqlToJSON((String)((String)args.get(1))));
        System.out.println("" + result + " results.");
    }

    private void relannis(String argsRaw) {
        List args = Splitter.on((String)" ").limit(2).omitEmptyStrings().trimResults().splitToList((CharSequence)argsRaw);
        if (args.size() != 2) {
            System.out.println("You must give path to the relANNIS files  and the corpus name as argument");
            return;
        }
        this.mgr.importRelANNIS((String)args.get(0), (String)args.get(1));
        System.out.println("Imported.");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must give the database directory as argument.");
            System.exit(-1);
        }
        Console c = new Console(args[0]);
        try {
            String line;
            Splitter cmdArgSplitter = Splitter.on((String)" ").omitEmptyStrings().trimResults().limit(2);
            FileHistory history = new FileHistory(new File(".graphannis_history.txt"));
            ConsoleReader reader = new ConsoleReader();
            reader.setHistory((History)history);
            reader.setHistoryEnabled(true);
            reader.setPrompt("graphannis> ");
            reader.addCompleter((Completer)new StringsCompleter(new String[]{"quit", "exit", "count", "list"}));
            boolean exit = false;
            while (!exit && (line = reader.readLine()) != null) {
                List parsed = cmdArgSplitter.splitToList((CharSequence)line);
                String cmd = (String)parsed.get(0);
                String arguments = "";
                if (parsed.size() > 1) {
                    arguments = (String)parsed.get(1);
                }
                switch (cmd) {
                    case "list": {
                        c.list();
                        break;
                    }
                    case "count": {
                        c.count(arguments);
                        break;
                    }
                    case "relannis": {
                        c.relannis(arguments);
                        break;
                    }
                    case "exit": 
                    case "quit": {
                        System.out.println("Good bye!");
                        exit = true;
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

