/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.benchmark.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.corpus_tools.annis.benchmark.generator.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySetPersistance {
    private static final Logger log = LoggerFactory.getLogger(QuerySetPersistance.class);

    public static List<Query> loadQuerySet(File dir) {
        File[] aqlFiles;
        ArrayList<Query> qs = new ArrayList<Query>();
        File[] fileArray = aqlFiles = dir.listFiles((dir1, name) -> name.endsWith(".aql"));
        int n = aqlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name2 = f.getName().substring(0, f.getName().length() - ".aql".length());
            Query q = QuerySetPersistance.loadQuery(dir, name2);
            qs.add(q);
            ++n2;
        }
        return qs;
    }

    private static Query loadQuery(File parentDir, String name) {
        File fCorpora;
        File fTime;
        File fCount;
        File fJson;
        Preconditions.checkNotNull((Object)parentDir);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)parentDir.isDirectory());
        Query q = new Query();
        q.setName(name);
        File fAql = new File(parentDir, String.valueOf(name) + ".aql");
        if (fAql.isFile()) {
            try {
                q.setAql(Files.asCharSource((File)fAql, (Charset)StandardCharsets.UTF_8).read());
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if ((fJson = new File(parentDir, String.valueOf(name) + ".json")).isFile()) {
            try {
                q.setJson(Files.asCharSource((File)fJson, (Charset)StandardCharsets.UTF_8).read());
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if ((fCount = new File(parentDir, String.valueOf(name) + ".count")).isFile()) {
            try {
                String raw = Files.asCharSource((File)fCount, (Charset)StandardCharsets.UTF_8).read();
                q.setCount(Optional.of(Long.parseLong(raw.trim())));
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if ((fTime = new File(parentDir, String.valueOf(name) + ".time")).isFile()) {
            try {
                String raw = Files.asCharSource((File)fTime, (Charset)StandardCharsets.UTF_8).read();
                q.setExecutionTime(Optional.of(Double.parseDouble(raw.trim())));
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if ((fCorpora = new File(parentDir, String.valueOf(name) + ".corpora")).isFile()) {
            try {
                String raw = Files.asCharSource((File)fCorpora, (Charset)StandardCharsets.UTF_8).read();
                q.setCorpora(new LinkedHashSet<String>(Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)raw)));
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return q;
    }

    public static int writeQuerySet(File dir, Collection<Query> queries) {
        AtomicInteger success = new AtomicInteger(0);
        Preconditions.checkArgument((boolean)dir.isDirectory());
        queries.stream().forEach(q -> {
            try {
                QuerySetPersistance.writeQuery(dir, q);
                success.incrementAndGet();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        });
        return success.get();
    }

    private static void writeQuery(File parentDir, Query q) throws IOException {
        Preconditions.checkNotNull((Object)q.getName());
        Preconditions.checkNotNull((Object)q.getAql());
        String name = q.getName();
        File fAQL = new File(parentDir, String.valueOf(name) + ".aql");
        String aql = q.getAql();
        Files.write((CharSequence)q.getAql(), (File)fAQL, (Charset)StandardCharsets.UTF_8);
        if (q.getJson() != null) {
            File fJSON = new File(parentDir, String.valueOf(name) + ".json");
            Files.write((CharSequence)q.getJson().trim(), (File)fJSON, (Charset)StandardCharsets.UTF_8);
        }
        if (q.getCount().isPresent()) {
            File fCount = new File(parentDir, String.valueOf(name) + ".count");
            Files.write((CharSequence)("" + q.getCount().get()), (File)fCount, (Charset)StandardCharsets.UTF_8);
        }
        if (q.getExecutionTime().isPresent()) {
            File fTime = new File(parentDir, String.valueOf(name) + ".time");
            Files.write((CharSequence)("" + q.getExecutionTime().get()), (File)fTime, (Charset)StandardCharsets.UTF_8);
        }
        if (q.getCorpora() != null && !q.getCorpora().isEmpty()) {
            File fCorpora = new File(parentDir, String.valueOf(name) + ".corpora");
            Files.write((CharSequence)Joiner.on((String)",").join(q.getCorpora()), (File)fCorpora, (Charset)StandardCharsets.UTF_8);
        }
    }
}

