/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis.conversion;

import java.io.File;
import java.util.List;
import org.corpus_tools.annis.benchmark.generator.Query;
import org.corpus_tools.annis.benchmark.generator.QuerySetPersistance;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.graphannis.QueryToJSON;

public class ReparseFolder {
    public static void main(String[] args) {
        if (args.length >= 1) {
            File dir = new File(args[0]);
            System.out.println("Re-parsing folder " + dir.getAbsolutePath());
            AnnisParserAntlr parser = new AnnisParserAntlr();
            parser.setPrecedenceBound(50);
            List<Query> allQueries = QuerySetPersistance.loadQuerySet(dir);
            for (Query q : allQueries) {
                q.setJson(null);
                QueryData queryData = parser.parse(q.getAql(), null);
                queryData.setMaxWidth(((List)queryData.getAlternatives().get(0)).size());
                String asJSON = QueryToJSON.serializeQuery((List)queryData.getAlternatives(), (List)queryData.getMetaData());
                q.setJson(asJSON);
            }
            QuerySetPersistance.writeQuerySet(dir, allQueries);
        }
    }
}

