/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.benchmark.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.annis.benchmark.generator.Query;

public class QueryLogParser
implements LineProcessor<List<Query>> {
    private final Collection<Query> queries;
    private StringBuilder currentAQL;
    private static final Pattern COMPLETE_LINE = Pattern.compile("^[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9](.*)function: COUNT, query: (?<query>.*), corpus: \\[(?<corpus>[^\\]]+)\\], runtime: (?<time>[0-9]+) ms$");
    private static final Pattern INCOMPLETE_START = Pattern.compile("^[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9](.*)function: COUNT, query: (?<query>.*)$");
    private static final Pattern INCOMPLETE_END = Pattern.compile("^(?<query>.*), corpus: \\[(?<corpus>[^\\]]+)\\], runtime: (?<time>[0-9]+) ms$");

    public QueryLogParser() {
        this(true);
    }

    public QueryLogParser(boolean uniqueOnly) {
        if (uniqueOnly) {
            Joiner j = Joiner.on((String)",");
            this.queries = new TreeSet<Query>((q1, q2) -> ComparisonChain.start().compare((Comparable)((Object)q1.getAql()), (Comparable)((Object)q2.getAql())).compare((Comparable)((Object)j.join(q1.getCorpora())), (Comparable)((Object)j.join(q2.getCorpora()))).result());
        } else {
            this.queries = new LinkedList<Query>();
        }
    }

    private void addQuery(String aql, String corpora, String time) {
        Query q = new Query();
        q.setAql(aql);
        q.setCorpora(new LinkedHashSet<String>(Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)corpora)));
        q.setExecutionTime(Optional.of(Double.parseDouble(time)));
        q.setName(String.format("%05d", this.queries.size()));
        this.queries.add(q);
    }

    public boolean processLine(String line) throws IOException {
        if (this.currentAQL == null) {
            Matcher mComplete = COMPLETE_LINE.matcher(line);
            Matcher mStart = INCOMPLETE_START.matcher(line);
            if (mComplete.matches()) {
                this.addQuery(mComplete.group("query"), mComplete.group("corpus"), mComplete.group("time"));
            } else if (mStart.matches()) {
                this.currentAQL = new StringBuilder();
                this.currentAQL.append(mStart.group("query"));
            }
        } else {
            Matcher mEnd = INCOMPLETE_END.matcher(line);
            if (mEnd.matches()) {
                this.currentAQL.append(mEnd.group("query"));
                this.addQuery(this.currentAQL.toString(), mEnd.group("corpus"), mEnd.group("time"));
                this.currentAQL = null;
            } else {
                this.currentAQL.append(line);
                this.currentAQL.append(" ");
            }
        }
        return true;
    }

    public List<Query> getResult() {
        return new ArrayList<Query>(this.queries);
    }
}

