/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.benchmark.generator;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class TextAreaTableCell<S>
extends TableCell<S, String> {
    private Text textNode;
    private TextArea textArea;

    public void startEdit() {
        super.startEdit();
        this.textArea = new TextArea((String)this.getItem());
        this.textArea.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent evt) {
                if (evt.getCode() == KeyCode.ENTER && evt.isControlDown()) {
                    TextAreaTableCell.this.commitEdit(TextAreaTableCell.this.textArea.getText());
                    evt.consume();
                }
            }
        });
        this.setGraphic((Node)this.textArea);
    }

    public void commitEdit(String newValue) {
        super.commitEdit((Object)newValue);
        this.textNode.textProperty().set((Object)newValue);
        this.setGraphic((Node)this.textNode);
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setGraphic((Node)this.textNode);
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.textArea.setText(item);
            this.textArea.wrapTextProperty().set(true);
            this.setGraphic((Node)this.textArea);
        } else {
            this.textNode = new Text(item);
            this.textNode.wrappingWidthProperty().bind((ObservableValue)this.widthProperty());
            this.setGraphic((Node)this.textNode);
        }
    }

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return param -> new TextAreaTableCell();
    }
}

