/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.api.model.Group;
import org.corpus_tools.annis.api.model.ImportResult;
import org.corpus_tools.annis.api.model.InlineObject;
import org.corpus_tools.annis.api.model.InlineResponse202;

public class AdministrationApi {
    private ApiClient localVarApiClient;

    public AdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdministrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteGroupCall(String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteGroup(Async)");
        }
        Call localVarCall = this.deleteGroupCall(name, _callback);
        return localVarCall;
    }

    public void deleteGroup(String name) throws ApiException {
        this.deleteGroupWithHttpInfo(name);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String name) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call exportPostCall(InlineObject inlineObject, ApiCallback _callback) throws ApiException {
        InlineObject localVarPostBody = inlineObject;
        String localVarPath = "/export";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call exportPostValidateBeforeCall(InlineObject inlineObject, ApiCallback _callback) throws ApiException {
        if (inlineObject == null) {
            throw new ApiException("Missing the required parameter 'inlineObject' when calling exportPost(Async)");
        }
        Call localVarCall = this.exportPostCall(inlineObject, _callback);
        return localVarCall;
    }

    public InlineResponse202 exportPost(InlineObject inlineObject) throws ApiException {
        ApiResponse localVarResp = this.exportPostWithHttpInfo(inlineObject);
        return (InlineResponse202)localVarResp.getData();
    }

    public ApiResponse<InlineResponse202> exportPostWithHttpInfo(InlineObject inlineObject) throws ApiException {
        Call localVarCall = this.exportPostValidateBeforeCall(inlineObject, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call exportPostAsync(InlineObject inlineObject, ApiCallback<InlineResponse202> _callback) throws ApiException {
        Call localVarCall = this.exportPostValidateBeforeCall(inlineObject, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJobCall(String uuid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/jobs/{uuid}".replaceAll("\\{uuid\\}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobValidateBeforeCall(String uuid, ApiCallback _callback) throws ApiException {
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getJob(Async)");
        }
        Call localVarCall = this.getJobCall(uuid, _callback);
        return localVarCall;
    }

    public void getJob(String uuid) throws ApiException {
        this.getJobWithHttpInfo(uuid);
    }

    public ApiResponse<Void> getJobWithHttpInfo(String uuid) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(uuid, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call getJobAsync(String uuid, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(uuid, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call importPostCall(File body, Boolean overrideExisting, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        File localVarPostBody = body;
        String localVarPath = "/import";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (overrideExisting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("override_existing", (Object)overrideExisting));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importPostValidateBeforeCall(File body, Boolean overrideExisting, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling importPost(Async)");
        }
        Call localVarCall = this.importPostCall(body, overrideExisting, _callback);
        return localVarCall;
    }

    public ImportResult importPost(File body, Boolean overrideExisting) throws ApiException {
        ApiResponse localVarResp = this.importPostWithHttpInfo(body, overrideExisting);
        return (ImportResult)localVarResp.getData();
    }

    public ApiResponse<ImportResult> importPostWithHttpInfo(File body, Boolean overrideExisting) throws ApiException {
        Call localVarCall = this.importPostValidateBeforeCall(body, overrideExisting, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call importPostAsync(File body, Boolean overrideExisting, ApiCallback<ImportResult> _callback) throws ApiException {
        Call localVarCall = this.importPostValidateBeforeCall(body, overrideExisting, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGroupsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listGroupsCall(_callback);
        return localVarCall;
    }

    public List<Group> listGroups() throws ApiException {
        ApiResponse localVarResp = this.listGroupsWithHttpInfo();
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<Group>> listGroupsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listGroupsAsync(ApiCallback<List<Group>> _callback) throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(_callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putGroupCall(String name, Group group, ApiCallback _callback) throws ApiException {
        Group localVarPostBody = group;
        String localVarPath = "/groups/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putGroupValidateBeforeCall(String name, Group group, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling putGroup(Async)");
        }
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling putGroup(Async)");
        }
        Call localVarCall = this.putGroupCall(name, group, _callback);
        return localVarCall;
    }

    public void putGroup(String name, Group group) throws ApiException {
        this.putGroupWithHttpInfo(name, group);
    }

    public ApiResponse<Void> putGroupWithHttpInfo(String name, Group group) throws ApiException {
        Call localVarCall = this.putGroupValidateBeforeCall(name, group, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putGroupAsync(String name, Group group, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putGroupValidateBeforeCall(name, group, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

