/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.SubgraphWithContext;

public class CorporaApi {
    private ApiClient localVarApiClient;

    public CorporaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call componentsCall(String corpus, String type, String name, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/components".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", (Object)type));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", (Object)name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call componentsValidateBeforeCall(String corpus, String type, String name, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling components(Async)");
        }
        Call localVarCall = this.componentsCall(corpus, type, name, _callback);
        return localVarCall;
    }

    public List<Component> components(String corpus, String type, String name) throws ApiException {
        ApiResponse localVarResp = this.componentsWithHttpInfo(corpus, type, name);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<Component>> componentsWithHttpInfo(String corpus, String type, String name) throws ApiException {
        Call localVarCall = this.componentsValidateBeforeCall(corpus, type, name, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call componentsAsync(String corpus, String type, String name, ApiCallback<List<Component>> _callback) throws ApiException {
        Call localVarCall = this.componentsValidateBeforeCall(corpus, type, name, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call corpusConfigurationCall(String corpus, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/configuration".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call corpusConfigurationValidateBeforeCall(String corpus, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling corpusConfiguration(Async)");
        }
        Call localVarCall = this.corpusConfigurationCall(corpus, _callback);
        return localVarCall;
    }

    public CorpusConfiguration corpusConfiguration(String corpus) throws ApiException {
        ApiResponse localVarResp = this.corpusConfigurationWithHttpInfo(corpus);
        return (CorpusConfiguration)localVarResp.getData();
    }

    public ApiResponse<CorpusConfiguration> corpusConfigurationWithHttpInfo(String corpus) throws ApiException {
        Call localVarCall = this.corpusConfigurationValidateBeforeCall(corpus, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call corpusConfigurationAsync(String corpus, ApiCallback<CorpusConfiguration> _callback) throws ApiException {
        Call localVarCall = this.corpusConfigurationValidateBeforeCall(corpus, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCorpusCall(String corpus, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCorpusValidateBeforeCall(String corpus, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling deleteCorpus(Async)");
        }
        Call localVarCall = this.deleteCorpusCall(corpus, _callback);
        return localVarCall;
    }

    public void deleteCorpus(String corpus) throws ApiException {
        this.deleteCorpusWithHttpInfo(corpus);
    }

    public ApiResponse<Void> deleteCorpusWithHttpInfo(String corpus) throws ApiException {
        Call localVarCall = this.deleteCorpusValidateBeforeCall(corpus, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCorpusAsync(String corpus, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCorpusValidateBeforeCall(corpus, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call edgeAnnotationsCall(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/edge-annotations/{type}/{layer}/{name}/".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString())).replaceAll("\\{type\\}", this.localVarApiClient.escapeString(type.toString())).replaceAll("\\{layer\\}", this.localVarApiClient.escapeString(layer.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (listValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("list_values", (Object)listValues));
        }
        if (onlyMostFrequentValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("only_most_frequent_values", (Object)onlyMostFrequentValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call edgeAnnotationsValidateBeforeCall(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling edgeAnnotations(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling edgeAnnotations(Async)");
        }
        if (layer == null) {
            throw new ApiException("Missing the required parameter 'layer' when calling edgeAnnotations(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling edgeAnnotations(Async)");
        }
        Call localVarCall = this.edgeAnnotationsCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, _callback);
        return localVarCall;
    }

    public List<Annotation> edgeAnnotations(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        ApiResponse localVarResp = this.edgeAnnotationsWithHttpInfo(corpus, type, layer, name, listValues, onlyMostFrequentValues);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<Annotation>> edgeAnnotationsWithHttpInfo(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        Call localVarCall = this.edgeAnnotationsValidateBeforeCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call edgeAnnotationsAsync(String corpus, String type, String layer, String name, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback<List<Annotation>> _callback) throws ApiException {
        Call localVarCall = this.edgeAnnotationsValidateBeforeCall(corpus, type, layer, name, listValues, onlyMostFrequentValues, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFileCall(String corpus, String name, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/files/{name}".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"default"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileValidateBeforeCall(String corpus, String name, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling getFile(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getFile(Async)");
        }
        Call localVarCall = this.getFileCall(corpus, name, _callback);
        return localVarCall;
    }

    public File getFile(String corpus, String name) throws ApiException {
        ApiResponse localVarResp = this.getFileWithHttpInfo(corpus, name);
        return (File)localVarResp.getData();
    }

    public ApiResponse<File> getFileWithHttpInfo(String corpus, String name) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(corpus, name, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFileAsync(String corpus, String name, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getFileValidateBeforeCall(corpus, name, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCorporaCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/corpora";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCorporaValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCorporaCall(_callback);
        return localVarCall;
    }

    public List<String> listCorpora() throws ApiException {
        ApiResponse localVarResp = this.listCorporaWithHttpInfo();
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<String>> listCorporaWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCorporaValidateBeforeCall(null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCorporaAsync(ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.listCorporaValidateBeforeCall(_callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listFilesCall(String corpus, String node, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/files".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (node != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("node", (Object)node));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"default"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFilesValidateBeforeCall(String corpus, String node, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling listFiles(Async)");
        }
        Call localVarCall = this.listFilesCall(corpus, node, _callback);
        return localVarCall;
    }

    public List<String> listFiles(String corpus, String node) throws ApiException {
        ApiResponse localVarResp = this.listFilesWithHttpInfo(corpus, node);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<String>> listFilesWithHttpInfo(String corpus, String node) throws ApiException {
        Call localVarCall = this.listFilesValidateBeforeCall(corpus, node, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFilesAsync(String corpus, String node, ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.listFilesValidateBeforeCall(corpus, node, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call nodeAnnotationsCall(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/node-annotations".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (listValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("list_values", (Object)listValues));
        }
        if (onlyMostFrequentValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("only_most_frequent_values", (Object)onlyMostFrequentValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call nodeAnnotationsValidateBeforeCall(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling nodeAnnotations(Async)");
        }
        Call localVarCall = this.nodeAnnotationsCall(corpus, listValues, onlyMostFrequentValues, _callback);
        return localVarCall;
    }

    public List<Annotation> nodeAnnotations(String corpus, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        ApiResponse localVarResp = this.nodeAnnotationsWithHttpInfo(corpus, listValues, onlyMostFrequentValues);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<Annotation>> nodeAnnotationsWithHttpInfo(String corpus, Boolean listValues, Boolean onlyMostFrequentValues) throws ApiException {
        Call localVarCall = this.nodeAnnotationsValidateBeforeCall(corpus, listValues, onlyMostFrequentValues, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call nodeAnnotationsAsync(String corpus, Boolean listValues, Boolean onlyMostFrequentValues, ApiCallback<List<Annotation>> _callback) throws ApiException {
        Call localVarCall = this.nodeAnnotationsValidateBeforeCall(corpus, listValues, onlyMostFrequentValues, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subgraphForNodesCall(String corpus, SubgraphWithContext subgraphWithContext, ApiCallback _callback) throws ApiException {
        SubgraphWithContext localVarPostBody = subgraphWithContext;
        String localVarPath = "/corpora/{corpus}/subgraph".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subgraphForNodesValidateBeforeCall(String corpus, SubgraphWithContext subgraphWithContext, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForNodes(Async)");
        }
        if (subgraphWithContext == null) {
            throw new ApiException("Missing the required parameter 'subgraphWithContext' when calling subgraphForNodes(Async)");
        }
        Call localVarCall = this.subgraphForNodesCall(corpus, subgraphWithContext, _callback);
        return localVarCall;
    }

    public File subgraphForNodes(String corpus, SubgraphWithContext subgraphWithContext) throws ApiException {
        ApiResponse localVarResp = this.subgraphForNodesWithHttpInfo(corpus, subgraphWithContext);
        return (File)localVarResp.getData();
    }

    public ApiResponse<File> subgraphForNodesWithHttpInfo(String corpus, SubgraphWithContext subgraphWithContext) throws ApiException {
        Call localVarCall = this.subgraphForNodesValidateBeforeCall(corpus, subgraphWithContext, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subgraphForNodesAsync(String corpus, SubgraphWithContext subgraphWithContext, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.subgraphForNodesValidateBeforeCall(corpus, subgraphWithContext, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subgraphForQueryCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/subgraph-for-query".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", (Object)query));
        }
        if (queryLanguage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query_language", (Object)queryLanguage));
        }
        if (componentTypeFilter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("component_type_filter", (Object)componentTypeFilter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subgraphForQueryValidateBeforeCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForQuery(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling subgraphForQuery(Async)");
        }
        Call localVarCall = this.subgraphForQueryCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        return localVarCall;
    }

    public File subgraphForQuery(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        ApiResponse localVarResp = this.subgraphForQueryWithHttpInfo(corpus, query, queryLanguage, componentTypeFilter);
        return (File)localVarResp.getData();
    }

    public ApiResponse<File> subgraphForQueryWithHttpInfo(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        Call localVarCall = this.subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subgraphForQueryAsync(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

