/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.ApiResponse;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.CountExtra;
import org.corpus_tools.annis.api.model.CountQuery;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.FrequencyQuery;
import org.corpus_tools.annis.api.model.FrequencyTableRow;
import org.corpus_tools.annis.api.model.QueryAttributeDescription;
import org.corpus_tools.annis.api.model.QueryLanguage;

public class SearchApi {
    private ApiClient localVarApiClient;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call countCall(CountQuery countQuery, ApiCallback _callback) throws ApiException {
        CountQuery localVarPostBody = countQuery;
        String localVarPath = "/search/count";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call countValidateBeforeCall(CountQuery countQuery, ApiCallback _callback) throws ApiException {
        if (countQuery == null) {
            throw new ApiException("Missing the required parameter 'countQuery' when calling count(Async)");
        }
        Call localVarCall = this.countCall(countQuery, _callback);
        return localVarCall;
    }

    public CountExtra count(CountQuery countQuery) throws ApiException {
        ApiResponse localVarResp = this.countWithHttpInfo(countQuery);
        return (CountExtra)localVarResp.getData();
    }

    public ApiResponse<CountExtra> countWithHttpInfo(CountQuery countQuery) throws ApiException {
        Call localVarCall = this.countValidateBeforeCall(countQuery, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call countAsync(CountQuery countQuery, ApiCallback<CountExtra> _callback) throws ApiException {
        Call localVarCall = this.countValidateBeforeCall(countQuery, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call findCall(FindQuery findQuery, ApiCallback _callback) throws ApiException {
        FindQuery localVarPostBody = findQuery;
        String localVarPath = "/search/find";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findValidateBeforeCall(FindQuery findQuery, ApiCallback _callback) throws ApiException {
        if (findQuery == null) {
            throw new ApiException("Missing the required parameter 'findQuery' when calling find(Async)");
        }
        Call localVarCall = this.findCall(findQuery, _callback);
        return localVarCall;
    }

    public File find(FindQuery findQuery) throws ApiException {
        ApiResponse localVarResp = this.findWithHttpInfo(findQuery);
        return (File)localVarResp.getData();
    }

    public ApiResponse<File> findWithHttpInfo(FindQuery findQuery) throws ApiException {
        Call localVarCall = this.findValidateBeforeCall(findQuery, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call findAsync(FindQuery findQuery, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.findValidateBeforeCall(findQuery, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call frequencyCall(FrequencyQuery frequencyQuery, ApiCallback _callback) throws ApiException {
        FrequencyQuery localVarPostBody = frequencyQuery;
        String localVarPath = "/search/frequency";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call frequencyValidateBeforeCall(FrequencyQuery frequencyQuery, ApiCallback _callback) throws ApiException {
        if (frequencyQuery == null) {
            throw new ApiException("Missing the required parameter 'frequencyQuery' when calling frequency(Async)");
        }
        Call localVarCall = this.frequencyCall(frequencyQuery, _callback);
        return localVarCall;
    }

    public List<FrequencyTableRow> frequency(FrequencyQuery frequencyQuery) throws ApiException {
        ApiResponse localVarResp = this.frequencyWithHttpInfo(frequencyQuery);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<FrequencyTableRow>> frequencyWithHttpInfo(FrequencyQuery frequencyQuery) throws ApiException {
        Call localVarCall = this.frequencyValidateBeforeCall(frequencyQuery, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call frequencyAsync(FrequencyQuery frequencyQuery, ApiCallback<List<FrequencyTableRow>> _callback) throws ApiException {
        Call localVarCall = this.frequencyValidateBeforeCall(frequencyQuery, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call nodeDescriptionsCall(String query, QueryLanguage queryLanguage, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/search/node-descriptions";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", (Object)query));
        }
        if (queryLanguage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query_language", (Object)queryLanguage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call nodeDescriptionsValidateBeforeCall(String query, QueryLanguage queryLanguage, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.nodeDescriptionsCall(query, queryLanguage, _callback);
        return localVarCall;
    }

    public List<QueryAttributeDescription> nodeDescriptions(String query, QueryLanguage queryLanguage) throws ApiException {
        ApiResponse localVarResp = this.nodeDescriptionsWithHttpInfo(query, queryLanguage);
        return (List)localVarResp.getData();
    }

    public ApiResponse<List<QueryAttributeDescription>> nodeDescriptionsWithHttpInfo(String query, QueryLanguage queryLanguage) throws ApiException {
        Call localVarCall = this.nodeDescriptionsValidateBeforeCall(query, queryLanguage, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call nodeDescriptionsAsync(String query, QueryLanguage queryLanguage, ApiCallback<List<QueryAttributeDescription>> _callback) throws ApiException {
        Call localVarCall = this.nodeDescriptionsValidateBeforeCall(query, queryLanguage, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call subgraphForQueryCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/corpora/{corpus}/subgraph-for-query".replaceAll("\\{corpus\\}", this.localVarApiClient.escapeString(corpus.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", (Object)query));
        }
        if (queryLanguage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query_language", (Object)queryLanguage));
        }
        if (componentTypeFilter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("component_type_filter", (Object)componentTypeFilter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call subgraphForQueryValidateBeforeCall(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback _callback) throws ApiException {
        if (corpus == null) {
            throw new ApiException("Missing the required parameter 'corpus' when calling subgraphForQuery(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling subgraphForQuery(Async)");
        }
        Call localVarCall = this.subgraphForQueryCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        return localVarCall;
    }

    public File subgraphForQuery(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        ApiResponse localVarResp = this.subgraphForQueryWithHttpInfo(corpus, query, queryLanguage, componentTypeFilter);
        return (File)localVarResp.getData();
    }

    public ApiResponse<File> subgraphForQueryWithHttpInfo(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter) throws ApiException {
        Call localVarCall = this.subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, null);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call subgraphForQueryAsync(String corpus, String query, QueryLanguage queryLanguage, AnnotationComponentType componentTypeFilter, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.subgraphForQueryValidateBeforeCall(corpus, query, queryLanguage, componentTypeFilter, _callback);
        Type localVarReturnType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

