/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.corpus_tools.annis.api.model.AnnotationComponentType;

@ApiModel(description="Definition of an edge component")
public class Component
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private AnnotationComponentType type;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_LAYER = "layer";
    @SerializedName(value="layer")
    private String layer;

    public Component type(AnnotationComponentType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AnnotationComponentType getType() {
        return this.type;
    }

    public void setType(AnnotationComponentType type) {
        this.type = type;
    }

    public Component name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="dep", value="Name of the component")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component layer(String layer) {
        this.layer = layer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="conll", value="A layer name which allows to group different components into the same layer. Can be the empty string.")
    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return Objects.equals(this.type, component.type) && Objects.equals(this.name, component.name) && Objects.equals(this.layer, component.layer);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.layer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Component {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    layer: ").append(this.toIndentedString((Object)this.layer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

