/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.corpus_tools.annis.api.model.FrequencyQueryDefinition;
import org.corpus_tools.annis.api.model.QueryLanguage;

@ApiModel(description="Query definition to find matches")
public class FrequencyQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_QUERY_LANGUAGE = "query_language";
    @SerializedName(value="query_language")
    private QueryLanguage queryLanguage = QueryLanguage.AQL;
    public static final String SERIALIZED_NAME_CORPORA = "corpora";
    @SerializedName(value="corpora")
    private List<String> corpora = null;
    public static final String SERIALIZED_NAME_DEFINITION = "definition";
    @SerializedName(value="definition")
    private List<FrequencyQueryDefinition> definition = null;

    public FrequencyQuery query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="root#const:cat=/(ROOT|S)/", value="The query to execute.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public FrequencyQuery queryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(QueryLanguage queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public FrequencyQuery corpora(List<String> corpora) {
        this.corpora = corpora;
        return this;
    }

    public FrequencyQuery addCorporaItem(String corporaItem) {
        if (this.corpora == null) {
            this.corpora = new ArrayList();
        }
        this.corpora.add(corporaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"GUM\",\"pcc2.1\"]", value="List of corpus names/identifiers.")
    public List<String> getCorpora() {
        return this.corpora;
    }

    public void setCorpora(List<String> corpora) {
        this.corpora = corpora;
    }

    public FrequencyQuery definition(List<FrequencyQueryDefinition> definition) {
        this.definition = definition;
        return this;
    }

    public FrequencyQuery addDefinitionItem(FrequencyQueryDefinition definitionItem) {
        if (this.definition == null) {
            this.definition = new ArrayList();
        }
        this.definition.add(definitionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<FrequencyQueryDefinition> getDefinition() {
        return this.definition;
    }

    public void setDefinition(List<FrequencyQueryDefinition> definition) {
        this.definition = definition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyQuery frequencyQuery = (FrequencyQuery)o;
        return Objects.equals(this.query, frequencyQuery.query) && Objects.equals(this.queryLanguage, frequencyQuery.queryLanguage) && Objects.equals(this.corpora, frequencyQuery.corpora) && Objects.equals(this.definition, frequencyQuery.definition);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.queryLanguage, this.corpora, this.definition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FrequencyQuery {\n");
        sb.append("    query: ").append(this.toIndentedString((Object)this.query)).append("\n");
        sb.append("    queryLanguage: ").append(this.toIndentedString((Object)this.queryLanguage)).append("\n");
        sb.append("    corpora: ").append(this.toIndentedString((Object)this.corpora)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString((Object)this.definition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

