/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines a subgraph of an annotation graph using node IDs and a context.")
public class SubgraphWithContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NODE_IDS = "node_ids";
    @SerializedName(value="node_ids")
    private List<String> nodeIds = null;
    public static final String SERIALIZED_NAME_SEGMENTATION = "segmentation";
    @SerializedName(value="segmentation")
    private String segmentation = "null";
    public static final String SERIALIZED_NAME_LEFT = "left";
    @SerializedName(value="left")
    private Integer left = 0;
    public static final String SERIALIZED_NAME_RIGHT = "right";
    @SerializedName(value="right")
    private Integer right = 0;

    public SubgraphWithContext nodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
        return this;
    }

    public SubgraphWithContext addNodeIdsItem(String nodeIdsItem) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList();
        }
        this.nodeIds.add(nodeIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"GUM/GUM_whow_skittles#tok_925\",\"GUM/GUM_whow_skittles#tok_926\"]", value="A list of node IDs that should be part of the subgraph.")
    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public SubgraphWithContext segmentation(String segmentation) {
        this.segmentation = segmentation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Segmentation to use for defining the context, Set to null or omit it if tokens should be used.")
    public String getSegmentation() {
        return this.segmentation;
    }

    public void setSegmentation(String segmentation) {
        this.segmentation = segmentation;
    }

    public SubgraphWithContext left(Integer left) {
        this.left = left;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Left context size.")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public SubgraphWithContext right(Integer right) {
        this.right = right;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="Right context size.")
    public Integer getRight() {
        return this.right;
    }

    public void setRight(Integer right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubgraphWithContext subgraphWithContext = (SubgraphWithContext)o;
        return Objects.equals(this.nodeIds, subgraphWithContext.nodeIds) && Objects.equals(this.segmentation, subgraphWithContext.segmentation) && Objects.equals(this.left, subgraphWithContext.left) && Objects.equals(this.right, subgraphWithContext.right);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIds, this.segmentation, this.left, this.right);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubgraphWithContext {\n");
        sb.append("    nodeIds: ").append(this.toIndentedString((Object)this.nodeIds)).append("\n");
        sb.append("    segmentation: ").append(this.toIndentedString((Object)this.segmentation)).append("\n");
        sb.append("    left: ").append(this.toIndentedString((Object)this.left)).append("\n");
        sb.append("    right: ").append(this.toIndentedString((Object)this.right)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

