/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.Charsets;
import com.google.common.eventbus.EventBus;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.vaadin.annotations.Theme;
import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.server.ClassResource;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Theme(value="annis")
public class AnnisBaseUI
extends UI
implements Serializable {
    private static final long serialVersionUID = 1953089184783346987L;
    private static final Logger log;
    public static final Resource PINGUIN_IMAGE;
    private TreeSet<String> alreadyAddedCSS = new TreeSet();
    private transient EventBus loginDataLostBus;

    public static List<File> getAllConfigLocations(String configFile) {
        LinkedList<File> locations = new LinkedList<File>();
        locations.add(new File(VaadinService.getCurrent().getBaseDirectory(), "/WEB-INF/conf/" + configFile));
        String globalConfigDir = System.getenv("ANNIS_CFG");
        if (globalConfigDir == null) {
            globalConfigDir = "/etc/annis";
        }
        locations.add(new File(globalConfigDir + "/" + configFile));
        locations.add(new File(System.getProperty("user.home") + "/.annis/" + configFile));
        return locations;
    }

    public void attach() {
        super.attach();
        this.alreadyAddedCSS.clear();
    }

    public EventBus getLoginDataLostBus() {
        if (this.loginDataLostBus == null) {
            this.loginDataLostBus = new EventBus();
        }
        return this.loginDataLostBus;
    }

    protected void init(VaadinRequest request) {
        this.alreadyAddedCSS.clear();
    }

    public void injectUniqueCSS(String cssContent) {
        this.injectUniqueCSS(cssContent, null);
    }

    public void injectUniqueCSS(String cssContent, String wrapperClass) {
        String hashForCssContent;
        if (this.alreadyAddedCSS == null) {
            this.alreadyAddedCSS = new TreeSet();
        }
        if (wrapperClass != null) {
            cssContent = this.wrapCSS(cssContent, wrapperClass);
        }
        if (!this.alreadyAddedCSS.contains(hashForCssContent = Hashing.md5().hashString((CharSequence)cssContent, Charsets.UTF_8).toString())) {
            this.getPage().getStyles().add(cssContent);
            this.alreadyAddedCSS.add(hashForCssContent);
        }
    }

    protected Map<String, InstanceConfig> loadInstanceConfig() {
        TreeMap<String, InstanceConfig> result = new TreeMap<String, InstanceConfig>();
        JsonMapper mapper = new JsonMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List locations = AnnisBaseUI.getAllConfigLocations((String)"instances");
        for (File root : locations) {
            File[] instanceFiles;
            if (!root.isDirectory() || (instanceFiles = root.listFiles((FilenameFilter)new SuffixFileFilter(".json"))) == null) continue;
            for (File i : instanceFiles) {
                if (!i.isFile() || !i.canRead()) continue;
                try {
                    InstanceConfig config = (InstanceConfig)mapper.readValue(i, InstanceConfig.class);
                    String name = StringUtils.removeEnd((String)i.getName(), (String)".json");
                    config.setInstanceName(name);
                    result.put(name, config);
                }
                catch (IOException ex) {
                    log.warn("could not parse instance config: " + ex.getMessage());
                }
            }
        }
        if (!result.containsKey("default")) {
            InstanceConfig cfgDefault = new InstanceConfig();
            cfgDefault.setInstanceDisplayName("ANNIS");
            result.put("default", cfgDefault);
        }
        return result;
    }

    private String wrapCSS(String cssContent, String wrapperClass) {
        try {
            String wrappedContent = wrapperClass == null ? cssContent : "." + wrapperClass + "{\n" + cssContent + "\n}";
            File tmpFile = File.createTempFile("annis-stylesheet", ".scss");
            Files.write((CharSequence)wrappedContent, (File)tmpFile, (Charset)Charsets.UTF_8);
            ScssStylesheet styleSheet = ScssStylesheet.get((String)tmpFile.getCanonicalPath());
            styleSheet.compile();
            return styleSheet.printState();
        }
        catch (IOException ex) {
            log.error("IOException when compiling wrapped CSS", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error("Could not compile wrapped CSS", (Throwable)ex);
        }
        return null;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        log = LoggerFactory.getLogger(AnnisBaseUI.class);
        PINGUIN_IMAGE = new ClassResource("/org.corpus_tools.annis/libgui/penguins.png");
    }
}

