/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Widgetset;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.Extension;
import com.vaadin.server.Page;
import com.vaadin.server.RequestHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.LoginListener;
import org.corpus_tools.annis.gui.MainToolbar;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.SearchView;
import org.corpus_tools.annis.gui.ServiceStarter;
import org.corpus_tools.annis.gui.Sidebar;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.admin.AdminView;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.corpus_tools.annis.gui.query_references.UrlShortener;
import org.corpus_tools.annis.gui.querybuilder.QueryBuilderPlugin;
import org.corpus_tools.annis.gui.requesthandler.BinaryRequestHandler;
import org.corpus_tools.annis.gui.visualizers.VisualizerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Theme(value="annis")
@Widgetset(value="org.corpus_tools.annis.gui.widgets.gwt.AnnisWidgetSet")
@SpringUI(path="/*")
@Push(value=PushMode.AUTOMATIC)
public class AnnisUI
extends CommonUI
implements ErrorHandler,
ViewChangeListener {
    private static final Profiles DESKTOP_PROFILES = Profiles.of((String[])new String[]{"desktop & !test"});
    private static final long serialVersionUID = 3022711576267350005L;
    private static final Logger log = LoggerFactory.getLogger(AnnisUI.class);
    private transient Cache<String, CorpusConfiguration> corpusConfigCache;
    private final QueryUIState queryState = new QueryUIState();
    private QueryController queryController;
    private SearchView searchView;
    @Autowired
    private List<VisualizerPlugin> visualizerPlugins;
    @Autowired
    private List<QueryBuilderPlugin<Component>> queryBuilderPlugins;
    @Autowired
    private List<ExporterPlugin> exporterPlugins;
    @Autowired
    private UrlShortener urlShortener;
    @Autowired
    private UIConfig config;
    private AdminView adminView;
    private Navigator nav;
    @Autowired
    private Environment environment;
    @Autowired
    private ServiceStarter serviceStarter;
    @Autowired(required=false)
    private OAuth2ClientProperties oauth2Clients;
    @Autowired
    private transient ServletContext servletContext;
    private MainToolbar toolbar;

    public AnnisUI() {
        super("");
        this.initTransients();
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.searchView.setToolbar(null);
        this.adminView.setToolbar(null);
        this.toolbar.setSidebar(null);
        if (event.getNewView() == this.searchView) {
            this.searchView.setToolbar(this.toolbar);
            this.toolbar.setSidebar((Sidebar)this.searchView);
            this.toolbar.setNavigationTarget(MainToolbar.NavigationTarget.ADMIN, (UI)this);
        } else if (event.getNewView() == this.adminView) {
            this.adminView.setToolbar(this.toolbar);
            this.toolbar.setNavigationTarget(MainToolbar.NavigationTarget.SEARCH, (UI)this);
        } else {
            this.toolbar.setNavigationTarget(null, (UI)this);
        }
        return true;
    }

    public boolean canReportBugs() {
        if (this.toolbar != null) {
            return this.toolbar.canReportBugs();
        }
        return false;
    }

    public void clearCorpusConfigCache() {
        if (this.corpusConfigCache != null) {
            this.corpusConfigCache.invalidateAll();
        }
    }

    public void error(ErrorEvent event) {
        log.error("Unknown error in some component: " + event.getThrowable().getLocalizedMessage(), event.getThrowable());
        Throwable source = event.getThrowable();
        while (source.getCause() != null) {
            source = source.getCause();
        }
        ExceptionDialog.show((Throwable)source, (UI)this);
    }

    public CorpusConfiguration getCorpusConfigWithCache(String corpus) {
        CorpusConfiguration config = new CorpusConfiguration();
        if (this.corpusConfigCache != null && (config = (CorpusConfiguration)this.corpusConfigCache.getIfPresent((Object)corpus)) == null) {
            config = corpus.equals("default-config") ? Helper.getDefaultCorpusConfig() : Helper.getCorpusConfig((String)corpus, (UI)this);
            this.corpusConfigCache.put((Object)corpus, (Object)config);
        }
        return config;
    }

    public QueryController getQueryController() {
        return this.queryController;
    }

    public QueryUIState getQueryState() {
        return this.queryState;
    }

    public SearchView getSearchView() {
        return this.searchView;
    }

    protected void init(VaadinRequest request) {
        Object fragmentToRestore;
        Optional uri;
        super.init(request);
        this.getSession().addRequestHandler((RequestHandler)new BinaryRequestHandler(this.getUrlPrefix(), (CommonUI)this));
        String id = request.getParameter("id");
        if (id != null && (uri = this.urlShortener.unshorten(UUID.fromString(id))).isPresent()) {
            Page.getCurrent().setLocation((URI)uri.get());
            return;
        }
        this.setErrorHandler((ErrorHandler)this);
        this.adminView = new AdminView(this);
        this.toolbar = new MainToolbar(this.getConfig(), this.oauth2Clients);
        this.toolbar.setQueryController(this.queryController);
        this.searchView = new SearchView(this);
        this.queryController = new QueryController(this, this.searchView, this.queryState);
        this.toolbar.addLoginListener((LoginListener)this.searchView);
        this.toolbar.addLoginListener((LoginListener)this.adminView);
        this.nav = new Navigator((UI)this, (SingleComponentContainer)this);
        this.nav.addView("", (View)this.searchView);
        this.nav.addView("admin", (View)this.adminView);
        this.nav.addViewChangeListener((ViewChangeListener)this);
        this.addExtension((Extension)this.toolbar.getScreenshotExtension());
        this.loadInstanceFonts();
        Optional desktopUser = this.serviceStarter.getDesktopUserToken();
        if (desktopUser.isPresent()) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)desktopUser.get();
            this.getSecurityContext().setAuthentication((Authentication)token);
            this.getToolbar().onLogin();
        }
        if ((fragmentToRestore = VaadinSession.getCurrent().getAttribute("ANNIS_FRAGENT_TO_RESTORE")) instanceof String) {
            request.getWrappedSession().setAttribute("ANNIS_FRAGENT_TO_RESTORE", null);
            Page.getCurrent().setUriFragment((String)fragmentToRestore);
        }
    }

    public UIConfig getConfig() {
        return this.config;
    }

    public boolean isDesktopMode() {
        return this.environment.acceptsProfiles(DESKTOP_PROFILES);
    }

    private void initTransients() {
        this.corpusConfigCache = CacheBuilder.newBuilder().maximumSize(250L).build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    public void reportBug(Throwable cause) {
        this.toolbar.reportBug(cause);
    }

    public MainToolbar getToolbar() {
        return this.toolbar;
    }

    public List<VisualizerPlugin> getVisualizerPlugins() {
        return this.visualizerPlugins;
    }

    public List<QueryBuilderPlugin<Component>> getQueryBuilderPlugins() {
        return this.queryBuilderPlugins;
    }

    public List<ExporterPlugin> getExporterPlugins() {
        return this.exporterPlugins;
    }

    public UrlShortener getUrlShortener() {
        return this.urlShortener;
    }

    public void setUrlShortener(UrlShortener urlShortener) {
        this.urlShortener = urlShortener;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public OAuth2ClientProperties getOauth2ClientProperties() {
        return this.oauth2Clients;
    }
}

