/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.server.Page;
import com.vaadin.server.RequestHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Notification;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContext;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.Configuration;
import org.corpus_tools.annis.auth.Authentication;
import org.corpus_tools.annis.auth.HttpBearerAuth;
import org.corpus_tools.annis.gui.AnnisBaseUI;
import org.corpus_tools.annis.gui.FontConfig;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.components.SettingsStorage;
import org.corpus_tools.annis.gui.requesthandler.ResourceRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public abstract class CommonUI
extends AnnisBaseUI {
    private static final long serialVersionUID = -1304604048896817844L;
    private static final Logger log = LoggerFactory.getLogger(CommonUI.class);
    private SettingsStorage settings;
    private final String urlPrefix;
    private InstanceConfig instanceConfig;
    private SecurityContext securityContext;

    protected CommonUI(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    private InstanceConfig getInstanceConfig(VaadinRequest request) {
        String instance = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        if (pathInfo != null && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        Map allConfigs = this.loadInstanceConfig();
        if (pathInfo != null && !pathInfo.isEmpty()) {
            instance = pathInfo;
        }
        if (instance != null && allConfigs.containsKey(instance)) {
            return (InstanceConfig)allConfigs.get(instance);
        }
        if (allConfigs.containsKey("default")) {
            return (InstanceConfig)allConfigs.get("default");
        }
        if (allConfigs.size() > 0) {
            log.warn("Instance config {} not found or null and default config is not available.", (Object)instance);
            return (InstanceConfig)allConfigs.values().iterator().next();
        }
        return new InstanceConfig();
    }

    public FontConfig getInstanceFont() {
        if (this.instanceConfig != null && this.instanceConfig.getFont() != null) {
            return this.instanceConfig.getFont();
        }
        return null;
    }

    public SettingsStorage getSettings() {
        if (this.settings == null) {
            this.settings = new SettingsStorage(this);
        }
        return this.settings;
    }

    protected void init(VaadinRequest request) {
        super.init(request);
        this.getSession().addRequestHandler((RequestHandler)new ResourceRequestHandler(this.urlPrefix));
        this.settings = new SettingsStorage(this);
        this.instanceConfig = this.getInstanceConfig(request);
    }

    protected void loadInstanceFonts() {
        if (this.getInstanceConfig() != null && this.getInstanceConfig().getFont() != null) {
            String url;
            FontConfig cfg = this.getInstanceConfig().getFont();
            String string = url = cfg.getUrl() == null || cfg.getUrl().isEmpty() ? "" : "@import url(" + cfg.getUrl() + ");\n";
            if (cfg.getSize() == null || cfg.getSize().isEmpty()) {
                this.injectUniqueCSS(url + "." + "corpus-font-force" + " {font-family: '" + cfg.getName() + "', monospace !important; }\n." + "corpus-font" + " {font-family: '" + cfg.getName() + "', monospace; }\ndiv." + "corpus-font" + " .CodeMirror pre {font-family: '" + cfg.getName() + "', monospace; }\n#keyboardInputMaster tbody tr td table tbody tr td {\n  font-family: '" + cfg.getName() + "', 'Lucida Console','Arial Unicode MS',monospace; }");
            } else {
                this.injectUniqueCSS(url + "." + "corpus-font-force" + " {\n  font-family: '" + cfg.getName() + "', monospace !important;\n  font-size: " + cfg.getSize() + " !important;\n}\n." + "corpus-font" + " {\n  font-family: '" + cfg.getName() + "', monospace;\n  font-size: " + cfg.getSize() + ";\n}\ndiv." + "corpus-font" + " .CodeMirror pre {\n  font-family: '" + cfg.getName() + "', monospace;\n  font-size: " + cfg.getSize() + ";\n}\n." + "corpus-font" + " .v-table-table {\n    font-size: " + cfg.getSize() + ";\n}\n#keyboardInputMaster tbody tr td table tbody tr td {\n  font-family: '" + cfg.getName() + "', 'Lucida Console','Arial Unicode MS',monospace; }");
            }
        } else {
            this.injectUniqueCSS("#keyboardInputMaster tbody tr td table tbody tr td {\n  font-family: 'Lucida Console','Arial Unicode MS',monospace;}");
        }
    }

    public void setInstanceConfig(InstanceConfig instanceConfig) {
        this.instanceConfig = instanceConfig;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public ApiClient getClient() {
        Authentication auth;
        ApiClient client = Configuration.getDefaultApiClient();
        client.setBasePath(this.getConfig().getWebserviceUrl());
        Optional user = Helper.getUser((SecurityContext)this.getSecurityContext());
        String bearerToken = null;
        if (user.isPresent()) {
            bearerToken = ((OidcUser)user.get()).getIdToken().getTokenValue();
        }
        if ((auth = client.getAuthentication("bearerAuth")) instanceof HttpBearerAuth) {
            HttpBearerAuth bearerAuth = (HttpBearerAuth)auth;
            bearerAuth.setBearerToken(bearerToken);
        }
        return client;
    }

    public boolean handleCommonError(Throwable ex, String action) {
        if (ex != null) {
            Throwable rootCause = ex;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            if (rootCause instanceof ApiException) {
                ApiException apiEx = (ApiException)rootCause;
                if (apiEx.getCode() == 503) {
                    Notification n = new Notification("Can't execute " + (action == null ? "" : "\"" + action + "\"") + " action because database server is not responding.<br/>There might be too many users using this service right now.", Notification.Type.WARNING_MESSAGE);
                    n.setDescription("<p><strong>Please try again later.</strong> If the error persists inform the administrator of this server.</p><p>Click on this message to close it.</p><p style=\"font-size:9pt;color:gray;\">Pinguin picture by Polar Cruises [CC BY 2.0 (http://creativecommons.org/licenses/by/2.0)], via Wikimedia Commons</p>");
                    n.setIcon(AnnisBaseUI.PINGUIN_IMAGE);
                    n.setHtmlContentAllowed(true);
                    n.setDelayMsec(15000);
                    n.show(this.getPage());
                    return true;
                }
                if (apiEx.getCode() == 401) {
                    this.redirectToLogin();
                    return true;
                }
            }
        }
        return false;
    }

    public abstract ServletContext getServletContext();

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = SecurityContextHolder.getContext();
        }
        return this.securityContext;
    }

    public abstract OAuth2ClientProperties getOauth2ClientProperties();

    public abstract UIConfig getConfig();

    public void redirectToLogin() {
        OAuth2ClientProperties oauth2Clients = this.getOauth2ClientProperties();
        if (this.getOauth2ClientProperties() != null) {
            String oldFragment = Page.getCurrent().getUriFragment();
            VaadinSession.getCurrent().setAttribute("ANNIS_FRAGENT_TO_RESTORE", (Object)oldFragment);
            VaadinRequest currentRequest = VaadinRequest.getCurrent();
            String contextPath = currentRequest == null ? "" : currentRequest.getContextPath();
            Set providers = oauth2Clients.getProvider().keySet();
            if (providers.size() == 1) {
                Page.getCurrent().setLocation(contextPath + "/oauth2/authorization/" + (String)providers.iterator().next());
            } else {
                Page.getCurrent().setLocation(contextPath + "/login");
            }
        }
    }
}

