/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.event.selection.SelectionListener;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnoKey;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.Component;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.CorpusBrowserPanel;
import org.corpus_tools.annis.gui.ExampleTable;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.beans.CorpusBrowserEntry;
import org.corpus_tools.annis.gui.components.ExceptionDialog;

public class CorpusBrowserPanel
extends Panel {
    private static final long serialVersionUID = -1029743017413951838L;
    private String corpus;
    private ExampleTable tblNodeAnno;
    private Label lblNoNodeAnno;
    private ExampleTable tblEdgeTypes;
    private Label lblNoEdgeTypes;
    private ExampleTable tblEdgeAnno;
    private Label lblNoEdgeAnno;
    private ExampleTable tblMetaAnno;
    private Label lblNoMetaAnno;
    private QueryController controller;
    private ProgressBar progress;
    private Accordion accordion;
    private VerticalLayout layout;

    public CorpusBrowserPanel() {
        this(null, null);
    }

    public CorpusBrowserPanel(String corpus, QueryController controller) {
        super("Available annotations");
        this.corpus = corpus;
        this.controller = controller;
        this.setSizeFull();
        this.progress = new ProgressBar();
        this.progress.setIndeterminate(true);
        this.tblNodeAnno = new ExampleTable();
        this.tblEdgeTypes = new ExampleTable();
        this.tblEdgeAnno = new ExampleTable();
        this.tblMetaAnno = new ExampleTable();
        this.tblNodeAnno.addSelectionListener((SelectionListener)new ExampleListener(this, null));
        this.tblEdgeTypes.addSelectionListener((SelectionListener)new ExampleListener(this, null));
        this.tblEdgeAnno.addSelectionListener((SelectionListener)new ExampleListener(this, null));
        this.tblMetaAnno.addSelectionListener((SelectionListener)new ExampleListener(this, null));
        this.tblNodeAnno.sort("name");
        this.tblEdgeTypes.sort("name");
        this.tblEdgeAnno.sort("name");
        this.lblNoNodeAnno = new Label("(No Node Annotations)");
        VerticalLayout tabNodeAnno = new VerticalLayout(new com.vaadin.ui.Component[]{this.tblNodeAnno, this.lblNoNodeAnno});
        tabNodeAnno.setCaption("Node Annotations");
        tabNodeAnno.setMargin(false);
        this.lblNoEdgeAnno = new Label("(No Edge Annotations)");
        VerticalLayout tabEdgeAnno = new VerticalLayout(new com.vaadin.ui.Component[]{this.tblEdgeAnno, this.lblNoEdgeAnno});
        tabEdgeAnno.setCaption("Edge Annotations");
        tabEdgeAnno.setMargin(false);
        this.lblNoEdgeTypes = new Label("(No Edge Types)");
        VerticalLayout tabEdgeTypes = new VerticalLayout(new com.vaadin.ui.Component[]{this.tblEdgeTypes, this.lblNoEdgeTypes});
        tabEdgeTypes.setCaption("Edge Types");
        tabEdgeTypes.setMargin(false);
        this.lblNoMetaAnno = new Label("(No Meta Annotations)");
        VerticalLayout tabMetaAnno = new VerticalLayout(new com.vaadin.ui.Component[]{this.tblMetaAnno, this.lblNoMetaAnno});
        tabMetaAnno.setCaption("Meta Annotations");
        tabMetaAnno.setMargin(false);
        this.accordion = new Accordion(new com.vaadin.ui.Component[]{tabNodeAnno, tabEdgeAnno, tabEdgeTypes, tabMetaAnno});
        this.accordion.setSizeFull();
        this.accordion.setVisible(true);
        this.progress.setVisible(true);
        this.progress.setSizeFull();
        this.layout = new VerticalLayout();
        this.layout.addComponents(new com.vaadin.ui.Component[]{this.progress, this.accordion});
        this.layout.setSizeFull();
        this.layout.setMargin(false);
        this.layout.setComponentAlignment((com.vaadin.ui.Component)this.progress, Alignment.MIDDLE_CENTER);
        this.setContent((com.vaadin.ui.Component)this.layout);
    }

    public void attach() {
        super.attach();
        UI ui = this.getUI();
        Background.run(() -> this.fetchAnnotationsInBackground(ui));
    }

    private boolean canExcludeNamespace(Collection<Annotation> annos) {
        HashSet<String> names = new HashSet<String>();
        for (Annotation a : annos) {
            if (names.add(a.getKey().getName())) continue;
            return false;
        }
        return true;
    }

    private void fetchAnnotationsInBackground(UI ui) {
        CorporaApi api = new CorporaApi(Helper.getClient((UI)ui));
        try {
            List nodeAnnos = api.nodeAnnotations(this.corpus, Boolean.valueOf(true), Boolean.valueOf(true)).stream().filter(a -> !Objects.equals(a.getKey().getNs(), "annis") && !Objects.equals(a.getKey().getName(), "tok")).collect(Collectors.toList());
            LinkedList metaAnnos = new LinkedList(nodeAnnos);
            Set metaAnnoKeys = Helper.getMetaAnnotationNames((String)this.corpus, (UI)ui);
            nodeAnnos.removeIf(anno -> metaAnnoKeys.contains(anno.getKey()));
            metaAnnos.removeIf(anno -> !metaAnnoKeys.contains(anno.getKey()));
            List components = api.components(this.corpus, "Dominance", null);
            LinkedList allEdgeAnnos = new LinkedList();
            LinkedHashMap<Component, List> edgeAnnosByComponent = new LinkedHashMap<Component, List>();
            components.addAll(api.components(this.corpus, "Pointing", null));
            for (Component c : components) {
                try {
                    List annos = api.edgeAnnotations(this.corpus, c.getType().getValue(), c.getLayer(), c.getName(), Boolean.valueOf(true), Boolean.valueOf(true));
                    edgeAnnosByComponent.put(c, annos);
                    allEdgeAnnos.addAll(annos);
                }
                catch (ApiException apiException) {}
            }
            this.getUI().access(() -> {
                CorpusBrowserEntry cbe;
                Object name;
                TreeSet<CorpusBrowserEntry> nodeAnnoItems = new TreeSet<CorpusBrowserEntry>();
                TreeSet<CorpusBrowserEntry> edgeAnnoItems = new TreeSet<CorpusBrowserEntry>();
                TreeSet<Object> edgeTypeItems = new TreeSet<Object>();
                TreeSet<CorpusBrowserEntry> metaAnnoItems = new TreeSet<CorpusBrowserEntry>();
                this.progress.setVisible(false);
                this.accordion.setVisible(true);
                boolean stripNodeAnno = this.canExcludeNamespace((Collection)nodeAnnos);
                boolean stripEdgeName = this.canExcludeNamespace((Collection)allEdgeAnnos);
                boolean stripEdgeAnno = true;
                HashSet<String> nodeAnnoNames = new HashSet<String>();
                HashSet<String> edgeAnnoNames = new HashSet<String>();
                HashSet<String> edgeNames = new HashSet<String>();
                boolean hasDominance = false;
                boolean hasEmptyDominance = false;
                for (Annotation annotation : nodeAnnos) {
                    if (nodeAnnoNames.add(annotation.getKey().getName())) continue;
                    stripNodeAnno = false;
                }
                for (Component component : components) {
                    if (!edgeNames.add(Helper.getQName((Component)component))) {
                        stripEdgeName = false;
                    }
                    if (component.getType() != AnnotationComponentType.DOMINANCE) continue;
                    hasDominance = true;
                    if (component.getName() != null && !component.getName().isEmpty()) continue;
                    hasEmptyDominance = true;
                }
                for (List list : edgeAnnosByComponent.values()) {
                    for (Annotation a : list) {
                        if (edgeAnnoNames.add(a.getKey().getName())) continue;
                        stripEdgeAnno = false;
                    }
                }
                for (Annotation annotation : nodeAnnos) {
                    String name2 = stripNodeAnno ? annotation.getKey().getName() : Helper.getQName((AnnoKey)annotation.getKey());
                    CorpusBrowserEntry cbe2 = new CorpusBrowserEntry();
                    cbe2.setName(name2);
                    cbe2.setExample(name2 + "=\"" + annotation.getVal() + "\"");
                    cbe2.setCorpus(this.corpus);
                    nodeAnnoItems.add(cbe2);
                }
                if (hasDominance && !hasEmptyDominance) {
                    CorpusBrowserEntry cbe3 = new CorpusBrowserEntry();
                    cbe3.setName("(dominance)");
                    cbe3.setCorpus(this.corpus);
                    cbe3.setExample("node & node & #1 > #2");
                    edgeTypeItems.add(cbe3);
                }
                for (Component component : components) {
                    CorpusBrowserEntry cbeEdgeType = new CorpusBrowserEntry();
                    Object object = name = stripEdgeName ? component.getName() : Helper.getQName((Component)component);
                    if ((name == null || ((String)name).isEmpty()) && component.getType() == AnnotationComponentType.DOMINANCE) {
                        cbeEdgeType.setName("(dominance)");
                    } else {
                        cbeEdgeType.setName((String)name);
                    }
                    cbeEdgeType.setCorpus(this.corpus);
                    if (component.getType() == AnnotationComponentType.POINTING) {
                        cbeEdgeType.setExample("node & node & #1 ->" + component.getName() + " #2");
                    } else if (component.getType() == AnnotationComponentType.DOMINANCE) {
                        cbeEdgeType.setExample("node & node & #1 >" + component.getName() + " #2");
                    }
                    edgeTypeItems.add(cbeEdgeType);
                }
                for (Map.Entry entry : edgeAnnosByComponent.entrySet()) {
                    Component c = (Component)entry.getKey();
                    for (Annotation a : (List)entry.getValue()) {
                        CorpusBrowserEntry cbeEdgeAnno = new CorpusBrowserEntry();
                        String edgeAnno = stripEdgeAnno ? a.getKey().getName() : Helper.getQName((AnnoKey)a.getKey());
                        cbeEdgeAnno.setName(edgeAnno);
                        cbeEdgeAnno.setCorpus(this.corpus);
                        if (c.getType() == AnnotationComponentType.POINTING) {
                            cbeEdgeAnno.setExample("node & node & #1 ->" + c.getName() + "[" + a.getKey().getName() + "=\"" + a.getVal() + "\"] #2");
                        } else if (c.getType() == AnnotationComponentType.DOMINANCE) {
                            cbeEdgeAnno.setExample("node & node & #1 >[" + a.getKey().getName() + "=\"" + a.getVal() + "\"] #2");
                        }
                        edgeAnnoItems.add(cbeEdgeAnno);
                    }
                }
                boolean stripMetaName = this.canExcludeNamespace((Collection)metaAnnos);
                for (Annotation a : nodeAnnos) {
                    name = stripMetaName ? a.getKey().getName() : Helper.getQName((AnnoKey)a.getKey());
                    cbe = new CorpusBrowserEntry();
                    cbe.setName((String)name);
                    cbe.setExample((String)name + "=\"" + a.getVal() + "\"");
                    cbe.setCorpus(this.corpus);
                    nodeAnnoItems.add(cbe);
                }
                for (Annotation a : metaAnnos) {
                    name = stripNodeAnno ? a.getKey().getName() : Helper.getQName((AnnoKey)a.getKey());
                    cbe = new CorpusBrowserEntry();
                    cbe.setName((String)name);
                    cbe.setExample((String)name + "=\"" + a.getVal() + "\"");
                    cbe.setCorpus(this.corpus);
                    metaAnnoItems.add(cbe);
                }
                this.lblNoNodeAnno.setVisible(nodeAnnoItems.isEmpty());
                this.tblNodeAnno.setVisible(!nodeAnnoItems.isEmpty());
                this.tblNodeAnno.setItems(new ArrayList(nodeAnnoItems));
                this.lblNoEdgeAnno.setVisible(edgeAnnoItems.isEmpty());
                this.tblEdgeAnno.setVisible(!edgeAnnoItems.isEmpty());
                this.tblEdgeAnno.setItems(edgeAnnoItems);
                this.lblNoEdgeTypes.setVisible(edgeTypeItems.isEmpty());
                this.tblEdgeTypes.setVisible(!edgeTypeItems.isEmpty());
                this.tblEdgeTypes.setItems(edgeTypeItems);
                this.lblNoMetaAnno.setVisible(metaAnnoItems.isEmpty());
                this.tblMetaAnno.setVisible(!metaAnnoItems.isEmpty());
                this.tblMetaAnno.setItems(metaAnnoItems);
            });
        }
        catch (ApiException e) {
            this.getUI().access(() -> ExceptionDialog.show((Throwable)e, (String)"Error fetching corpus annotations", (UI)this.getUI()));
        }
    }

    static /* synthetic */ String access$000(CorpusBrowserPanel x0) {
        return x0.corpus;
    }

    static /* synthetic */ QueryController access$100(CorpusBrowserPanel x0) {
        return x0.controller;
    }
}

