/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.FutureCallback;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.ui.Transport;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletContext;
import okhttp3.Request;
import org.corpus_tools.annis.ApiClient;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.SubgraphWithContext;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.EmbeddedVisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.corpus_tools.annis.gui.ServiceStarter;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserController;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.RawTextWrapper;
import org.corpus_tools.annis.gui.util.ANNISFontIcon;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.annis.gui.visualizers.VisualizerPlugin;
import org.corpus_tools.annis.gui.visualizers.htmlvis.HTMLVis;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Theme(value="annis_embeddedvis")
@Push(value=PushMode.AUTOMATIC, transport=Transport.LONG_POLLING)
@SpringUI(path="/embeddedvis/*")
@Widgetset(value="org.corpus_tools.annis.gui.widgets.gwt.AnnisWidgetSet")
public class EmbeddedVisUI
extends CommonUI {
    private static final long serialVersionUID = 3171707930515328817L;
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVisUI.class);
    public static final String URL_PREFIX = "/embeddedvis";
    public static final String KEY_PREFIX = "embedded_";
    private static final String KEY_SALT = "embedded_salt";
    public static final String KEY_NAMESPACE = "embedded_ns";
    public static final String KEY_SEARCH_INTERFACE = "embedded_interface";
    public static final String KEY_BASE_TEXT = "embedded_base";
    public static final String KEY_SEGMENTATION = "embedded_segmentation";
    public static final String KEY_MATCH = "embedded_match";
    public static final String KEY_FULLTEXT = "embedded_fulltext";
    public static final String KEY_LEFT = "embedded_left";
    public static final String KEY_RIGHT = "embedded_right";
    public static final String KEY_INSTANCE = "embedded_instance";
    @Autowired
    private List<VisualizerPlugin> visualizers;
    @Autowired
    private ServiceStarter serviceStarter;
    @Autowired
    private transient ServletContext servletContext;
    @Autowired(required=false)
    private transient OAuth2ClientProperties oauth2Clients;
    @Autowired
    private UIConfig config;

    public EmbeddedVisUI() {
        super(URL_PREFIX);
    }

    private void displayGeneralHelp() {
        this.displayMessage("Path not complete", "You have to specify what visualizer to use and which document of which corpus you want to visualizer by giving the correct path:<br /><code>http://example.com/annis/embeddedvis/&lt;vis&gt;/&lt;corpus&gt;/&lt;doc&gt;</code><ul><li><code>vis</code>: visualizer name (currently only \"htmldoc\" is supported)</li><li><code>corpus</code>: corpus name</li><li><code>doc</code>: name of the document to visualize</li></ul>");
    }

    private void displayLoadingIndicator() {
        VerticalLayout layout = new VerticalLayout();
        layout.addStyleName("v-app-loading");
        layout.setSizeFull();
        this.setContent((Component)layout);
    }

    private void displayMessage(String header, String content) {
        Label label = new Label("<h1>" + header + "</h1><div>" + content + "</div>", ContentMode.HTML);
        label.setSizeFull();
        this.setContent((Component)label);
    }

    private void generateVisFromParameters(String visName, Map<String, String[]> args) {
        Optional<VisualizerPlugin> visPlugin = this.visualizers.stream().filter(vis -> Objects.equal((Object)vis.getShortName(), (Object)visName)).findAny();
        if (!visPlugin.isPresent()) {
            this.displayMessage("Unknown visualizer \"" + visName + "\"", "This ANNIS instance does not know the given visualizer.");
            return;
        }
        ApiClient client = this.getClient();
        this.displayLoadingIndicator();
        CorporaApi api = new CorporaApi(client);
        Match match = Match.parseFromString((String)args.get(KEY_MATCH)[0]);
        List corpusPath = Helper.getCorpusPath((String)((String)match.getSaltIDs().get(0)));
        if (args.containsKey(KEY_FULLTEXT)) {
            boolean isUsingRawText = visPlugin.get().isUsingRawText();
            String aql = Helper.buildDocumentQuery((List)corpusPath, null, (boolean)isUsingRawText);
            Background.runWithCallback(() -> api.subgraphForQuery((String)corpusPath.get(0), aql, QueryLanguage.AQL, (AnnotationComponentType)(isUsingRawText ? AnnotationComponentType.ORDERING : null)), (FutureCallback)new GraphMLLoaderCallback(this, corpusPath, visPlugin.get(), args));
        } else {
            SubgraphWithContext subgraphQuery = new SubgraphWithContext();
            subgraphQuery.setLeft(Integer.valueOf(Integer.parseInt(args.get(KEY_LEFT)[0])));
            subgraphQuery.setRight(Integer.valueOf(Integer.parseInt(args.get(KEY_RIGHT)[0])));
            subgraphQuery.setNodeIds(match.getSaltIDs());
            if (args.containsKey(KEY_SEGMENTATION)) {
                subgraphQuery.setSegmentation(args.get(KEY_SEGMENTATION)[0]);
            } else {
                subgraphQuery.setSegmentation(null);
            }
            Background.runWithCallback(() -> api.subgraphForNodes((String)corpusPath.get(0), subgraphQuery), (FutureCallback)new GraphMLLoaderCallback(this, corpusPath, visPlugin.get(), args));
        }
    }

    private void generateVisualizerFromDocument(SDocument doc, Map<String, String[]> args, VisualizerPlugin visPlugin) {
        String[] interfaceLink;
        String[] rawMatch;
        String[] value;
        Map allConfigs;
        InstanceConfig newConfig;
        if (args.containsKey(KEY_INSTANCE) && (newConfig = (InstanceConfig)(allConfigs = this.loadInstanceConfig()).get(args.get(KEY_INSTANCE)[0])) != null) {
            this.setInstanceConfig(newConfig);
        }
        this.loadInstanceFonts();
        VisualizerInput visInput = new VisualizerInput();
        visInput.setDocument(doc);
        if (visPlugin.isUsingRawText()) {
            visInput.setRawText(new RawTextWrapper(doc.getDocumentGraph()));
        }
        if (this.getInstanceConfig() != null && this.getInstanceConfig().getFont() != null) {
            visInput.setFont(this.getInstanceFont());
        }
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String[]> e : args.entrySet()) {
            if (KEY_SALT.equals(e.getKey()) || e.getValue().length <= 0) continue;
            mappings.put(e.getKey(), e.getValue()[0]);
        }
        visInput.setMappings(mappings);
        String[] namespace = args.get(KEY_NAMESPACE);
        if (namespace != null && namespace.length > 0) {
            visInput.setNamespace(namespace[0]);
        } else {
            visInput.setNamespace(null);
        }
        String baseText = null;
        if (args.containsKey(KEY_BASE_TEXT) && (value = args.get(KEY_BASE_TEXT)).length > 0) {
            baseText = value[0];
        }
        if (args.containsKey(KEY_MATCH) && (rawMatch = args.get(KEY_MATCH)).length > 0) {
            Match match = Match.parseFromString((String)rawMatch[0]);
            Helper.addMatchToDocumentGraph((Match)match, (SDocumentGraph)doc.getDocumentGraph());
        }
        List segNodes = Helper.getSortedSegmentationNodes(baseText, (SDocumentGraph)doc.getDocumentGraph());
        Map markedAndCovered = Helper.calculateMarkedAndCovered((SDocument)doc, (List)segNodes, (String)baseText);
        visInput.setMarkedAndCovered(markedAndCovered);
        visInput.setContextPath(this.servletContext.getContextPath());
        String template = this.servletContext.getContextPath() + "/Resource/" + visPlugin.getShortName() + "/%s";
        visInput.setResourcePathTemplate(template);
        visInput.setSegmentationName(baseText);
        visInput.setUI((CommonUI)this);
        Component c = visPlugin.createComponent(visInput, null);
        c.addStyleName("corpus-font");
        c.addStyleName("vis-content");
        Link link = new Link();
        link.setCaption("Show in ANNIS search interface");
        link.setIcon((Resource)ANNISFontIcon.LOGO);
        link.setVisible(false);
        link.addStyleName("dontprint");
        link.setTargetName("_blank");
        if (args.containsKey(KEY_SEARCH_INTERFACE) && (interfaceLink = args.get(KEY_SEARCH_INTERFACE)).length > 0) {
            link.setResource((Resource)new ExternalResource(interfaceLink[0]));
            link.setVisible(true);
        }
        VerticalLayout layout = new VerticalLayout(new Component[]{link, c});
        layout.setComponentAlignment((Component)link, Alignment.TOP_LEFT);
        layout.setSpacing(true);
        layout.setMargin(true);
        this.setContent((Component)layout);
        IDGenerator.assignID((Component)link);
    }

    @Deprecated
    private void generateVisFromRemoteSaltURL(String visName, String rawUri, Map<String, String[]> args) {
        try {
            Optional<VisualizerPlugin> visPluginOpt = this.visualizers.stream().filter(vis -> Objects.equal((Object)vis.getShortName(), (Object)visName)).findAny();
            if (visPluginOpt.isPresent()) {
                VisualizerPlugin visPlugin = visPluginOpt.get();
                URI uri = new URI(rawUri);
                ApiClient client = Helper.getClient((UI)this);
                this.displayLoadingIndicator();
                LinkedHashMap<String, String[]> argsCopy = new LinkedHashMap<String, String[]>(args);
                Request request = new Request.Builder().url(uri.toASCIIString()).build();
                Background.runWithCallback(() -> client.getHttpClient().newCall(request).execute(), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.displayMessage("Unknown visualizer \"" + visName + "\"", "This ANNIS instance does not know the given visualizer.");
            }
        }
        catch (URISyntaxException ex) {
            this.displayMessage("Invalid URL", "The provided URL is malformed:<br />" + ex.getMessage());
        }
        catch (Throwable ex) {
            this.displayMessage("Could not generate the visualization.", ex.getMessage() == null ? "An unknown error of type " + ex.getClass().getSimpleName() + " occurred." : ex.getMessage());
        }
    }

    protected void init(VaadinRequest request) {
        super.init(request);
        Optional desktopUser = this.serviceStarter.getDesktopUserToken();
        if (desktopUser.isPresent()) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)desktopUser.get();
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        }
        String rawPath = request.getPathInfo();
        this.attachToPath(rawPath, request);
    }

    protected void attachToPath(String rawPath, VaadinRequest request) {
        List splittedPath = new LinkedList();
        if (rawPath != null) {
            rawPath = rawPath.substring(URL_PREFIX.length());
            splittedPath = Splitter.on((String)"/").omitEmptyStrings().trimResults().limit(3).splitToList((CharSequence)rawPath);
        }
        if (splittedPath.size() == 1) {
            String saltUrl = request.getParameter(KEY_SALT);
            if (saltUrl == null) {
                if (request.getParameter(KEY_MATCH) == null) {
                    this.displayGeneralHelp();
                } else {
                    this.generateVisFromParameters((String)splittedPath.get(0), request.getParameterMap());
                }
            } else {
                this.generateVisFromRemoteSaltURL((String)splittedPath.get(0), saltUrl, request.getParameterMap());
            }
        } else if (splittedPath.size() >= 3) {
            if ("htmldoc".equals(splittedPath.get(0))) {
                this.showHtmlDoc((String)splittedPath.get(1), splittedPath.subList(1, splittedPath.size()), request.getParameterMap());
            } else {
                this.displayMessage("Unknown visualizer \"" + (String)splittedPath.get(0) + "\"", "Only \"htmldoc\" is supported yet.");
            }
        } else {
            this.displayGeneralHelp();
        }
        this.addStyleName("loaded-embedded-vis");
    }

    private void showHtmlDoc(String corpus, List<String> docPath, Map<String, String[]> args) {
        if (args == null || args.isEmpty()) {
            return;
        }
        if (args.get("config") != null && args.get("config").length > 0) {
            String configArg = args.get("config")[0];
            HTMLVis visualizer = new HTMLVis();
            VisualizerRule visConfig = new VisualizerRule();
            visConfig.setDisplayName(" ");
            HashMap<String, String> mappings = new HashMap<String, String>();
            mappings.put("config", configArg);
            visConfig.setMappings(mappings);
            visConfig.setLayer(null);
            visConfig.setVisType("htmldoc");
            VisualizerInput input = DocBrowserController.createInput((String)corpus, docPath, (VisualizerRule)visConfig, null, (boolean)visualizer.isUsingRawText(), (CommonUI)this);
            Panel viszr = visualizer.createComponent(input, null);
            this.setContent((Component)viszr);
        } else {
            this.displayMessage("Missing required argument for visualizer \"htmldoc\"", "The following arguments are required:<ul><li><code>config</code>: the internal config file to use (same as <a href=\"http://korpling.github.io/ANNIS/doc/classannis_1_1visualizers_1_1htmlvis_1_1HTMLVis.html\">\"config\" mapping parameter)</a></li></ul>");
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public OAuth2ClientProperties getOauth2ClientProperties() {
        return this.oauth2Clients;
    }

    public UIConfig getConfig() {
        return this.config;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(EmbeddedVisUI x0, String x1, String x2) {
        x0.displayMessage(x1, x2);
    }

    static /* synthetic */ void access$200(EmbeddedVisUI x0, SDocument x1, Map x2, VisualizerPlugin x3) {
        x0.generateVisualizerFromDocument(x1, x2, x3);
    }
}

