/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.base.Stopwatch;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.server.Extension;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.FileResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.ExportPanel;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.components.HelpButton;
import org.corpus_tools.annis.gui.controlpanel.SearchOptionsPanel;
import org.corpus_tools.annis.gui.converter.CommaSeperatedStringConverterList;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPanel
extends GridLayout {
    private static final long serialVersionUID = -4669376862731675681L;
    private static final Logger log = LoggerFactory.getLogger(ExportPanel.class);
    private final com.vaadin.ui.ComboBox<Integer> cbLeftContext;
    private final com.vaadin.ui.ComboBox<Integer> cbRightContext;
    private final TextField txtAnnotationKeys;
    private final TextField txtParameters;
    private final BeanItemContainer<Class> exporterClassContainer = new BeanItemContainer(Class.class);
    private final ComboBox cbExporter;
    private final Button btDownload;
    private final Button btExport;
    private final Button btCancel;
    private final AnnisUI ui;
    private File tmpOutputFile;
    private final ProgressBar progressBar;
    private final Label progressLabel;
    private FileDownloader downloader;
    private final transient EventBus eventBus;
    private transient Stopwatch exportTime = Stopwatch.createUnstarted();
    private final QueryUIState state;
    private final FormLayout formLayout;
    private final Label lblHelp;
    private final CheckBox cbAlignmc;

    public ExportPanel(AnnisUI ui) {
        super(2, 3);
        this.ui = ui;
        this.state = ui.getQueryState();
        this.eventBus = new EventBus();
        this.eventBus.register((Object)this);
        this.formLayout = new FormLayout();
        this.formLayout.setWidth("-1px");
        this.setWidth("99%");
        this.setHeight("-1px");
        this.setColumnExpandRatio(0, 0.0f);
        this.setColumnExpandRatio(1, 1.0f);
        this.cbExporter = new ComboBox("Exporter");
        this.cbExporter.setNewItemsAllowed(false);
        this.cbExporter.setNullSelectionAllowed(false);
        this.cbExporter.setImmediate(true);
        this.cbExporter.addValueChangeListener((Property.ValueChangeListener)new ExporterSelectionHelpListener(this));
        this.formLayout.addComponent((Component)this.cbExporter);
        this.addComponent((Component)this.formLayout, 0, 0);
        this.lblHelp = new Label();
        this.lblHelp.setContentMode(ContentMode.HTML);
        this.addComponent((Component)this.lblHelp, 1, 0);
        this.cbLeftContext = new com.vaadin.ui.ComboBox("Left Context");
        this.cbRightContext = new com.vaadin.ui.ComboBox("Right Context");
        this.cbLeftContext.setEmptySelectionAllowed(false);
        this.cbRightContext.setEmptySelectionAllowed(false);
        ComboBox.NewItemProvider & Serializable contextNewItemProvider = (ComboBox.NewItemProvider & Serializable)v -> {
            try {
                int numericValue = Integer.parseInt(v);
                if (numericValue >= 0) {
                    return Optional.of(numericValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Optional.empty();
        };
        this.cbLeftContext.setNewItemProvider((ComboBox.NewItemProvider)contextNewItemProvider);
        this.cbRightContext.setNewItemProvider((ComboBox.NewItemProvider)contextNewItemProvider);
        this.cbLeftContext.setItems((Collection)SearchOptionsPanel.PREDEFINED_CONTEXTS);
        this.cbRightContext.setItems((Collection)SearchOptionsPanel.PREDEFINED_CONTEXTS);
        this.cbLeftContext.setValue((Object)5);
        this.cbRightContext.setValue((Object)5);
        this.formLayout.addComponent((Component)this.cbLeftContext);
        this.formLayout.addComponent((Component)this.cbRightContext);
        this.txtAnnotationKeys = new TextField("Annotation Keys");
        this.txtAnnotationKeys.setDescription("Some exporters will use this comma seperated list of annotation keys to limit the exported data to these annotations.");
        this.formLayout.addComponent((Component)new HelpButton((Field)this.txtAnnotationKeys));
        this.txtParameters = new TextField("Parameters");
        this.txtParameters.setDescription("You can input special parameters for certain exporters. See the description of each exporter (\u2018?\u2019 button above) for specific parameter settings.");
        this.formLayout.addComponent((Component)new HelpButton((Field)this.txtParameters));
        this.cbAlignmc = new CheckBox("align matches<br/>by node number");
        this.cbAlignmc.setCaptionAsHtml(true);
        this.cbAlignmc.setDescription("Click here to align export result by node number.");
        this.cbAlignmc.setEnabled(true);
        this.formLayout.addComponent((Component)this.cbAlignmc);
        this.btExport = new Button("Perform Export");
        this.btExport.setIcon((Resource)FontAwesome.PLAY);
        this.btExport.setDisableOnClick(true);
        this.btExport.addClickListener((Button.ClickListener)new ExportButtonListener(this, null));
        this.btCancel = new Button("Cancel Export");
        this.btCancel.setIcon((Resource)FontAwesome.TIMES_CIRCLE);
        this.btCancel.setEnabled(false);
        this.btCancel.addClickListener((Button.ClickListener)new CancelButtonListener(this, null));
        this.btDownload = new Button("Download");
        this.btDownload.setDescription("Click here to start the actual download.");
        this.btDownload.setIcon((Resource)FontAwesome.DOWNLOAD);
        this.btDownload.setDisableOnClick(true);
        this.btDownload.setEnabled(false);
        HorizontalLayout layoutExportButtons = new HorizontalLayout(new Component[]{this.btExport, this.btCancel, this.btDownload});
        this.addComponent((Component)layoutExportButtons, 0, 1, 1, 1);
        VerticalLayout vLayout = new VerticalLayout();
        this.addComponent((Component)vLayout, 0, 2, 1, 2);
        this.progressBar = new ProgressBar();
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(true);
        vLayout.addComponent((Component)this.progressBar);
        this.progressLabel = new Label();
        vLayout.addComponent((Component)this.progressLabel);
        if (this.state != null) {
            Binder binder = new Binder(QueryUIState.class);
            binder.forField((HasValue)this.cbLeftContext).bind("leftContext");
            binder.forField((HasValue)this.cbRightContext).bind("rightContext");
            this.cbExporter.setPropertyDataSource((Property)this.state.getExporter());
            this.txtAnnotationKeys.setConverter((Converter)new CommaSeperatedStringConverterList());
            this.txtAnnotationKeys.setPropertyDataSource((Property)this.state.getExportAnnotationKeys());
            this.txtParameters.setPropertyDataSource((Property)this.state.getExportParameters());
            this.cbAlignmc.setPropertyDataSource((Property)this.state.getAlignmc());
        }
    }

    public void attach() {
        super.attach();
        this.cbExporter.setPropertyDataSource((Property)this.state.getExporter());
        this.cbExporter.setContainerDataSource((Container)this.exporterClassContainer);
        for (ExporterPlugin e : this.ui.getExporterPlugins()) {
            this.exporterClassContainer.addItem(e.getClass());
        }
        this.exporterClassContainer.sort(new Object[]{"simpleName"}, new boolean[]{true});
        this.cbExporter.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.cbExporter.setItemCaptionPropertyId((Object)"simpleName");
        if (this.exporterClassContainer.size() > 0) {
            this.cbExporter.setValue(this.exporterClassContainer.getIdByIndex(0));
        }
        IDGenerator.assignIDForFields((HasComponents)this, (Component[])new Component[]{this.cbExporter, this.btDownload, this.btExport, this.txtAnnotationKeys, this.txtParameters});
    }

    public void detach() {
        super.detach();
        if (this.tmpOutputFile != null && this.tmpOutputFile.exists() && !this.tmpOutputFile.delete()) {
            log.warn("Could not delete {}", (Object)this.tmpOutputFile.getAbsolutePath());
        }
    }

    @Subscribe
    public void handleExportProgress(Integer exports) {
        UI ui = this.getUI();
        if (ui != null) {
            ui.accessSynchronously(() -> {
                if (this.exportTime != null && this.exportTime.isRunning()) {
                    this.progressLabel.setValue("exported " + exports + " items in " + this.exportTime.toString());
                } else {
                    this.progressLabel.setValue("exported " + exports + " items");
                }
            });
        }
    }

    public void showResult(File currentTmpFile, Exception exportError) {
        this.btExport.setEnabled(true);
        this.btCancel.setEnabled(false);
        this.progressBar.setVisible(false);
        this.progressLabel.setValue("");
        this.tmpOutputFile = currentTmpFile;
        if (exportError instanceof IllegalStateException || exportError instanceof ClassCastException) {
            Notification.show((String)exportError.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        } else if (this.tmpOutputFile == null) {
            Notification.show((String)"Could not create the Exporter", (String)"The server logs might contain more information about this so you should contact the provider of this ANNIS installation for help.", (Notification.Type)Notification.Type.ERROR_MESSAGE);
        } else if (exportError instanceof InterruptedException) {
            Notification.show((String)"Export cancelled", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        } else {
            if (this.downloader != null && this.btDownload.getExtensions().contains(this.downloader)) {
                this.btDownload.removeExtension((Extension)this.downloader);
            }
            this.downloader = new FileDownloader((Resource)new FileResource(this.tmpOutputFile));
            this.downloader.extend((AbstractComponent)this.btDownload);
            this.btDownload.setEnabled(true);
            Notification.show((String)"Export finished", (String)"Click on the button right to the export button to actually download the file.", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        }
    }

    static /* synthetic */ AnnisUI access$000(ExportPanel x0) {
        return x0.ui;
    }

    static /* synthetic */ File access$100(ExportPanel x0) {
        return x0.tmpOutputFile;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    static /* synthetic */ File access$102(ExportPanel x0, File x1) {
        x0.tmpOutputFile = x1;
        return x0.tmpOutputFile;
    }

    static /* synthetic */ Button access$300(ExportPanel x0) {
        return x0.btExport;
    }

    static /* synthetic */ QueryUIState access$400(ExportPanel x0) {
        return x0.state;
    }

    static /* synthetic */ Button access$500(ExportPanel x0) {
        return x0.btDownload;
    }

    static /* synthetic */ ProgressBar access$600(ExportPanel x0) {
        return x0.progressBar;
    }

    static /* synthetic */ Label access$700(ExportPanel x0) {
        return x0.progressLabel;
    }

    static /* synthetic */ Button access$800(ExportPanel x0) {
        return x0.btCancel;
    }

    static /* synthetic */ EventBus access$900(ExportPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ Stopwatch access$1000(ExportPanel x0) {
        return x0.exportTime;
    }

    static /* synthetic */ Stopwatch access$1002(ExportPanel x0, Stopwatch x1) {
        x0.exportTime = x1;
        return x0.exportTime;
    }

    static /* synthetic */ ComboBox access$1100(ExportPanel x0) {
        return x0.cbExporter;
    }

    static /* synthetic */ CheckBox access$1200(ExportPanel x0) {
        return x0.cbAlignmc;
    }

    static /* synthetic */ Label access$1300(ExportPanel x0) {
        return x0.lblHelp;
    }

    static /* synthetic */ com.vaadin.ui.ComboBox access$1400(ExportPanel x0) {
        return x0.cbLeftContext;
    }

    static /* synthetic */ com.vaadin.ui.ComboBox access$1500(ExportPanel x0) {
        return x0.cbRightContext;
    }
}

