/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinService;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.net.URI;
import java.net.URISyntaxException;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.ExampleQueriesPanel;
import org.corpus_tools.annis.gui.InstanceConfig;
import org.corpus_tools.annis.gui.components.StatefulBrowserComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPanel
extends Accordion {
    private static final long serialVersionUID = 3388826883552338877L;
    private static final Logger log = LoggerFactory.getLogger(HelpPanel.class);
    private StatefulBrowserComponent help;
    private final ExampleQueriesPanel examples;

    public HelpPanel(AnnisUI ui) {
        this.setSizeFull();
        if (ui != null) {
            InstanceConfig cfg = ui.getInstanceConfig();
            URI url = null;
            if (cfg.getHelpUrl() != null && !cfg.getHelpUrl().isEmpty()) {
                try {
                    url = new URI(cfg.getHelpUrl());
                }
                catch (URISyntaxException ex) {
                    log.error("Invalid help URL {} provided in instance configuration", (Object)cfg.getHelpUrl(), (Object)ex);
                }
            } else {
                URI appURI = UI.getCurrent().getPage().getLocation();
                String relativeFile = "/VAADIN/help/index.html";
                try {
                    String oldPath = VaadinService.getCurrentRequest().getContextPath();
                    if (oldPath == null) {
                        oldPath = "";
                    }
                    if (oldPath.endsWith("/")) {
                        oldPath = oldPath.substring(0, oldPath.length() - 1);
                    }
                    url = new URI(appURI.getScheme(), appURI.getUserInfo(), appURI.getHost(), appURI.getPort(), oldPath + relativeFile, null, null);
                }
                catch (URISyntaxException ex) {
                    log.error("Invalid help URI", (Throwable)ex);
                }
            }
            if (url != null) {
                this.help = new StatefulBrowserComponent(url);
                this.help.setSizeFull();
                this.addComponent((Component)this.help);
                this.help.setHeight("99%");
                this.addTab((Component)this.help, "Help", (Resource)FontAwesome.BOOK);
                this.setSelectedTab((Component)this.help);
            }
        }
        this.examples = new ExampleQueriesPanel(ui, this);
        this.examples.setHeight("99%");
        this.addTab((Component)this.examples, "Example Queries", (Resource)FontAwesome.LIST_ALT);
        this.addStyleName("help-tab");
    }

    public ExampleQueriesPanel getExamples() {
        return this.examples;
    }
}

