/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.util.concurrent.FutureCallback;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.AnnoKey;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.salt.core.SMetaAnnotation;

public class MetaDataPanel
extends Panel {
    private static final long serialVersionUID = -3607697674053863447L;
    private VerticalLayout layout;
    private String toplevelCorpusName;
    private Optional<String> documentName;
    private Grid<Annotation> corpusAnnotationTable = null;
    private final ProgressBar progress = new ProgressBar();
    private Label emptyLabel = new Label("(no metadata)");

    public MetaDataPanel(String toplevelCorpusName) {
        this(toplevelCorpusName, Optional.empty());
    }

    public MetaDataPanel(String toplevelCorpusName, Optional<String> documentName) {
        super("Metadata");
        this.toplevelCorpusName = toplevelCorpusName;
        this.documentName = documentName;
        this.setSizeFull();
        this.layout = new VerticalLayout();
        this.layout.setSizeFull();
        this.setContent((Component)this.layout);
        this.progress.setIndeterminate(true);
        this.progress.setSizeFull();
        this.layout.addComponent((Component)this.progress);
        this.layout.setComponentAlignment((Component)this.progress, Alignment.MIDDLE_CENTER);
    }

    private void addEmptyLabel() {
        if (this.emptyLabel == null) {
            this.emptyLabel = new Label("none");
        }
        if (this.corpusAnnotationTable != null) {
            this.layout.removeComponent((Component)this.corpusAnnotationTable);
        }
        this.layout.addComponent((Component)this.emptyLabel);
        this.emptyLabel.setSizeUndefined();
        this.layout.setComponentAlignment((Component)this.emptyLabel, Alignment.MIDDLE_CENTER);
        this.layout.setExpandRatio((Component)this.emptyLabel, 1.0f);
    }

    public void attach() {
        super.attach();
        UI ui = this.getUI();
        Background.runWithCallback(() -> {
            LinkedList<Annotation> result = new LinkedList<Annotation>();
            SearchApi api = new SearchApi(Helper.getClient((UI)ui));
            List annos = this.documentName.isPresent() ? Helper.getMetaDataDoc((String)this.toplevelCorpusName, (String)((String)this.documentName.get()), (UI)ui) : Helper.getMetaData((String)this.toplevelCorpusName, Optional.empty(), (UI)ui);
            for (SMetaAnnotation metaAnno : annos) {
                Annotation anno = new Annotation();
                AnnoKey key = new AnnoKey();
                key.setNs(metaAnno.getNamespace());
                key.setName(metaAnno.getName());
                anno.setKey(key);
                anno.setVal(metaAnno.getValue_STEXT());
                result.add(anno);
            }
            return result;
        }, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Grid<Annotation> setupTable(ListDataProvider<Annotation> metaData) {
        ValueProvider & Serializable nameProvider = (ValueProvider & Serializable)anno -> Helper.getQName((AnnoKey)anno.getKey());
        metaData.setSortOrder((ValueProvider)nameProvider, SortDirection.ASCENDING);
        Grid tblMeta = new Grid(Annotation.class);
        tblMeta.setDataProvider(metaData);
        Grid.Column nameColumn = tblMeta.addColumn((ValueProvider)nameProvider);
        nameColumn.setWidthUndefined();
        nameColumn.setCaption("Name");
        nameColumn.setId("genname");
        Grid.Column valueColumn = tblMeta.addComponentColumn((ValueProvider & Serializable)anno -> new Label(anno.getVal(), ContentMode.HTML));
        valueColumn.setId("genval");
        valueColumn.setCaption("Value");
        tblMeta.setColumns(new String[]{nameColumn.getId(), valueColumn.getId()});
        tblMeta.setSizeFull();
        valueColumn.setExpandRatio(1);
        return tblMeta;
    }

    static /* synthetic */ ProgressBar access$000(MetaDataPanel x0) {
        return x0.progress;
    }

    static /* synthetic */ VerticalLayout access$100(MetaDataPanel x0) {
        return x0.layout;
    }

    static /* synthetic */ void access$200(MetaDataPanel x0) {
        x0.addEmptyLabel();
    }

    static /* synthetic */ Optional access$300(MetaDataPanel x0) {
        return x0.documentName;
    }

    static /* synthetic */ String access$400(MetaDataPanel x0) {
        return x0.toplevelCorpusName;
    }

    static /* synthetic */ Grid access$500(MetaDataPanel x0, ListDataProvider x1) {
        return x0.setupTable(x1);
    }
}

