/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNamedElement;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.util.DataSourceSequence;

/*
 * Exception performing whole class analysis ignored.
 */
public class PDFPageHelper {
    public static final String MAPPING_PAGE_KEY = "pdf_page_key";
    public static final String DEFAULT_PAGE_NUMBER_ANNOTATION_NAME = "page";
    public static final String PAGE_NUMBER_SEPERATOR = "-";
    public static final String PAGE_NO_VALID_NUMBER = "-1";
    private VisualizerInput input;

    private static Number getCharacterIndex(SSpan span) {
        List allDS;
        if (span != null && span.getGraph() != null && (allDS = span.getGraph().getOverlappedDataSourceSequence((SNode)span, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION})) != null) {
            for (DataSourceSequence seq : allDS) {
                if (!(seq.getDataSource() instanceof STextualDS)) continue;
                return seq.getStart();
            }
        }
        return null;
    }

    public PDFPageHelper(VisualizerInput visInput) {
        this.input = visInput;
    }

    public String getMostLeftAndMostRightPageAnno() {
        if (this.input == null || this.input.getDocument() == null || this.input.getDocument().getDocumentGraph() == null) {
            return null;
        }
        List sspans = this.input.getDocument().getDocumentGraph().getSpans();
        if (sspans == null || sspans.isEmpty()) {
            return null;
        }
        TreeMap<Integer, String> pageNumbers = new TreeMap<Integer, String>();
        for (SSpan span : sspans) {
            Number charIdx;
            String page = this.getPageFromAnnotation((SNode)span);
            if (page == null || (charIdx = PDFPageHelper.getCharacterIndex((SSpan)span)) == null) continue;
            pageNumbers.put(charIdx.intValue(), page);
        }
        if (pageNumbers.size() == 1) {
            return (String)pageNumbers.firstEntry().getValue();
        }
        if (pageNumbers.size() > 1) {
            return (String)pageNumbers.firstEntry().getValue() + "-" + (String)pageNumbers.lastEntry().getValue();
        }
        return null;
    }

    public String getPageFromAnnotation(SNode node) {
        if (node != null) {
            String nodeNamespace = node.getLayers().stream().findFirst().map(SNamedElement::getName).orElse(null);
            for (SLayer l : node.getLayers()) {
                nodeNamespace = l.getName();
            }
            for (SAnnotation anno : node.getAnnotations()) {
                if ((nodeNamespace == null || this.input.getNamespace() == null) && this.getPDFPageAnnotationName().equals(anno.getName())) {
                    return anno.getValue_STEXT();
                }
                if (nodeNamespace == null || !nodeNamespace.equals(this.input.getNamespace()) || !this.getPDFPageAnnotationName().equals(anno.getName())) continue;
                return anno.getValue_STEXT();
            }
        }
        return null;
    }

    public String getPDFPageAnnotationName() {
        Map mappings = this.input.getMappings();
        if (mappings != null) {
            return mappings.getOrDefault("pdf_page_key", "page");
        }
        return "page";
    }
}

