/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.FutureCallback;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import okhttp3.Call;
import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.JSON;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.BadRequestError;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.CountQuery;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.ExportPanel;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.QueryGenerator;
import org.corpus_tools.annis.gui.SearchView;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.controller.CountCallback;
import org.corpus_tools.annis.gui.controller.ExportBackgroundJob;
import org.corpus_tools.annis.gui.controller.FrequencyBackgroundJob;
import org.corpus_tools.annis.gui.controller.SpecificPagingCallback;
import org.corpus_tools.annis.gui.controlpanel.QueryPanel;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.frequency.UserGeneratedFrequencyEntry;
import org.corpus_tools.annis.gui.media.MediaController;
import org.corpus_tools.annis.gui.objects.ContextualizedQuery;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.ExportQuery;
import org.corpus_tools.annis.gui.objects.ExportQueryGenerator;
import org.corpus_tools.annis.gui.objects.FrequencyQuery;
import org.corpus_tools.annis.gui.objects.FrequencyTableQuery;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.corpus_tools.annis.gui.paging.PagingCallback;
import org.corpus_tools.annis.gui.resultfetch.ResultFetchJob;
import org.corpus_tools.annis.gui.resultfetch.SingleResultFetchJob;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;
import org.corpus_tools.annis.gui.resultview.VisualizerContextChanger;
import org.corpus_tools.annis.gui.visualizers.IFrameResourceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryController
implements Serializable {
    private static final long serialVersionUID = -5746215715915616348L;
    private static final Logger log = LoggerFactory.getLogger(QueryController.class);
    private final AnnisUI ui;
    private final SearchView searchView;
    private final QueryUIState state;
    private final Binder<QueryUIState> binder;

    private static <T> void setIfNew(ListDataProvider<T> prop, Collection<T> newValue) {
        if (!Objects.equals(prop.getItems(), newValue)) {
            prop.getItems().clear();
            prop.getItems().addAll(newValue);
        }
    }

    private static <T> void setIfNew(Property<T> prop, T newValue) {
        if (!Objects.equals(prop.getValue(), newValue)) {
            prop.setValue(newValue);
        }
    }

    public QueryController(AnnisUI ui, SearchView searchView, QueryUIState state) {
        this.ui = ui;
        this.searchView = searchView;
        this.state = state;
        this.binder = new Binder(QueryUIState.class);
        this.binder.setBean((Object)state);
        this.state.getAql().addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.validateQuery());
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.validateQuery());
    }

    public Binder<QueryUIState> getBinder() {
        return this.binder;
    }

    public void addHistoryEntry(Query q) {
        try {
            Query queryCopy = q.clone();
            this.state.getHistory().removeItem((Object)queryCopy);
            this.state.getHistory().addItemAt(0, (Object)queryCopy);
            this.searchView.getControlPanel().getQueryPanel().updateShortHistory();
        }
        catch (CloneNotSupportedException ex) {
            log.error("Can't clone the query", (Throwable)ex);
        }
    }

    public void cancelExport() {
        Future exportFuture = (Future)this.state.getExecutedTasks().get(QueryUIState.QueryType.EXPORT);
        if (exportFuture != null && !exportFuture.isDone() && !exportFuture.cancel(true)) {
            log.warn("Could not cancel export");
        }
    }

    private void cancelSearch() {
        this.searchView.getControlPanel().getQueryPanel().setCountIndicatorEnabled(false);
        Map exec = this.state.getExecutedTasks();
        if (exec.containsKey(QueryUIState.QueryType.COUNT) && !((Future)exec.get(QueryUIState.QueryType.COUNT)).isDone()) {
            ((Future)exec.get(QueryUIState.QueryType.COUNT)).cancel(true);
        }
        if (exec.containsKey(QueryUIState.QueryType.FIND) && !((Future)exec.get(QueryUIState.QueryType.FIND)).isDone()) {
            ((Future)exec.get(QueryUIState.QueryType.FIND)).cancel(true);
        }
        exec.remove(QueryUIState.QueryType.COUNT);
        exec.remove(QueryUIState.QueryType.FIND);
    }

    public void changeContext(PagedResultQuery originalQuery, Match match, long offset, int newContext, VisualizerContextChanger visCtxChange, boolean left) {
        try {
            PagedResultQuery newQuery = (PagedResultQuery)originalQuery.clone();
            if (left) {
                newQuery.setLeftContext(newContext);
            } else {
                newQuery.setRightContext(newContext);
            }
            newQuery.setOffset(offset);
            UI ui = UI.getCurrent();
            Background.runWithCallback((Callable)new SingleResultFetchJob(match, newQuery, ui), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (CloneNotSupportedException ex) {
            log.error("Can't clone the query", (Throwable)ex);
        }
    }

    private void checkQuirksMode(Query query) {
        if (query.getQueryLanguage() == QueryLanguage.AQL_QUIRKS_V3) {
            Notification.show((String)"Using query language compatibility or \"quirks\" mode.", (String)"This means the semantics of the query language AQL are changed to match these of the previous ANNIS release 3. E.g. the range of the .* operator is limited to at maximum 50 in the compatibilty mode.\n\nYou can change the query language to the most recent version of AQL in the \"Search Options\" tab of the control pannel.", (Notification.Type)Notification.Type.WARNING_MESSAGE);
        }
    }

    public void corpusSelectionChangedInBackground() {
        this.searchView.getControlPanel().getCorpusList().selectedCorpusChanged(true);
        this.searchView.getControlPanel().getSearchOptions().updateSearchPanelConfigurationInBackground((Collection)this.getState().getSelectedCorpora());
    }

    public void executeExport(ExportPanel panel, EventBus eventBus) {
        Future exportFuture = (Future)this.state.getExecutedTasks().get(QueryUIState.QueryType.EXPORT);
        if (exportFuture != null && !exportFuture.isDone()) {
            exportFuture.cancel(true);
        }
        ExportQuery query = this.getExportQuery();
        this.checkQuirksMode((Query)query);
        this.addHistoryEntry((Query)query);
        Optional<ExporterPlugin> exporterImpl = this.ui.getExporterPlugins().stream().filter(e -> e.getClass().equals(query.getExporter())).findAny();
        UI ui = UI.getCurrent();
        if (exporterImpl.isPresent() && ui instanceof AnnisUI) {
            exportFuture = Background.call((Callable)new ExportBackgroundJob(query, exporterImpl.get(), (AnnisUI)ui, eventBus, panel));
            this.state.getExecutedTasks().put(QueryUIState.QueryType.EXPORT, exportFuture);
        }
    }

    public void executeFrequency(FrequencyQueryPanel panel) {
        Future freqFuture = (Future)this.state.getExecutedTasks().get(QueryUIState.QueryType.FREQUENCY);
        if (freqFuture != null && !freqFuture.isDone()) {
            freqFuture.cancel(true);
        }
        if ("".equals(this.state.getAql().getValue())) {
            Notification.show((String)"Empty query", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            panel.showQueryDefinitionPanel();
            return;
        }
        if (this.state.getSelectedCorpora().isEmpty()) {
            Notification.show((String)"Please select a corpus", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            panel.showQueryDefinitionPanel();
            return;
        }
        BeanContainer container = this.state.getFrequencyTableDefinition();
        FrequencyTableQuery freqDefinition = new FrequencyTableQuery();
        for (Integer id : container.getItemIds()) {
            UserGeneratedFrequencyEntry userGen = (UserGeneratedFrequencyEntry)container.getItem((Object)id).getBean();
            freqDefinition.add((Object)userGen.toFrequencyTableEntry());
        }
        FrequencyQuery query = (FrequencyQuery)((QueryGenerator.FrequencyQueryGenerator)((QueryGenerator.FrequencyQueryGenerator)((QueryGenerator.FrequencyQueryGenerator)QueryGenerator.frequency().query((String)this.state.getAql().getValue())).corpora(new LinkedHashSet(this.state.getSelectedCorpora()))).queryLanguage(this.state.getQueryLanguageLegacy())).def(freqDefinition).build();
        this.checkQuirksMode((Query)query);
        this.addHistoryEntry((Query)query);
        UI ui = UI.getCurrent();
        FrequencyBackgroundJob job = new FrequencyBackgroundJob(ui, this, query, panel);
        freqFuture = Background.call((Callable)job);
        this.state.getExecutedTasks().put(QueryUIState.QueryType.FREQUENCY, freqFuture);
    }

    public void executeSearch(boolean replaceOldTab, boolean freshQuery) {
        UI ui = UI.getCurrent();
        if (freshQuery && ui instanceof AnnisUI) {
            this.getState().getOffset().setValue((Object)0L);
            this.getState().getSelectedMatches().setValue(new TreeSet());
            Set selectedCorpora = this.getState().getSelectedCorpora();
            CorpusConfiguration config = new CorpusConfiguration();
            if (selectedCorpora != null && !selectedCorpora.isEmpty()) {
                config = ((AnnisUI)ui).getCorpusConfigWithCache((String)selectedCorpora.iterator().next());
            }
            if (config.getView() != null) {
                String configVal = config.getView().getBaseTextSegmentation();
                if ("".equals(configVal) || "tok".equals(configVal)) {
                    configVal = null;
                }
                this.getState().getVisibleBaseText().setValue((Object)configVal);
            }
        }
        DisplayedResultQuery displayedQuery = this.getSearchQuery();
        this.searchView.getControlPanel().getQueryPanel().setStatus("Searching...");
        this.cancelSearch();
        VaadinSession session = VaadinSession.getCurrent();
        session.setAttribute(IFrameResourceMap.class, (Object)new IFrameResourceMap());
        if (session.getAttribute(MediaController.class) != null) {
            ((MediaController)session.getAttribute(MediaController.class)).clearMediaPlayers();
        }
        this.searchView.updateFragment(displayedQuery);
        if (displayedQuery.getCorpora() == null || displayedQuery.getCorpora().isEmpty()) {
            this.searchView.getControlPanel().getQueryPanel().setStatus("No corpus selected");
            this.searchView.getControlPanel().getQueryPanel().setCountIndicatorEnabled(false);
            Notification.show((String)"Please select a corpus", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        if ("".equals(displayedQuery.getQuery())) {
            this.searchView.getControlPanel().getQueryPanel().setStatus("Empty query");
            this.searchView.getControlPanel().getQueryPanel().setCountIndicatorEnabled(false);
            Notification.show((String)"Empty query", (Notification.Type)Notification.Type.WARNING_MESSAGE);
            return;
        }
        this.checkQuirksMode((Query)displayedQuery);
        this.addHistoryEntry((Query)displayedQuery);
        ResultViewPanel oldPanel = this.searchView.getLastSelectedResultView();
        if (replaceOldTab) {
            this.searchView.closeTab((Component)oldPanel);
        }
        if (ui instanceof AnnisUI) {
            AnnisUI annisUI = (AnnisUI)ui;
            ResultViewPanel newResultView = new ResultViewPanel(annisUI, displayedQuery);
            newResultView.getPaging().addCallback((PagingCallback)new SpecificPagingCallback(annisUI, this.searchView, newResultView, displayedQuery));
            List existingResultPanels = this.getResultPanels();
            String caption = existingResultPanels.isEmpty() ? "Query Result" : "Query Result #" + (existingResultPanels.size() + 1);
            TabSheet.Tab newTab = this.searchView.getMainTab().addTab((Component)newResultView, caption);
            newTab.setClosable(true);
            newTab.setIcon((Resource)FontAwesome.SEARCH);
            this.searchView.getMainTab().setSelectedTab((Component)newResultView);
            this.searchView.notifiyQueryStarted();
            Background.run((Runnable)new ResultFetchJob((PagedResultQuery)displayedQuery, newResultView, annisUI));
            this.searchView.getControlPanel().getQueryPanel().setCountIndicatorEnabled(true);
            SearchApi api = new SearchApi(Helper.getClient((UI)ui));
            CountQuery countQuery = new CountQuery();
            countQuery.setCorpora(new LinkedList(displayedQuery.getCorpora()));
            countQuery.setQuery(displayedQuery.getQuery());
            countQuery.setQueryLanguage(displayedQuery.getApiQueryLanguage());
            try {
                Call call = api.countAsync(countQuery, (ApiCallback)new CountCallback(newResultView, displayedQuery.getLimit(), annisUI));
                this.state.getExecutedCalls().put(QueryUIState.QueryType.COUNT, call);
            }
            catch (ApiException ex) {
                ExceptionDialog.show((Throwable)ex, (UI)ui);
            }
        }
    }

    public ExportQuery getExportQuery() {
        return (ExportQuery)((ExportQueryGenerator)((ExportQueryGenerator)((ExportQueryGenerator)((ExportQueryGenerator)((ExportQueryGenerator)((ExportQueryGenerator)new ExportQueryGenerator().query((String)this.state.getAql().getValue())).corpora(new LinkedHashSet(this.state.getSelectedCorpora()))).queryLanguage(this.state.getQueryLanguageLegacy())).left(this.state.getLeftContext())).right(this.state.getRightContext())).segmentation((String)this.state.getVisibleBaseText().getValue())).exporter((Class)this.state.getExporter().getValue()).annotations((List)this.state.getExportAnnotationKeys().getValue()).param((String)this.state.getExportParameters().getValue()).alignmc(((Boolean)this.state.getAlignmc().getValue()).booleanValue()).build();
    }

    private List<ResultViewPanel> getResultPanels() {
        ArrayList<ResultViewPanel> result = new ArrayList<ResultViewPanel>();
        for (int i = 0; i < this.searchView.getMainTab().getComponentCount(); ++i) {
            Component c = this.searchView.getMainTab().getTab(i).getComponent();
            if (!(c instanceof ResultViewPanel)) continue;
            result.add((ResultViewPanel)c);
        }
        return result;
    }

    public DisplayedResultQuery getSearchQuery() {
        return (DisplayedResultQuery)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)((QueryGenerator.DisplayedResultQueryGenerator)QueryGenerator.displayed().query((String)this.state.getAql().getValue())).corpora(new LinkedHashSet(this.state.getSelectedCorpora()))).queryLanguage(this.state.getQueryLanguageLegacy())).left(this.state.getLeftContext())).right(this.state.getRightContext())).segmentation(this.state.getContextSegmentation())).baseText((String)this.state.getVisibleBaseText().getValue()).limit(this.state.getLimit())).offset(((Long)this.state.getOffset().getValue()).longValue())).order(this.state.getOrder())).selectedMatches((Set)this.state.getSelectedMatches().getValue()).build();
    }

    public QueryUIState getState() {
        return this.state;
    }

    public void reportServiceException(ApiException ex, boolean showNotification) {
        QueryPanel qp = this.searchView.getControlPanel().getQueryPanel();
        String caption = null;
        String description = null;
        if (!this.ui.handleCommonError((Throwable)ex, "execute query")) {
            switch (ex.getCode()) {
                case 400: {
                    BadRequestError error = (BadRequestError)JSON.createGson().create().fromJson(ex.getResponseBody(), BadRequestError.class);
                    caption = "Parsing error";
                    description = error.getAqLSyntaxError() != null ? error.getAqLSyntaxError().getDesc() : (error.getAqLSemanticError() != null ? error.getAqLSemanticError().getDesc() : (error.getImpossibleSearch() != null ? error.getImpossibleSearch() : error.toString()));
                    qp.setError(error);
                    qp.setStatus(description);
                    break;
                }
                case 504: {
                    caption = "Timeout";
                    description = "Query execution took too long.";
                    qp.setStatus(caption + ": " + description);
                    break;
                }
                case 403: {
                    if (!Helper.getUser((SecurityContext)this.ui.getSecurityContext()).isPresent()) {
                        qp.setStatus("You don't have the access rights to query this corpus. You might want to login to access more corpora.");
                        break;
                    }
                    caption = "You don't have the access rights to query this corpus. You might want to login as another user to access more corpora.";
                    qp.setStatus(caption);
                    break;
                }
                default: {
                    log.error("Exception when communicating with service", (Throwable)ex);
                    qp.setStatus("Unexpected exception:  " + ex.getMessage());
                    ExceptionDialog.show((Throwable)ex, (String)"Exception when communicating with service.", (UI)this.ui);
                }
            }
            if (showNotification && caption != null) {
                Notification.show((String)caption, (String)description, (Notification.Type)Notification.Type.WARNING_MESSAGE);
            }
        }
        this.searchView.getControlPanel().getQueryPanel().setCountIndicatorEnabled(false);
    }

    public void setQuery(Query q) {
        QueryController.setIfNew((Property)this.state.getAql(), (Object)q.getQuery());
        if (q.getQueryLanguage() != this.state.getQueryLanguageLegacy()) {
            this.state.setQueryLanguageLegacy(q.getQueryLanguage());
        }
        if (!Objects.deepEquals(this.state.getSelectedCorpora(), q.getCorpora())) {
            this.state.setSelectedCorpora(q.getCorpora());
            this.corpusSelectionChangedInBackground();
        }
        if (q instanceof ContextualizedQuery) {
            if (!Objects.equals(this.state.getLeftContext(), ((ContextualizedQuery)q).getLeftContext())) {
                this.state.setLeftContext(((ContextualizedQuery)q).getLeftContext());
            }
            if (!Objects.equals(this.state.getRightContext(), ((ContextualizedQuery)q).getRightContext())) {
                this.state.setRightContext(((ContextualizedQuery)q).getRightContext());
            }
            if (!Objects.equals(this.state.getContextSegmentation(), ((ContextualizedQuery)q).getSegmentation())) {
                this.state.setContextSegmentation(((ContextualizedQuery)q).getSegmentation());
            }
        }
        if (q instanceof PagedResultQuery) {
            QueryController.setIfNew((Property)this.state.getOffset(), (Object)((PagedResultQuery)q).getOffset());
            if (!Objects.equals(this.state.getLimit(), ((PagedResultQuery)q).getLimit())) {
                this.state.setLimit(((PagedResultQuery)q).getLimit());
            }
            if (!Objects.equals(this.state.getOrder(), ((PagedResultQuery)q).getOrder())) {
                this.state.setOrder(((PagedResultQuery)q).getOrder());
            }
        }
        if (q instanceof DisplayedResultQuery) {
            QueryController.setIfNew((Property)this.state.getSelectedMatches(), (Object)((DisplayedResultQuery)q).getSelectedMatches());
            QueryController.setIfNew((Property)this.state.getVisibleBaseText(), (Object)((DisplayedResultQuery)q).getBaseText());
        }
        if (q instanceof ExportQuery) {
            QueryController.setIfNew((Property)this.state.getExporter(), (Object)((ExportQuery)q).getExporter());
            QueryController.setIfNew((Property)this.state.getExportAnnotationKeys(), (Object)((ExportQuery)q).getAnnotationKeys());
            QueryController.setIfNew((Property)this.state.getExportParameters(), (Object)((ExportQuery)q).getParameters());
            QueryController.setIfNew((Property)this.state.getAlignmc(), (Object)((ExportQuery)q).getAlignmc());
        }
        this.binder.setBean((Object)this.state);
    }

    public void validateQuery() {
        QueryPanel qp = this.searchView.getControlPanel().getQueryPanel();
        qp.setError(null);
        qp.setNodes(null);
        String query = (String)this.state.getAql().getValue();
        if (query == null || query.isEmpty()) {
            qp.setStatus("Empty query");
        } else {
            UI ui = UI.getCurrent();
            Background.runWithCallback(() -> {
                SearchApi api = new SearchApi(Helper.getClient((UI)ui));
                return api.nodeDescriptions(query, org.corpus_tools.annis.api.model.QueryLanguage.AQL);
            }, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ QueryUIState access$000(QueryController x0) {
        return x0.state;
    }
}

