/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import java.util.LinkedHashSet;
import java.util.Set;
import org.corpus_tools.annis.gui.QueryGenerator;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;

public class QueryGenerator<T extends Query, QG extends QueryGenerator<T, QG>> {
    private final T current;

    public static DisplayedResultQueryGenerator displayed() {
        return new DisplayedResultQueryGenerator(null);
    }

    public static FrequencyQueryGenerator frequency() {
        return new FrequencyQueryGenerator();
    }

    private QueryGenerator(T current) {
        this.current = current;
    }

    public T build() {
        return (T)this.current;
    }

    public QG corpora(Set<String> corpora) {
        this.current.setCorpora(new LinkedHashSet<String>(corpora));
        return (QG)this;
    }

    protected T getCurrent() {
        return (T)this.current;
    }

    public QG query(String aql) {
        this.current.setQuery(aql);
        return (QG)this;
    }

    public QG queryLanguage(QueryLanguage queryLanguage) {
        this.current.setQueryLanguage(queryLanguage);
        return (QG)this;
    }
}

