/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.server.UserError;
import com.vaadin.server.VaadinService;
import com.vaadin.shared.Version;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.BeanItem;
import com.vaadin.v7.ui.Field;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.UUID;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.MetaDataPanel;
import org.corpus_tools.annis.gui.ReportBugWindow;
import org.corpus_tools.annis.gui.UIConfig;
import org.corpus_tools.annis.gui.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBugWindow
extends Window {
    private static final long serialVersionUID = 6934305621630854399L;
    private static final Logger log = LoggerFactory.getLogger(MetaDataPanel.class);
    private FieldGroup form;
    private Button btSubmit;
    private Button btCancel;
    private Throwable cause;

    public ReportBugWindow(String bugEMailAddress, byte[] screenImage, String imageMimeType, Throwable cause) {
        this.cause = cause;
        this.setSizeUndefined();
        this.setCaption("Report Problem");
        ReportFormLayout layout = new ReportFormLayout();
        this.setContent((Component)layout);
        layout.setWidth("100%");
        layout.setHeight("-1px");
        this.setHeight("420px");
        this.setWidth("750px");
        this.form = new FieldGroup((Item)new BeanItem((Object)new BugReport()));
        this.form.bindMemberFields((Object)layout);
        this.form.setBuffered(true);
        ReportBugWindow finalThis = this;
        this.btSubmit = new Button("Submit problem report", (Button.ClickListener & Serializable)event -> {
            try {
                this.form.commit();
                if (this.sendBugReport(bugEMailAddress, screenImage, imageMimeType)) {
                    Notification.show((String)"Problem report was sent", (String)"We will answer your problem report as soon as possible", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
                }
                UI.getCurrent().removeWindow((Window)finalThis);
            }
            catch (FieldGroup.CommitException ex1) {
                LinkedList<String> errorFields = new LinkedList<String>();
                for (Field f : this.form.getFields()) {
                    if (!(f instanceof AbstractComponent)) continue;
                    AbstractComponent c = (AbstractComponent)f;
                    if (f.isValid()) {
                        c.setComponentError(null);
                        continue;
                    }
                    errorFields.add(f.getCaption());
                    c.setComponentError((ErrorMessage)new UserError("Validation failed: "));
                }
                String message = "Please check the error messages (place mouse over red triangle) for the following fields:<br />";
                message = message + StringUtils.join(errorFields, (String)",<br/>");
                Notification notify = new Notification("Validation failed", message, Notification.Type.WARNING_MESSAGE, true);
                notify.show(UI.getCurrent().getPage());
            }
            catch (Exception ex2) {
                log.error("Could not send bug report", (Throwable)ex2);
                Notification.show((String)"Could not send bug report", (String)ex2.getMessage(), (Notification.Type)Notification.Type.WARNING_MESSAGE);
            }
        });
        this.btCancel = new Button("Cancel", (Button.ClickListener & Serializable)event -> {
            this.form.discard();
            UI.getCurrent().removeWindow((Window)finalThis);
        });
        this.addScreenshotPreview((Layout)layout, screenImage, imageMimeType);
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.addComponent((Component)this.btSubmit);
        buttons.addComponent((Component)this.btCancel);
        layout.addComponent((Component)buttons);
    }

    private void addScreenshotPreview(Layout layout, byte[] rawImage, String mimeType) {
        StreamResource res = new StreamResource((StreamResource.StreamSource)new ScreenDumpStreamSource(rawImage), "screendump_" + UUID.randomUUID().toString() + ".png");
        res.setMIMEType(mimeType);
        Image imgScreenshot = new Image("Attached screenshot", (Resource)res);
        imgScreenshot.setAlternateText("Screenshot of the ANNIS browser window, no other window or part of the desktop is captured.");
        imgScreenshot.setVisible(false);
        imgScreenshot.setWidth("100%");
        Button btShowScreenshot = new Button("Show attached screenshot", (Button.ClickListener)new ShowScreenshotClickListener(imgScreenshot));
        btShowScreenshot.addStyleName("link");
        btShowScreenshot.setIcon((Resource)FontAwesome.PLUS_SQUARE_O);
        layout.addComponent((Component)btShowScreenshot);
        layout.addComponent((Component)imgScreenshot);
    }

    private boolean sendBugReport(String bugEMailAddress, byte[] screenImage, String imageMimeType) {
        try {
            File logfile;
            MultiPartEmail mail = Helper.createEMailFromConfiguration((UIConfig)((AnnisUI)this.getUI()).getConfig());
            mail.addReplyTo(this.form.getField((Object)"email").getValue().toString(), this.form.getField((Object)"name").getValue().toString());
            mail.addTo(bugEMailAddress);
            mail.setSubject("[ANNIS BUG] " + this.form.getField((Object)"summary").getValue().toString());
            StringBuilder sbMsg = new StringBuilder();
            sbMsg.append("Reporter: ").append(this.form.getField((Object)"name").getValue().toString()).append(" (").append(this.form.getField((Object)"email").getValue().toString()).append(")\n");
            sbMsg.append("Version: ").append(VersionInfo.getVersion()).append("\n");
            sbMsg.append("Vaadin Version: ").append(Version.getFullVersion()).append("\n");
            sbMsg.append("Browser: ").append(Page.getCurrent().getWebBrowser().getBrowserApplication()).append("\n");
            sbMsg.append("URL: ").append(UI.getCurrent().getPage().getLocation().toASCIIString()).append("\n");
            sbMsg.append("\n");
            sbMsg.append(this.form.getField((Object)"description").getValue().toString());
            mail.setMsg(sbMsg.toString());
            if (screenImage != null) {
                mail.attach((DataSource)new ByteArrayDataSource(screenImage, imageMimeType), "screendump.png", "Screenshot of the browser content at time of problem report");
            }
            if ((logfile = new File(VaadinService.getCurrent().getBaseDirectory(), "/WEB-INF/log/annis-gui.log")).exists() && logfile.isFile() && logfile.canRead()) {
                mail.attach((DataSource)new FileDataSource(logfile), "annis-gui.log", "Logfile of the GUI (shared by all users)");
            }
            if (this.cause != null) {
                try {
                    mail.attach((DataSource)new ByteArrayDataSource(Helper.convertExceptionToMessage((Throwable)this.cause), "text/plain"), "exception.txt", "Exception that caused the user to report the problem");
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            mail.send();
            return true;
        }
        catch (UnknownHostException | EmailException ex) {
            Notification.show((String)"E-Mail not configured on server", (String)("If this is no Kickstarter version please ask the administrator (" + bugEMailAddress + ") of this ANNIS-instance for assistance. Problem reports are not available for ANNIS Kickstarter"), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            log.error(null, ex);
            return false;
        }
    }
}

