/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.corpus_tools.annis.gui.UIConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Component;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

@Component
@Profile(value={"!desktop"})
public class ServiceStarter
implements ApplicationListener<ApplicationReadyEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServiceStarter.class);
    @Autowired
    private UIConfig config;
    @Autowired
    private ResourceLoader resourceLoader;
    private final AtomicBoolean abortThread = new AtomicBoolean();
    private Process backgroundProcess;
    private Thread tReaderOut;
    private Thread tReaderErr;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (this.config.getWebserviceUrl() == null || this.config.getWebserviceUrl().isEmpty()) {
            try {
                Optional<Object> execPath = Optional.empty();
                if ("amd64".equals(SystemUtils.OS_ARCH) || "x86_64".equals(SystemUtils.OS_ARCH)) {
                    if (SystemUtils.IS_OS_LINUX) {
                        execPath = Optional.of("linux-x86-64/graphannis-webservice");
                    } else if (SystemUtils.IS_OS_MAC_OSX) {
                        execPath = Optional.of("darwin/graphannis-webservice.osx");
                    } else if (SystemUtils.IS_OS_WINDOWS) {
                        execPath = Optional.of("win32-x86-64/graphannis-webservice.exe");
                    }
                } else {
                    log.error("GraphANNIS can only be run on 64 bit operating systems (\"amd64\" or \"x86_64\"), but this is reported as architecture {}!", (Object)SystemUtils.OS_ARCH);
                }
                if (execPath.isPresent()) {
                    File tmpExec = File.createTempFile("graphannis-webservice-", "");
                    Resource resource = this.resourceLoader.getResource("classpath:" + (String)execPath.get());
                    if (resource.exists()) {
                        log.info("Extracting the bundled graphANNIS service to {}", (Object)tmpExec.getAbsolutePath());
                        FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)tmpExec);
                        if (!tmpExec.setExecutable(true)) {
                            log.warn("Could not mark the bundled graphANNIS service as executable");
                        }
                        File serviceConfigFile = this.getServiceConfig();
                        log.info("Starting the bundled graphANNIS service with configuration file {}", (Object)serviceConfigFile.getAbsolutePath());
                        this.backgroundProcess = new ProcessBuilder(tmpExec.getAbsolutePath(), "--config", serviceConfigFile.getAbsolutePath()).start();
                        BufferedReader outputStream = new BufferedReader(new InputStreamReader(this.backgroundProcess.getInputStream(), StandardCharsets.UTF_8));
                        BufferedReader errorStream = new BufferedReader(new InputStreamReader(this.backgroundProcess.getErrorStream(), StandardCharsets.UTF_8));
                        this.tReaderOut = new Thread(() -> {
                            while (!this.abortThread.get() && this.backgroundProcess.isAlive()) {
                                block3: {
                                    try {
                                        String line = outputStream.readLine();
                                        if (line == null) break block3;
                                        log.info(line);
                                    }
                                    catch (IOException ex) {
                                        if (this.abortThread.get()) break;
                                        log.error("Could not read service output", (Throwable)ex);
                                        break;
                                    }
                                }
                                Thread.yield();
                            }
                        });
                        this.tReaderOut.start();
                        this.tReaderErr = new Thread(() -> {
                            while (!this.abortThread.get() && this.backgroundProcess.isAlive()) {
                                block3: {
                                    try {
                                        String line = errorStream.readLine();
                                        if (line == null) break block3;
                                        log.error(line);
                                    }
                                    catch (IOException ex) {
                                        if (this.abortThread.get()) break;
                                        log.error("Could not read service error output", (Throwable)ex);
                                        break;
                                    }
                                }
                                Thread.yield();
                            }
                        });
                        this.tReaderErr.start();
                        TomlParseResult parsedServiceConfig = Toml.parse((Path)serviceConfigFile.toPath());
                        this.config.setWebserviceUrl(this.getServiceURL(parsedServiceConfig));
                    }
                }
            }
            catch (IOException ex) {
                log.error("Could not start integrated graphANNIS service, configure \"annis.webservice-url\" to set an existing service.", (Throwable)ex);
            }
        }
    }

    protected String getServiceURL(TomlParseResult config) {
        return "http://localhost:" + config.getLong("bind.port", () -> 5711L) + "/v1";
    }

    protected File getServiceConfig() throws IOException {
        LinkedHashMap<String, String> databaseConfig;
        File result = new File(this.config.getWebserviceConfig());
        if (!result.exists()) {
            File parentDir = result.getParentFile();
            if (!parentDir.mkdirs()) {
                log.error("Could not create directory {}", (Object)parentDir.getAbsolutePath());
            }
            if (!result.createNewFile()) {
                log.error("Could not create new file {}", (Object)result.getAbsolutePath());
            }
        }
        TomlParseResult configToml = Toml.parse((Path)result.toPath());
        Map config = configToml.toMap();
        TomlTable databaseTable = configToml.getTable("database");
        if (databaseTable == null) {
            databaseConfig = new LinkedHashMap<String, String>();
            config.put("database", databaseConfig);
        } else {
            databaseConfig = databaseTable.toMap();
        }
        String previousDatabase = databaseConfig.putIfAbsent("graphannis", Paths.get(System.getProperty("user.home"), ".annis", "v4").toAbsolutePath().toString());
        String previousSqlite = databaseConfig.putIfAbsent("sqlite", Paths.get(System.getProperty("user.home"), ".annis", "v4", "service_data.sqlite3").toAbsolutePath().toString());
        if (previousDatabase == null || previousSqlite == null) {
            TomlWriter writer = new TomlWriter();
            writer.write((Object)config, result);
        }
        return result;
    }

    public void destroy() throws Exception {
        this.abortThread.set(true);
        if (this.tReaderOut != null) {
            this.tReaderOut.interrupt();
        }
        if (this.tReaderErr != null) {
            this.tReaderErr.interrupt();
        }
        if (this.backgroundProcess != null) {
            this.backgroundProcess.destroy();
            if (!this.backgroundProcess.waitFor(5L, TimeUnit.SECONDS)) {
                log.warn("GraphANNIS process did not stop after 5 seconds, stopping it forcefully");
                this.backgroundProcess.destroyForcibly();
            } else {
                log.info("Stopped graphANNIS process");
            }
        }
    }

    public Optional<UsernamePasswordAuthenticationToken> getDesktopUserToken() {
        return Optional.empty();
    }
}

