/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.github.jjYBdx4IL.utils.awt.Desktop;
import com.moandjiezana.toml.TomlWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import org.apache.commons.lang3.RandomStringUtils;
import org.corpus_tools.annis.gui.ServiceStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.stereotype.Component;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Profile(value={"desktop"})
public class ServiceStarterDesktop
extends ServiceStarter {
    private static final String USER_NAME = "desktop";
    private static final Logger log = LoggerFactory.getLogger(ServiceStarterDesktop.class);
    private final String secret = RandomStringUtils.randomAlphanumeric((int)50);
    private Optional<UsernamePasswordAuthenticationToken> desktopUserCredentials = Optional.empty();
    @Value(value="${server.port}")
    private String serverPort;
    @Autowired
    private Environment env;

    protected static List<Object> unpackToml(TomlArray orig) {
        ArrayList<Object> result = new ArrayList<Object>(orig.size());
        for (Object o : orig.toList()) {
            if (o instanceof TomlArray) {
                TomlArray tomlArray = (TomlArray)o;
                result.add(ServiceStarterDesktop.unpackToml((TomlArray)tomlArray));
                continue;
            }
            if (o instanceof TomlTable) {
                TomlTable tomlTable = (TomlTable)o;
                result.add(ServiceStarterDesktop.unpackToml((TomlTable)tomlTable));
                continue;
            }
            result.add(o);
        }
        return result;
    }

    protected static Map<String, Object> unpackToml(TomlTable orig) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry e : orig.toMap().entrySet()) {
            if (e.getValue() instanceof TomlArray) {
                TomlArray tomlArray = (TomlArray)e.getValue();
                result.put((String)e.getKey(), ServiceStarterDesktop.unpackToml((TomlArray)tomlArray));
                continue;
            }
            if (e.getValue() instanceof TomlTable) {
                TomlTable tomlTable = (TomlTable)e.getValue();
                result.put((String)e.getKey(), ServiceStarterDesktop.unpackToml((TomlTable)tomlTable));
                continue;
            }
            result.put((String)e.getKey(), e.getValue());
        }
        return result;
    }

    protected File getServiceConfig() throws IOException {
        TomlParseResult tomlConfig = Toml.parse((Path)super.getServiceConfig().toPath());
        Map config = ServiceStarterDesktop.unpackToml((TomlTable)tomlConfig);
        LinkedHashMap<String, String> tokenVerification = new LinkedHashMap<String, String>();
        tokenVerification.put("type", "HS256");
        tokenVerification.put("secret", this.secret);
        HashMap<String, LinkedHashMap<String, String>> auth = new HashMap<String, LinkedHashMap<String, String>>();
        auth.put("token_verification", tokenVerification);
        config.put("auth", auth);
        File temporaryFile = File.createTempFile("annis-service-config-desktop-", ".toml");
        TomlWriter writer = new TomlWriter();
        writer.write((Object)config, temporaryFile);
        return temporaryFile;
    }

    private void showApplicationWindow() {
        try {
            UIManager.setLookAndFeel(new NimbusLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException ex) {
            log.warn("Look and feel not supported", (Throwable)ex);
        }
        JFrame mainFrame = new JFrame("ANNIS Desktop");
        BorderLayout mainLayout = new BorderLayout();
        mainFrame.getContentPane().setLayout(mainLayout);
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocationByPlatform(true);
        String webURL = "http://localhost:" + this.serverPort;
        JButton btLaunch = new JButton();
        btLaunch.setMnemonic('u');
        btLaunch.setForeground(Color.blue);
        btLaunch.setText("<html><u>Open " + webURL + " in browser</u></html>");
        btLaunch.setEnabled(true);
        btLaunch.setName("btLaunch");
        btLaunch.addActionListener(evt -> this.openBrowser(webURL));
        btLaunch.setPreferredSize(new Dimension(300, 60));
        mainFrame.getContentPane().add((java.awt.Component)btLaunch, "Center");
        JButton btExit = new JButton("Exit");
        btExit.addActionListener(evt -> System.exit(0));
        mainFrame.getContentPane().add((java.awt.Component)btExit, "Last");
        mainFrame.pack();
        Integer[] sizes = new Integer[]{192, 128, 64, 48, 32, 16, 14};
        LinkedList<BufferedImage> allImages = new LinkedList<BufferedImage>();
        Integer[] integerArray = sizes;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int s = integerArray[i];
            try {
                BufferedImage imgIcon = ImageIO.read(ServiceStarterDesktop.class.getResource("logo/annis_" + s + ".png"));
                allImages.add(imgIcon);
                continue;
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        mainFrame.setIconImages(allImages);
        mainFrame.setVisible(true);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        java.awt.Desktop desktop;
        super.onApplicationEvent(event);
        List<String> roles = Arrays.asList("admin");
        Instant issuedAt = Instant.now();
        Instant expiresAt = Instant.now().plus(7L, ChronoUnit.DAYS);
        String signedToken = JWT.create().withSubject("desktop").withClaim("https://corpus-tools.org/annis/roles", roles).withExpiresAt(Date.from(expiresAt)).withIssuedAt(Date.from(issuedAt)).sign(Algorithm.HMAC256((String)this.secret));
        List<SimpleGrantedAuthority> grantedAuthorities = Arrays.asList(new SimpleGrantedAuthority("admin"));
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put("https://corpus-tools.org/annis/roles", roles);
        claims.put("sub", "desktop");
        OidcIdToken token = new OidcIdToken(signedToken, issuedAt, expiresAt, claims);
        DefaultOidcUser user = new DefaultOidcUser(grantedAuthorities, token);
        this.desktopUserCredentials = Optional.of(new UsernamePasswordAuthenticationToken((Object)user, (Object)signedToken, grantedAuthorities));
        String webURL = "http://localhost:" + this.serverPort;
        boolean isRunningHeadless = Arrays.stream(this.env.getActiveProfiles()).anyMatch("headless"::equals);
        java.awt.Desktop desktop2 = desktop = !isRunningHeadless && java.awt.Desktop.isDesktopSupported() ? java.awt.Desktop.getDesktop() : null;
        if (desktop == null) {
            log.warn("ANNIS is running in desktop mode, but no desktop has been detected. You can open {} manually.", (Object)webURL);
        } else {
            this.showApplicationWindow();
            this.openBrowser(webURL);
        }
    }

    private void openBrowser(String webURL) {
        log.info("Opening {} in browser", (Object)webURL);
        boolean supported = true;
        try {
            supported = Desktop.browse((URI)new URI(webURL));
        }
        catch (URISyntaxException ex) {
            log.error("Could not open " + webURL + " in browser.", (Throwable)ex);
            supported = false;
        }
        catch (UnsupportedOperationException ex) {
            supported = false;
        }
        if (!supported) {
            log.warn("Opening the browser is unsupported on this platform. Please open {} in your browser manually.", (Object)webURL);
            JOptionPane.showMessageDialog(null, "Cannot open the browser automatically. You can manually browse to " + webURL + " top open the ANNIS interface.");
        }
    }

    public Optional<UsernamePasswordAuthenticationToken> getDesktopUserToken() {
        return this.desktopUserCredentials;
    }
}

