/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.model;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.CriticalServiceQueryException;
import org.corpus_tools.annis.gui.ServiceQueryException;
import org.corpus_tools.annis.gui.admin.model.ApiClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusManagement
implements Serializable {
    private static final long serialVersionUID = -5750760811957151548L;
    private final TreeSet<String> corpora = new TreeSet();
    private ApiClientProvider clientProvider;
    private final Logger log = LoggerFactory.getLogger(CorpusManagement.class);

    public void clear() {
        this.corpora.clear();
    }

    public void delete(String corpusName) throws CriticalServiceQueryException, ServiceQueryException {
        if (this.clientProvider != null) {
            CorporaApi api = new CorporaApi(this.clientProvider.getClient());
            try {
                api.deleteCorpus(corpusName);
            }
            catch (ApiException ex) {
                if (ex.getCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    throw new CriticalServiceQueryException("You are not authorized to delete a corpus");
                }
                if (ex.getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                    throw new ServiceQueryException("Corpus with name " + corpusName + " not found");
                }
                this.log.error(null, (Throwable)ex);
                throw new ServiceQueryException("Remote exception: " + ex.getLocalizedMessage());
            }
        }
    }

    public void fetchFromService() throws CriticalServiceQueryException, ServiceQueryException {
        if (this.clientProvider != null) {
            this.corpora.clear();
            CorporaApi api = new CorporaApi(this.clientProvider.getClient());
            try {
                this.corpora.addAll(api.listCorpora());
            }
            catch (ApiException ex) {
                if (ex.getCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    throw new CriticalServiceQueryException("You are not authorized to get the corpus list.");
                }
                this.log.error(null, (Throwable)ex);
                throw new ServiceQueryException("Remote exception: " + ex.getLocalizedMessage());
            }
        }
    }

    public ImmutableList<String> getCorpora() {
        return ImmutableList.copyOf((Collection)this.corpora);
    }

    public ApiClientProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(ApiClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }
}

