/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.admin.reflinks;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.server.Setter;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.HeaderRow;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.admin.reflinks.TemporaryUrlSetter;
import org.corpus_tools.annis.gui.admin.reflinks.TemporaryUrlValueProvider;
import org.corpus_tools.annis.gui.query_references.UrlShortener;
import org.corpus_tools.annis.gui.query_references.UrlShortenerEntry;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class ReferenceLinkEditor
extends Panel {
    private static final long serialVersionUID = 6191359393713574090L;
    private final Grid<UrlShortenerEntry> grid = new Grid();
    private final TextField txtFilterId;
    private ConfigurableFilterDataProvider<UrlShortenerEntry, Void, UUID> dataProvider;
    private Grid.Column<UrlShortenerEntry, URI> temporaryColumn;

    public ReferenceLinkEditor() {
        this.grid.setSizeFull();
        Grid.Column idColumn = this.grid.addColumn(UrlShortenerEntry::getId);
        idColumn.setCaption("UUID");
        idColumn.setSortProperty(new String[]{"id"});
        Grid.Column createdColumn = this.grid.addColumn(UrlShortenerEntry::getCreated);
        createdColumn.setCaption("Timestamp");
        createdColumn.setSortProperty(new String[]{"created"});
        Grid.Column ownerColumn = this.grid.addColumn(UrlShortenerEntry::getOwner);
        ownerColumn.setCaption("Created by");
        ownerColumn.setSortProperty(new String[]{"owner"});
        this.temporaryColumn = this.grid.addColumn(UrlShortenerEntry::getTemporaryUrl);
        this.temporaryColumn.setCaption("Temporary URL");
        this.temporaryColumn.setSortProperty(new String[]{"temporaryUrl"});
        this.temporaryColumn.setId("temporaryUrl");
        Grid.Column urlColumn = this.grid.addColumn(UrlShortenerEntry::getUrl);
        urlColumn.setCaption("URL");
        urlColumn.setSortProperty(new String[]{"url"});
        HeaderRow filterRow = this.grid.appendHeaderRow();
        this.txtFilterId = new TextField();
        this.txtFilterId.setPlaceholder("Find UUID");
        this.txtFilterId.setWidthFull();
        this.txtFilterId.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.dataProvider.setFilter(null);
            if (event.getValue() != null && !((String)event.getValue()).isEmpty()) {
                try {
                    UUID id = UUID.fromString((String)event.getValue());
                    this.dataProvider.setFilter((Object)id);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        filterRow.getCell(idColumn).setComponent((Component)this.txtFilterId);
        this.grid.getEditor().setEnabled(true);
        this.grid.getEditor().setBuffered(true);
        this.setSizeFull();
    }

    private void addEditableBindings(Grid.Column<UrlShortenerEntry, URI> temporaryColumn, DataProvider<UrlShortenerEntry, ?> provider, AnnisUI ui) {
        TextField txtTemporary = new TextField();
        Binder binder = this.grid.getEditor().getBinder();
        Binder.Binding temporaryBinding = binder.bind((HasValue)txtTemporary, (ValueProvider)new TemporaryUrlValueProvider(), (Setter)new TemporaryUrlSetter(ui, provider));
        temporaryColumn.setEditorBinding(temporaryBinding);
    }

    private PageRequest createPageRequest(int offset, int limit, Sort sort) {
        int minPageSize = limit;
        int lastIndex = offset + limit - 1;
        int maxPageSize = lastIndex + 1;
        for (double pageSize = (double)minPageSize; pageSize <= (double)maxPageSize; pageSize += 1.0) {
            int startPage = (int)((double)offset / pageSize);
            int endPage = (int)((double)lastIndex / pageSize);
            if (startPage != endPage) continue;
            return PageRequest.of((int)startPage, (int)((int)pageSize), (Sort)sort);
        }
        return PageRequest.of((int)0, (int)maxPageSize, (Sort)sort);
    }

    private DataProvider<UrlShortenerEntry, UUID> createDataProvider(UrlShortener shortener) {
        return DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            Sort sort = Sort.by(query.getSortOrders().stream().map(o -> {
                if (o.getDirection() == SortDirection.DESCENDING) {
                    return Sort.Order.desc((String)o.getSorted());
                }
                return Sort.Order.asc((String)o.getSorted());
            }).collect(Collectors.toList()));
            PageRequest request = this.createPageRequest(query.getOffset(), query.getLimit(), sort);
            if (query.getFilter().isPresent()) {
                LinkedList result = new LinkedList();
                try {
                    Optional entry = shortener.getRepo().findById(query.getFilter().get());
                    if (entry.isPresent()) {
                        result.add(entry.get());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return result.stream();
            }
            return shortener.getRepo().findAll((Pageable)request).stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> {
            if (query.getFilter().isPresent()) {
                if (shortener.getRepo().findById(query.getFilter().get()).isPresent()) {
                    return 1;
                }
                return 0;
            }
            return (int)shortener.getRepo().count();
        });
    }

    public void attach() {
        List roles;
        Optional user;
        super.attach();
        if (this.getUI() instanceof AnnisUI) {
            AnnisUI annisUI = (AnnisUI)this.getUI();
            UrlShortener shortener = annisUI.getUrlShortener();
            this.dataProvider = this.createDataProvider(shortener).withConfigurableFilter();
            this.grid.setDataProvider((DataProvider)this.dataProvider);
            this.addEditableBindings(this.temporaryColumn, (DataProvider)this.dataProvider, annisUI);
        }
        if ((user = Helper.getUser((UI)this.getUI())).isPresent() && (roles = ((OidcUser)user.get()).getClaimAsStringList("https://corpus-tools.org/annis/roles")) != null && roles.contains("admin")) {
            this.setContent((Component)this.grid);
        }
    }
}

