/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components.codemirror;

import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.event.SerializableEventListener;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.ObjectProperty;
import com.vaadin.v7.event.FieldEvents;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.corpus_tools.annis.api.model.BadRequestError;
import org.corpus_tools.annis.api.model.QueryAttributeDescription;
import org.corpus_tools.annis.gui.components.codemirror.AqlCodeEditor;
import org.corpus_tools.annis.gui.components.codemirror.AqlCodeEditorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JavaScript(value={"vaadin://jquery.js", "lib/codemirror.js", "mode/aql/aql.js", "lib/edit/matchbrackets.js", "lib/lint/lint.js", "lib/display/placeholder.js", "AqlCodeEditor.js"})
@StyleSheet(value={"lib/codemirror.css", "lib/lint/lint.css", "AqlCodeEditor.css"})
public class AqlCodeEditor
extends AbstractJavaScriptComponent
implements FieldEvents.TextChangeNotifier,
Property.Viewer,
Property.ValueChangeListener {
    private static final long serialVersionUID = 6912362703243923469L;
    private static final Logger log = LoggerFactory.getLogger(AqlCodeEditor.class);
    private int timeout;
    private Property<String> dataSource;

    public AqlCodeEditor() {
        this.addFunction("textChanged", (JavaScriptFunction)new TextChangedFunction(this, null));
        this.addStyleName("aql-code-editor");
        this.setPropertyDataSource((Property)new ObjectProperty((Object)"", String.class));
        this.getState().serverRequestCounter = 1L;
    }

    public void addTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.addListener("ie", FieldEvents.TextChangeEvent.class, (SerializableEventListener)listener, FieldEvents.TextChangeListener.EVENT_METHOD);
    }

    public Property<String> getPropertyDataSource() {
        return this.dataSource;
    }

    protected AqlCodeEditorState getState() {
        return (AqlCodeEditorState)super.getState();
    }

    public String getTextareaStyle() {
        return this.getState().textareaClass == null ? "" : this.getState().textareaClass;
    }

    public int getTextChangeTimeout() {
        return this.timeout;
    }

    public String getValue() {
        return (String)this.dataSource.getValue();
    }

    private TreeMap<String, Integer> mapQueryNodes(List<QueryAttributeDescription> nodes) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        HashMap<Integer, TreeSet<Integer>> alternative2Nodes = new HashMap<Integer, TreeSet<Integer>>();
        int nodeIdx = 1;
        for (QueryAttributeDescription n : nodes) {
            TreeSet<Integer> orderedNodeSet = (TreeSet<Integer>)alternative2Nodes.get(n.getAlternative());
            if (orderedNodeSet == null) {
                orderedNodeSet = new TreeSet<Integer>();
                alternative2Nodes.put(n.getAlternative(), orderedNodeSet);
            }
            orderedNodeSet.add(nodeIdx++);
        }
        for (TreeSet orderedNodeSet : alternative2Nodes.values()) {
            int newID = 1;
            for (Integer idx : orderedNodeSet) {
                result.put("" + idx, newID);
                ++newID;
            }
        }
        return result;
    }

    public void removeTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.removeListener("ie", FieldEvents.TextChangeEvent.class, (Object)listener);
    }

    public void setError(BadRequestError error) {
        this.getState().errors.clear();
        if (error != null) {
            if (error.getAqLSyntaxError() != null) {
                this.getState().errors.add(new AqlCodeEditorState.ParseError(error.getAqLSyntaxError()));
            }
            if (error.getAqLSemanticError() != null) {
                this.getState().errors.add(new AqlCodeEditorState.ParseError(error.getAqLSemanticError()));
            }
        }
        this.markAsDirty();
    }

    public void setInputPrompt(String prompt) {
        this.getState().inputPrompt = prompt;
        this.markAsDirty();
    }

    public void setNodes(List<QueryAttributeDescription> nodes) {
        this.getState().nodeMappings.clear();
        if (nodes != null) {
            this.getState().nodeMappings.putAll(this.mapQueryNodes(nodes));
        }
    }

    public void setPropertyDataSource(Property newDataSource) {
        if (newDataSource == null) {
            throw new IllegalArgumentException("Data source must not be null");
        }
        if (newDataSource.getType() != String.class) {
            throw new IllegalArgumentException("Data source must be of type String");
        }
        if (this.dataSource instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)this.dataSource).removeValueChangeListener((Property.ValueChangeListener)this);
        }
        this.dataSource = newDataSource;
        if (newDataSource instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)this.dataSource).addValueChangeListener((Property.ValueChangeListener)this);
        }
    }

    public void setTextareaStyle(String style) {
        this.getState().textareaClass = "".equals(style) ? null : style;
    }

    public void setTextChangeTimeout(int timeout) {
        this.callFunction("setChangeDelayTime", new Object[]{timeout});
        this.timeout = timeout;
    }

    public void setValue(String value) {
        this.dataSource.setValue((Object)value);
    }

    public void valueChange(Property.ValueChangeEvent event) {
        log.debug("valueChange \"{}\"/\"{}", event.getProperty().getValue(), this.dataSource.getValue());
        String oldText = this.getState().text;
        String newText = (String)this.dataSource.getValue();
        if (oldText == null || !oldText.equals(newText)) {
            this.getState().text = newText;
            ++this.getState().serverRequestCounter;
            log.debug("invalidating \"{}\"/\"{}\"", (Object)oldText, (Object)this.getState().text);
            this.markAsDirty();
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ Property access$100(AqlCodeEditor x0) {
        return x0.dataSource;
    }

    static /* synthetic */ void access$200(AqlCodeEditor x0, EventObject x1) {
        x0.fireEvent(x1);
    }
}

