/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.components.medialement;

import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.corpus_tools.annis.gui.components.medialement.MediaElement;
import org.corpus_tools.annis.gui.components.medialement.MediaElementPlayer;
import org.corpus_tools.annis.gui.components.medialement.MediaState;
import org.corpus_tools.annis.gui.media.MediaPlayer;
import org.corpus_tools.annis.gui.visualizers.LoadableVisualizer;

@JavaScript(value={"vaadin://jquery.js", "vaadin://mediaelement/mediaelement-and-player.js", "mediaelement_connector.js"})
@StyleSheet(value={"vaadin://mediaelement/mediaelementplayer.min.css"})
public class MediaElementPlayer
extends AbstractJavaScriptComponent
implements MediaPlayer,
LoadableVisualizer {
    private static final long serialVersionUID = 594724489035276610L;
    private Set<LoadableVisualizer.Callback> callbacks = new HashSet();
    private boolean wasLoaded = false;

    public MediaElementPlayer(MediaElement elementType, String resourceURL, String mimeType) {
        this.getState().setElementType(elementType);
        this.getState().setResourceURL(resourceURL);
        this.getState().setMimeType(mimeType);
        MediaElementPlayer finalThis = this;
        this.addFunction("wasLoaded", (JavaScriptFunction & Serializable)arguments -> {
            this.wasLoaded = true;
            for (LoadableVisualizer.Callback c : this.callbacks) {
                c.visualizerLoaded((LoadableVisualizer)finalThis);
            }
        });
        this.addFunction("cannotPlay", (JavaScriptFunction)new CannotPlayFunction(null));
    }

    public void addOnLoadCallBack(LoadableVisualizer.Callback callback) {
        this.callbacks.add(callback);
    }

    public void clearCallbacks() {
        this.callbacks.clear();
    }

    public final MediaState getState() {
        return (MediaState)super.getState();
    }

    public boolean isLoaded() {
        return this.wasLoaded;
    }

    public void pause() {
        this.callFunction("pause", new Object[0]);
    }

    public void play(double start) {
        start = Math.floor(start);
        this.callFunction("play", new Object[]{start});
    }

    public void play(double start, double end) {
        start = Math.floor(start);
        end = Math.ceil(end);
        this.callFunction("playRange", new Object[]{start, end});
    }
}

