/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controller;

import java.util.List;
import java.util.Map;
import org.corpus_tools.annis.ApiCallback;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.model.CountExtra;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;

public class CountCallback
implements ApiCallback<CountExtra> {
    private final ResultViewPanel panel;
    private final int pageSize;
    private final AnnisUI ui;

    public CountCallback(ResultViewPanel panel, int pageSize, AnnisUI ui) {
        this.panel = panel;
        this.pageSize = pageSize;
        this.ui = ui;
    }

    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        this.ui.access(() -> {
            this.ui.getQueryState().getExecutedTasks().remove(QueryUIState.QueryType.COUNT);
            this.ui.getQueryController().reportServiceException(e, true);
        });
    }

    public void onSuccess(CountExtra result, int statusCode, Map<String, List<String>> responseHeaders) {
        this.ui.access(() -> {
            this.ui.getQueryState().getExecutedTasks().remove(QueryUIState.QueryType.COUNT);
            String documentString = result.getDocumentCount() > 1 ? "documents" : "document";
            String matchesString = result.getMatchCount() > 1 ? "matches" : "match";
            this.ui.getSearchView().getControlPanel().getQueryPanel().setStatus("" + result.getMatchCount() + " " + matchesString + "\nin " + result.getDocumentCount() + " " + documentString);
            if (result.getMatchCount() > 0 && this.panel != null) {
                this.panel.getPaging().setPageSize(this.pageSize, false);
                this.panel.setCount((long)result.getMatchCount().intValue());
            }
            this.ui.getSearchView().getControlPanel().getQueryPanel().setCountIndicatorEnabled(false);
        });
    }

    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
    }

    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
    }
}

