/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controller;

import java.util.concurrent.Future;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.SearchView;
import org.corpus_tools.annis.gui.objects.DisplayedResultQuery;
import org.corpus_tools.annis.gui.objects.PagedResultQuery;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.corpus_tools.annis.gui.paging.PagingCallback;
import org.corpus_tools.annis.gui.resultfetch.ResultFetchJob;
import org.corpus_tools.annis.gui.resultview.ResultViewPanel;

public class SpecificPagingCallback
implements PagingCallback {
    private static final long serialVersionUID = 2454609714467964162L;
    private final ResultViewPanel panel;
    private final SearchView searchView;
    private final AnnisUI ui;
    private final DisplayedResultQuery query;

    public SpecificPagingCallback(AnnisUI ui, SearchView searchView, ResultViewPanel panel, DisplayedResultQuery initialQuery) {
        this.panel = panel;
        this.ui = ui;
        this.searchView = searchView;
        this.query = initialQuery;
    }

    public void switchPage(long offset, int limit) {
        this.query.setOffset(offset);
        this.query.setLimit(limit);
        this.ui.getQueryController().setQuery((Query)this.query);
        this.updateMatches(this.ui.getQueryController().getSearchQuery(), this.panel);
    }

    private void updateMatches(DisplayedResultQuery newQuery, ResultViewPanel panel) {
        if (panel != null) {
            this.searchView.updateFragment(newQuery);
            this.searchView.getControlPanel().getQueryPanel().getPiCount().setVisible(true);
            this.searchView.getControlPanel().getQueryPanel().getPiCount().setEnabled(true);
            Future future = Background.run((Runnable)new ResultFetchJob((PagedResultQuery)newQuery, panel, this.ui));
            this.ui.getQueryState().getExecutedTasks().put(QueryUIState.QueryType.FIND, future);
        }
    }
}

