/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controlpanel;

import com.google.common.collect.Sets;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.GridSortOrderBuilder;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.grid.GridMultiSelect;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.CorpusBrowserPanel;
import org.corpus_tools.annis.gui.CorpusSet;
import org.corpus_tools.annis.gui.ExampleQueriesPanel;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.MetaDataPanel;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.controlpanel.CorpusListPanel;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;

public class CorpusListPanel
extends VerticalLayout {
    private static final long serialVersionUID = -6395601812288089382L;
    private static final Logger log = LoggerFactory.getLogger(CorpusListPanel.class);
    private static final Resource INFO_ICON = VaadinIcons.INFO_CIRCLE;
    private static final Resource DOC_ICON = VaadinIcons.FILE_TEXT_O;
    public static final String ALL_CORPORA = "All";
    private final ExampleQueriesPanel autoGenQueries;
    private Grid<String> tblCorpora;
    private final HorizontalLayout selectionLayout;
    private final ComboBox<String> cbSelection;
    private final TextField txtFilter;
    private final AnnisUI ui;
    private final SerializablePredicate<String> filter;

    public CorpusListPanel(AnnisUI ui, ExampleQueriesPanel autoGenQueries) {
        this.ui = ui;
        this.autoGenQueries = autoGenQueries;
        this.setWidthFull();
        this.setHeightFull();
        this.setMargin(true);
        this.selectionLayout = new HorizontalLayout();
        this.selectionLayout.setWidthFull();
        this.selectionLayout.setHeightUndefined();
        Label lblVisible = new Label("Visible: ");
        lblVisible.setSizeUndefined();
        this.selectionLayout.addComponent((Component)lblVisible);
        this.cbSelection = new ComboBox();
        this.cbSelection.setDescription("Choose corpus selection set");
        this.cbSelection.setWidth("100%");
        this.cbSelection.setHeight("-1px");
        this.cbSelection.addStyleName("small");
        this.cbSelection.setPlaceholder("Select corpus selection set");
        this.cbSelection.setEmptySelectionAllowed(false);
        this.selectionLayout.addComponent((Component)this.cbSelection);
        this.selectionLayout.setExpandRatio((Component)this.cbSelection, 1.0f);
        this.selectionLayout.setSpacing(true);
        this.selectionLayout.setComponentAlignment((Component)this.cbSelection, Alignment.MIDDLE_RIGHT);
        this.selectionLayout.setComponentAlignment((Component)lblVisible, Alignment.MIDDLE_LEFT);
        Button btReload = new Button();
        btReload.addClickListener((Button.ClickListener & Serializable)event -> {
            this.updateCorpusSetList(false, false);
            Notification.show((String)"Reloaded corpus list", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        });
        btReload.setIcon((Resource)VaadinIcons.REFRESH);
        btReload.setDescription("Reload corpus list");
        btReload.addStyleName("icon-only");
        this.selectionLayout.addComponent((Component)btReload);
        this.selectionLayout.setComponentAlignment((Component)btReload, Alignment.MIDDLE_RIGHT);
        this.addComponent((Component)this.selectionLayout);
        this.txtFilter = new TextField();
        this.txtFilter.setPlaceholder("Filter");
        this.txtFilter.setWidth("100%");
        this.txtFilter.setHeight("-1px");
        this.txtFilter.addStyleName("small");
        this.txtFilter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.tblCorpora.getDataProvider().refreshAll());
        this.addComponent((Component)this.txtFilter);
        this.filter = (SerializablePredicate & Serializable)corpus -> {
            String corpusNameFilter;
            String selectedCorpusSetName = (String)this.cbSelection.getValue();
            String string = corpusNameFilter = this.txtFilter.getValue() == null ? "" : this.txtFilter.getValue().trim().toLowerCase();
            if (!corpusNameFilter.isEmpty() && !corpus.toLowerCase().contains(corpusNameFilter)) {
                return false;
            }
            if (selectedCorpusSetName != null && !ALL_CORPORA.equals(selectedCorpusSetName)) {
                CorpusSet selectedCS = null;
                LinkedList corpusSets = new LinkedList();
                if (ui.getInstanceConfig() != null && ui.getInstanceConfig().getCorpusSets() != null) {
                    corpusSets.addAll(ui.getInstanceConfig().getCorpusSets());
                }
                for (CorpusSet cs : corpusSets) {
                    if (!cs.getName().equals(selectedCorpusSetName)) continue;
                    selectedCS = cs;
                }
                return selectedCS == null || selectedCS.getCorpora().contains(corpus);
            }
            return true;
        };
        this.tblCorpora = new Grid();
        this.tblCorpora.setWidthFull();
        this.tblCorpora.setHeightFull();
        this.tblCorpora.setSelectionMode(Grid.SelectionMode.MULTI);
        Grid.Column nameColumn = this.tblCorpora.addColumn((ValueProvider & Serializable)corpus -> corpus);
        nameColumn.setCaption("Corpus");
        nameColumn.setId("corpus");
        nameColumn.setExpandRatio(10);
        Grid.Column infoColumn = this.tblCorpora.addComponentColumn((ValueProvider & Serializable)corpus -> {
            Button l = new Button();
            l.setIcon(INFO_ICON);
            l.setDescription("show metadata and annotations for " + corpus);
            l.addClickListener((Button.ClickListener & Serializable)event -> {
                if (ui.getQueryController() != null) {
                    l.setEnabled(false);
                    this.initCorpusBrowser(corpus, l);
                }
            });
            l.addStyleNames(new String[]{"borderless", "icon-only"});
            return l;
        });
        infoColumn.setExpandRatio(0);
        this.tblCorpora.addComponentColumn((ValueProvider & Serializable)corpus -> {
            Button l = new Button();
            l.setIcon(DOC_ICON);
            l.setDescription("opens the document browser for " + corpus);
            l.addClickListener((Button.ClickListener & Serializable)event -> ui.getSearchView().getDocBrowserController().openDocBrowser(corpus));
            l.addStyleNames(new String[]{"borderless", "icon-only"});
            return l;
        });
        infoColumn.setExpandRatio(0);
        this.tblCorpora.setSortOrder(new GridSortOrderBuilder().thenAsc(nameColumn).build());
        this.addComponent((Component)this.tblCorpora);
        this.setExpandRatio((Component)this.tblCorpora, 1.0f);
    }

    public void attach() {
        super.attach();
        CorporaApi api = new CorporaApi(Helper.getClient((UI)this.ui));
        try {
            List corpora = api.listCorpora();
            ListDataProvider availableCorpora = new ListDataProvider((Collection)corpora);
            availableCorpora.setFilter(this.filter);
            this.tblCorpora.setDataProvider((DataProvider)availableCorpora);
            LinkedList corpusSets = new LinkedList();
            if (this.ui.getInstanceConfig() != null && this.ui.getInstanceConfig().getCorpusSets() != null) {
                corpusSets.addAll(this.ui.getInstanceConfig().getCorpusSets());
            }
            if (corpora.isEmpty() && Helper.getUser((SecurityContext)this.ui.getSecurityContext()).isPresent()) {
                Notification.show((String)"No corpora found. Please login (use button at upper right corner) to see more corpora.", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
            }
        }
        catch (ApiException e) {
            ExceptionDialog.show((Throwable)e, (String)"Coould not get corpus list", (UI)this.getUI());
        }
        Binder binder = new Binder();
        GridMultiSelect corpusSelection = this.tblCorpora.asMultiSelect();
        binder.forField((HasValue)corpusSelection).bind(QueryUIState::getSelectedCorpora, QueryUIState::setSelectedCorpora);
        binder.setBean((Object)this.ui.getQueryState());
        binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            HashSet corpora = new HashSet(this.ui.getQueryState().getSelectedCorpora());
            this.autoGenQueries.setSelectedCorpusInBackground(corpora);
            this.ui.getQueryController().corpusSelectionChangedInBackground();
        });
        IDGenerator.assignIDForFields((HasComponents)this, (Component[])new Component[]{this.tblCorpora, this.txtFilter});
    }

    public Grid<String> getTblCorpora() {
        return this.tblCorpora;
    }

    public void initCorpusBrowser(String topLevelCorpusName, Button l) {
        MetaDataPanel meta = new MetaDataPanel(topLevelCorpusName);
        CorpusBrowserPanel browse = new CorpusBrowserPanel(topLevelCorpusName, this.ui.getQueryController());
        GridLayout infoLayout = new GridLayout(2, 2);
        infoLayout.setSizeFull();
        String corpusURL = Helper.generateCorpusLink((Set)Sets.newHashSet((Object[])new String[]{topLevelCorpusName}));
        Label lblLink = new Label("Link to corpus: <a href=\"" + corpusURL + "\">" + corpusURL + "</a>", ContentMode.HTML);
        lblLink.setHeight("-1px");
        lblLink.setWidth("-1px");
        infoLayout.addComponent((Component)meta, 0, 0);
        infoLayout.addComponent((Component)browse, 1, 0);
        infoLayout.addComponent((Component)lblLink, 0, 1, 1, 1);
        infoLayout.setRowExpandRatio(0, 1.0f);
        infoLayout.setColumnExpandRatio(0, 0.5f);
        infoLayout.setColumnExpandRatio(1, 0.5f);
        infoLayout.setComponentAlignment((Component)lblLink, Alignment.MIDDLE_CENTER);
        Window window = new Window("Corpus information for " + topLevelCorpusName, (Component)infoLayout);
        window.setWidth(70.0f, Sizeable.Unit.EM);
        window.setHeight(45.0f, Sizeable.Unit.EM);
        window.setResizable(true);
        window.setModal(false);
        window.setResizeLazy(true);
        window.addCloseListener((Window.CloseListener & Serializable)e -> l.setEnabled(true));
        UI.getCurrent().addWindow(window);
        window.center();
    }

    public void scrollToSelectedCorpus() {
        Set corpora = this.ui.getQueryState().getSelectedCorpora();
        if (this.tblCorpora != null && !corpora.isEmpty()) {
            String firstCorpusName = (String)corpora.iterator().next();
            this.tblCorpora.select((Object)firstCorpusName);
        }
    }

    public void setCorpusSet(String corpusSet) {
        this.cbSelection.setValue((Object)corpusSet);
    }

    public void selectedCorpusChanged(boolean scrollToSelected) {
        this.tblCorpora.asMultiSelect().setValue(this.ui.getQueryController().getState().getSelectedCorpora());
        if (scrollToSelected) {
            this.scrollToSelectedCorpus();
        }
    }

    public void updateCorpusSetList(boolean scrollToSelected) {
        this.updateCorpusSetList(false, scrollToSelected);
    }

    private void updateCorpusSetList(boolean showLoginMessage, boolean scrollToSelected) {
        if (this.ui != null) {
            this.ui.clearCorpusConfigCache();
        }
        CorpusListUpdater updater = new CorpusListUpdater(this, showLoginMessage, scrollToSelected);
        Background.run((Runnable)updater);
    }

    static /* synthetic */ AnnisUI access$000(CorpusListPanel x0) {
        return x0.ui;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ SerializablePredicate access$200(CorpusListPanel x0) {
        return x0.filter;
    }

    static /* synthetic */ Grid access$300(CorpusListPanel x0) {
        return x0.tblCorpora;
    }
}

