/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.controlpanel;

import com.vaadin.jsclipboard.JSClipboard;
import com.vaadin.server.ClassResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.ListSelect;
import java.io.Serializable;
import java.util.List;
import org.corpus_tools.annis.api.model.BadRequestError;
import org.corpus_tools.annis.api.model.QueryAttributeDescription;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.HistoryPanel;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.components.VirtualKeyboardCodeEditor;
import org.corpus_tools.annis.gui.components.codemirror.AqlCodeEditor;
import org.corpus_tools.annis.gui.controlpanel.QueryPanel;
import org.corpus_tools.annis.gui.frequency.FrequencyQueryPanel;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryUIState;
import org.vaadin.hene.popupbutton.PopupButton;

public class QueryPanel
extends GridLayout
implements Property.ValueChangeListener {
    private static final long serialVersionUID = 8843266533468321213L;
    public static final int MAX_HISTORY_MENU_ITEMS = 5;
    private AqlCodeEditor txtQuery;
    private TextArea txtStatus;
    private Button btShowResult;
    private PopupButton btHistory;
    private final ListSelect lstHistory;
    private final QueryUIState state;
    private ProgressBar piCount;
    private String lastPublicStatus;
    private Window historyWindow;
    private PopupButton btMoreActions;
    private FrequencyQueryPanel frequencyPanel;
    private final AnnisUI ui;
    private final BeanItemContainer<Query> historyContainer = new BeanItemContainer(Query.class);
    private Button btShowQueryBuilder = new Button("Query<br />Builder");

    public QueryPanel(AnnisUI ui) {
        super(4, 5);
        VirtualKeyboardCodeEditor virtualKeyboard;
        this.ui = ui;
        this.lastPublicStatus = "Welcome to ANNIS! A tutorial is available on the right side.";
        this.state = ui.getQueryState();
        this.setSpacing(true);
        this.setMargin(false);
        this.setRowExpandRatio(0, 1.0f);
        this.setColumnExpandRatio(0, 0.0f);
        this.setColumnExpandRatio(1, 0.1f);
        this.setColumnExpandRatio(2, 0.0f);
        this.setColumnExpandRatio(3, 0.0f);
        this.txtQuery = new AqlCodeEditor();
        this.txtQuery.setPropertyDataSource((Property)this.state.getAql());
        this.txtQuery.setInputPrompt("Please enter AQL query");
        this.txtQuery.addStyleName("query");
        if (ui.getInstanceFont() == null) {
            this.txtQuery.addStyleName("default-query-font");
            this.txtQuery.setTextareaStyle("default-query-font");
        } else {
            this.txtQuery.addStyleName("corpus-font");
            this.txtQuery.setTextareaStyle("corpus-font");
        }
        this.txtQuery.addStyleName("keyboardInput");
        this.txtQuery.setWidth("100%");
        this.txtQuery.setHeight(15.0f, Sizeable.Unit.EM);
        this.txtQuery.setTextChangeTimeout(500);
        if (ui.getInstanceConfig().getKeyboardLayout() == null) {
            virtualKeyboard = null;
        } else {
            virtualKeyboard = new VirtualKeyboardCodeEditor();
            virtualKeyboard.setKeyboardLayout(ui.getInstanceConfig().getKeyboardLayout());
            virtualKeyboard.extend(this.txtQuery);
        }
        this.txtStatus = new TextArea();
        this.txtStatus.setValue(this.lastPublicStatus);
        this.txtStatus.setWidth("100%");
        this.txtStatus.setHeight(4.0f, Sizeable.Unit.EM);
        this.txtStatus.addStyleName("border-layout");
        this.txtStatus.setReadOnly(true);
        this.piCount = new ProgressBar();
        this.piCount.setIndeterminate(true);
        this.piCount.setEnabled(false);
        this.piCount.setVisible(false);
        this.btShowResult = new Button("Search");
        this.btShowResult.setIcon((Resource)FontAwesome.SEARCH);
        this.btShowResult.setWidth("100%");
        this.btShowResult.addClickListener((Button.ClickListener)new ShowResultClickListener(this));
        this.btShowResult.setDescription("<strong>Show Result</strong><br />Ctrl + Enter", ContentMode.HTML);
        this.btShowResult.setClickShortcut(13, new int[]{17});
        this.btShowResult.setDisableOnClick(true);
        VerticalLayout historyListLayout = new VerticalLayout();
        historyListLayout.setSizeUndefined();
        this.lstHistory = new ListSelect();
        this.lstHistory.setWidth("200px");
        this.lstHistory.setNullSelectionAllowed(false);
        this.lstHistory.setValue(null);
        this.lstHistory.addValueChangeListener((Property.ValueChangeListener)this);
        this.lstHistory.setImmediate(true);
        this.lstHistory.setContainerDataSource((Container)this.historyContainer);
        this.lstHistory.setItemCaptionPropertyId((Object)"query");
        this.lstHistory.addStyleName("corpus-font");
        Button btShowMoreHistory = new Button("Show more details", (Button.ClickListener & Serializable)event -> {
            if (this.historyWindow == null) {
                this.historyWindow = new Window("History");
                this.historyWindow.setModal(false);
                this.historyWindow.setWidth("400px");
                this.historyWindow.setHeight("250px");
            }
            this.historyWindow.setContent((Component)new HistoryPanel(this.state.getHistory(), ui.getQueryController()));
            if (UI.getCurrent().getWindows().contains(this.historyWindow)) {
                this.historyWindow.bringToFront();
            } else {
                UI.getCurrent().addWindow(this.historyWindow);
            }
        });
        btShowMoreHistory.setWidth("100%");
        historyListLayout.addComponent((Component)this.lstHistory);
        historyListLayout.addComponent((Component)btShowMoreHistory);
        historyListLayout.setExpandRatio((Component)this.lstHistory, 1.0f);
        historyListLayout.setExpandRatio((Component)btShowMoreHistory, 0.0f);
        this.btHistory = new PopupButton("History");
        this.btHistory.setContent((Component)historyListLayout);
        this.btHistory.setDescription("<strong>Show History</strong><br />Either use the short overview (arrow down) or click on the button for the extended view.", ContentMode.HTML);
        Button btShowKeyboard = null;
        if (virtualKeyboard != null) {
            btShowKeyboard = new Button();
            btShowKeyboard.setWidth("100%");
            btShowKeyboard.setDescription("Click to show a virtual keyboard");
            btShowKeyboard.addStyleName("icon-only");
            btShowKeyboard.addStyleName("small");
            btShowKeyboard.setIcon((Resource)new ClassResource(VirtualKeyboardCodeEditor.class, "keyboard.png"));
            btShowKeyboard.addClickListener((Button.ClickListener)new ShowKeyboardClickListener(virtualKeyboard));
        }
        JSClipboard clipboard = new JSClipboard();
        Button btCopy = new Button("");
        btCopy.setWidth("100%");
        btCopy.setDescription("Copy query to clipboard");
        btCopy.addStyleName("icon-only");
        btCopy.addStyleName("small");
        btCopy.setIcon((Resource)FontAwesome.COPY);
        clipboard.apply(btCopy, (Component)this.txtQuery);
        clipboard.setText((String)this.state.getAql().getValue());
        this.state.getAql().addValueChangeListener((Property.ValueChangeListener & Serializable)event -> clipboard.setText(event.getProperty().getValue().toString()));
        clipboard.addSuccessListener((JSClipboard.SuccessListener & Serializable)() -> Notification.show((String)"Copied AQL to clipboard"));
        this.btShowQueryBuilder.setHtmlContentAllowed(true);
        this.btShowQueryBuilder.addStyleName("small");
        this.btShowQueryBuilder.addStyleName("icon-align-top");
        this.btShowQueryBuilder.setIcon((Resource)new ThemeResource("images/tango-icons/32x32/document-properties.png"));
        this.btShowQueryBuilder.addClickListener((Button.ClickListener)new ShowQueryBuilderClickListener(ui));
        VerticalLayout moreActionsLayout = new VerticalLayout();
        moreActionsLayout.setWidth("250px");
        this.btMoreActions = new PopupButton("More");
        this.btMoreActions.setContent((Component)moreActionsLayout);
        Button btShowExport = new Button("Export", (Button.ClickListener)new ShowExportClickListener(this, ui));
        btShowExport.setIcon((Resource)FontAwesome.DOWNLOAD);
        btShowExport.setWidth("100%");
        moreActionsLayout.addComponent((Component)btShowExport);
        Button btShowFrequency = new Button("Frequency Analysis", (Button.ClickListener)new ShowFrequencyClickListener(this, ui));
        btShowFrequency.setIcon((Resource)FontAwesome.BAR_CHART_O);
        btShowFrequency.setWidth("100%");
        moreActionsLayout.addComponent((Component)btShowFrequency);
        this.addComponent((Component)this.txtQuery, 0, 0, 2, 2);
        this.addComponent((Component)this.txtStatus, 0, 4, 2, 4);
        this.addComponent((Component)this.btShowResult, 0, 3);
        this.addComponent((Component)this.btMoreActions, 1, 3);
        this.addComponent((Component)this.btHistory, 2, 3);
        this.addComponent((Component)this.piCount, 3, 4);
        this.addComponent((Component)this.btShowQueryBuilder, 3, 0);
        if (btShowKeyboard != null) {
            this.addComponent((Component)btShowKeyboard, 3, 1);
            this.addComponent((Component)btCopy, 3, 2);
        } else {
            this.addComponent((Component)btCopy, 3, 1);
        }
        this.setRowExpandRatio(0, 0.0f);
        this.setRowExpandRatio(1, 0.0f);
        this.setRowExpandRatio(2, 1.0f);
        this.setColumnExpandRatio(0, 1.0f);
        this.setColumnExpandRatio(1, 0.0f);
        this.setColumnExpandRatio(2, 0.0f);
        this.setColumnExpandRatio(3, 0.0f);
    }

    public void attach() {
        super.attach();
        IDGenerator.assignIDForFields((HasComponents)this, (Component[])new Component[]{this.btShowResult, this.btMoreActions, this.btShowQueryBuilder});
    }

    public String getLastPublicStatus() {
        return this.lastPublicStatus;
    }

    public ProgressBar getPiCount() {
        return this.piCount;
    }

    public String getQuery() {
        if (this.txtQuery != null) {
            return this.txtQuery.getValue();
        }
        return "";
    }

    public void notifyFrequencyTabClose() {
        this.txtQuery.removeTextChangeListener((FieldEvents.TextChangeListener)this.frequencyPanel);
        this.frequencyPanel = null;
    }

    public void setCountIndicatorEnabled(boolean enabled) {
        if (this.piCount != null && this.btShowResult != null && this.txtStatus != null) {
            if (enabled && !this.piCount.isVisible()) {
                this.piCount.setVisible(true);
                this.piCount.setEnabled(true);
            }
            this.btShowResult.setEnabled(!enabled);
        }
    }

    public void setError(BadRequestError error) {
        this.txtQuery.setError(error);
    }

    public void setNodes(List<QueryAttributeDescription> nodes) {
        this.txtQuery.setNodes(nodes);
    }

    public void setQuery(String query) {
        if (this.txtQuery != null) {
            this.txtQuery.setValue(query);
        }
    }

    public void setStatus(String status) {
        if (this.txtStatus != null) {
            this.txtStatus.setReadOnly(false);
            this.txtStatus.setValue(status);
            this.lastPublicStatus = status;
            this.txtStatus.setReadOnly(true);
        }
    }

    public void setStatus(String status, String resultStatus) {
        if (this.txtStatus != null) {
            this.txtStatus.setReadOnly(false);
            this.txtStatus.setValue(status + resultStatus);
            this.lastPublicStatus = status;
            this.txtStatus.setReadOnly(true);
        }
    }

    public void updateShortHistory() {
        this.historyContainer.removeAllItems();
        int counter = 0;
        for (Query q : this.state.getHistory().getItemIds()) {
            if (counter >= 5) break;
            this.historyContainer.addBean((Object)q);
            ++counter;
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        this.btHistory.setPopupVisible(false);
        Object q = event.getProperty().getValue();
        if (this.ui != null && this.ui.getQueryController() != null && q instanceof Query) {
            this.ui.getQueryController().setQuery((Query)q);
        }
    }

    static /* synthetic */ PopupButton access$000(QueryPanel x0) {
        return x0.btMoreActions;
    }

    static /* synthetic */ FrequencyQueryPanel access$100(QueryPanel x0) {
        return x0.frequencyPanel;
    }

    static /* synthetic */ FrequencyQueryPanel access$102(QueryPanel x0, FrequencyQueryPanel x1) {
        x0.frequencyPanel = x1;
        return x0.frequencyPanel;
    }

    static /* synthetic */ QueryUIState access$200(QueryPanel x0) {
        return x0.state;
    }

    static /* synthetic */ AqlCodeEditor access$300(QueryPanel x0) {
        return x0.txtQuery;
    }

    static /* synthetic */ AnnisUI access$500(QueryPanel x0) {
        return x0.ui;
    }
}

