/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.converter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.vaadin.v7.data.util.converter.Converter;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import org.corpus_tools.annis.gui.CaseSensitiveOrder;

public class CommaSeperatedStringConverterSet
implements Converter<String, Collection> {
    private static final long serialVersionUID = -2875078513051528093L;
    private static final Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Joiner joiner = Joiner.on((String)", ");

    public Collection convertToModel(String value, Class<? extends Collection> targetType, Locale locale) throws Converter.ConversionException {
        TreeSet<String> result = new TreeSet<String>(CaseSensitiveOrder.INSTANCE);
        for (String s : splitter.split((CharSequence)value)) {
            result.add(s);
        }
        return result;
    }

    public String convertToPresentation(Collection value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        return joiner.join((Iterable)value);
    }

    public Class<Collection> getModelType() {
        return Collection.class;
    }

    public Class<String> getPresentationType() {
        return String.class;
    }
}

