/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.converter;

import com.vaadin.v7.data.util.converter.Converter;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import org.corpus_tools.annis.gui.CaseSensitiveOrder;

public class TreeSetConverter
implements Converter<Object, TreeSet> {
    private static final long serialVersionUID = 843093641164263522L;

    public TreeSet convertToModel(Object value, Class<? extends TreeSet> targetType, Locale locale) throws Converter.ConversionException {
        TreeSet<String> result = new TreeSet<String>(CaseSensitiveOrder.INSTANCE);
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (!(item instanceof String)) continue;
                result.add((String)item);
            }
            if (result.size() != ((Collection)value).size()) {
                throw new IllegalStateException("Collection which was used with the TreeSetConverter had duplicate entries.");
            }
        } else if (value instanceof String) {
            result.add((String)value);
        } else {
            throw new IllegalStateException("Value used in the TreeSetConverter is neither a Collection of Strings nor a String");
        }
        return result;
    }

    public Object convertToPresentation(TreeSet value, Class<? extends Object> targetType, Locale locale) throws Converter.ConversionException {
        return value;
    }

    public Class<TreeSet> getModelType() {
        return TreeSet.class;
    }

    public Class<Object> getPresentationType() {
        return Object.class;
    }
}

