/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.docbrowser;

import com.google.common.base.Joiner;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnotationComponentType;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.CommonUI;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserController;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserPanel;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.objects.RawTextWrapper;
import org.corpus_tools.annis.gui.visualizers.VisualizerInput;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBrowserController
implements Serializable {
    private static final long serialVersionUID = 7035834674160143771L;
    private static final Logger log = LoggerFactory.getLogger(DocBrowserController.class);
    private static final Resource EYE_ICON = VaadinIcons.EYE;
    private static final Resource DOC_ICON = VaadinIcons.FILE_TEXT_O;
    private final AnnisUI ui;
    private final Map<String, Component> initedDocBrowsers;
    private final Map<String, Component> initiatedVis;
    private final Map<String, Panel> visibleVisHolder;

    public static VisualizerInput createInput(String corpus, List<String> docPath, VisualizerRule config, List<String> nodeAnnoFilter, boolean useRawText, CommonUI ui) {
        VisualizerInput input = new VisualizerInput();
        input.setMappings(config.getMappings());
        input.setNamespace(config.getLayer());
        input.setUI(ui);
        input.setContextPath(ui.getServletContext().getContextPath());
        try {
            CorporaApi api = new CorporaApi(Helper.getClient((UI)ui));
            SaltProject p = SaltFactory.createSaltProject();
            SCorpusGraph cg = p.createCorpusGraph();
            URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join(docPath)));
            SDocument doc = cg.createDocument(docURI);
            String aql = Helper.buildDocumentQuery(docPath, nodeAnnoFilter, (boolean)useRawText);
            File graphML = api.subgraphForQuery(docPath.get(0), aql, QueryLanguage.AQL, (AnnotationComponentType)(useRawText ? AnnotationComponentType.ORDERING : null));
            SDocumentGraph docGraph = DocumentGraphMapper.map((File)graphML);
            doc.setDocumentGraph(docGraph);
            input.setResult(doc);
            if (useRawText) {
                input.setRawText(new RawTextWrapper(docGraph));
            }
        }
        catch (ApiException e) {
            log.error("General remote service exception", (Throwable)e);
        }
        catch (IOException | XMLStreamException ex) {
            log.error("Could not map GraphML to Salt", (Throwable)ex);
            ui.access(() -> ExceptionDialog.show((Throwable)ex, (String)"Could not map GraphML to Salt", (UI)ui));
        }
        return input;
    }

    public DocBrowserController(AnnisUI ui) {
        this.ui = ui;
        this.initedDocBrowsers = new HashMap();
        this.initiatedVis = new HashMap();
        this.visibleVisHolder = new HashMap();
    }

    public void openDocBrowser(String corpus) {
        this.initedDocBrowsers.computeIfAbsent(corpus, k -> DocBrowserPanel.initDocBrowserPanel((AnnisUI)this.ui, (String)k));
        TabSheet.Tab tab = this.ui.getSearchView().getTabSheet().addTab((Component)this.initedDocBrowsers.get(corpus), corpus);
        tab.setIcon(DOC_ICON);
        tab.setClosable(true);
        this.ui.getSearchView().getTabSheet().setSelectedTab(tab);
    }

    public void openDocVis(String corpus, String docId, VisualizerRule visConfig, Button btn) {
        List path = Helper.getCorpusPath((String)docId);
        String canonicalTitle = Joiner.on((String)" > ").join((Iterable)path) + " - Visualizer: " + visConfig.getDisplayName();
        String tabCaption = StringUtils.substring((String)canonicalTitle, (int)0, (int)15) + "...";
        if (this.visibleVisHolder.containsKey(canonicalTitle)) {
            Panel visHolder = (Panel)this.visibleVisHolder.get(canonicalTitle);
            this.ui.getSearchView().getTabSheet().setSelectedTab((Component)visHolder);
            return;
        }
        Panel visHolder = new Panel();
        visHolder.setSizeFull();
        visHolder.addDetachListener((ClientConnector.DetachListener & Serializable)event -> {
            Panel cfr_ignored_0 = (Panel)this.visibleVisHolder.remove(canonicalTitle);
        });
        ProgressBar progressBar = new ProgressBar(1.0f);
        progressBar.setIndeterminate(true);
        progressBar.setSizeFull();
        VerticalLayout layoutProgress = new VerticalLayout(new Component[]{progressBar});
        layoutProgress.setSizeFull();
        layoutProgress.setComponentAlignment((Component)progressBar, Alignment.MIDDLE_CENTER);
        visHolder.setContent((Component)layoutProgress);
        TabSheet.Tab visTab = this.ui.getSearchView().getTabSheet().addTab((Component)visHolder, tabCaption);
        visTab.setDescription(canonicalTitle);
        visTab.setIcon(EYE_ICON);
        visTab.setClosable(true);
        this.ui.getSearchView().getTabSheet().setSelectedTab(visTab);
        this.visibleVisHolder.put(canonicalTitle, visHolder);
        Background.run((Runnable)new DocVisualizerFetcher(this, corpus, path, canonicalTitle, visConfig.getVisType(), visHolder, visConfig, btn));
    }

    static /* synthetic */ Map access$000(DocBrowserController x0) {
        return x0.initiatedVis;
    }

    static /* synthetic */ AnnisUI access$100(DocBrowserController x0) {
        return x0.ui;
    }
}

