/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.docbrowser;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.AnnisUI;
import org.corpus_tools.annis.gui.Background;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.components.ExceptionDialog;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserPanel;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserTable;
import org.corpus_tools.annis.gui.objects.DocumentBrowserConfig;
import org.corpus_tools.annis.gui.objects.Visualizer;

public class DocBrowserPanel
extends Panel {
    private static final long serialVersionUID = -1785316182826648719L;
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    private final AnnisUI ui;
    private VerticalLayout layout;
    private String corpus;
    private DocBrowserTable table;
    final ProgressBar progress;

    public static DocBrowserPanel initDocBrowserPanel(AnnisUI ui, String corpus) {
        return new DocBrowserPanel(ui, corpus);
    }

    private DocBrowserPanel(AnnisUI ui, String corpus) {
        this.ui = ui;
        this.corpus = corpus;
        this.layout = new VerticalLayout();
        this.setContent((Component)this.layout);
        this.layout.setSizeFull();
        this.layout.addStyleName("borderless");
        this.setSizeFull();
        this.progress = new ProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setSizeFull();
    }

    public void attach() {
        super.attach();
        if (this.table == null) {
            this.layout.addComponent((Component)this.progress);
            this.layout.setComponentAlignment((Component)this.progress, Alignment.MIDDLE_CENTER);
            Background.run((Runnable)new LoadingDocs(this, null));
        }
    }

    public String getCorpus() {
        return this.corpus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentBrowserConfig getDocBrowserConfig() {
        DocumentBrowserConfig defaultConfig = new DocumentBrowserConfig();
        VisualizerRule textVis = new VisualizerRule();
        textVis.setDisplayName("full text");
        textVis.setVisType("raw_text");
        defaultConfig.setVisualizers(Arrays.asList(new Visualizer(textVis)));
        CorporaApi api = new CorporaApi(Helper.getClient((UI)this.ui));
        try {
            File result = api.getFile(this.getCorpus(), urlPathEscape.escape(this.getCorpus()) + "/document_browser.json");
            try (FileInputStream is = new FileInputStream(result);){
                DocumentBrowserConfig config;
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                DocumentBrowserConfig documentBrowserConfig = config = (DocumentBrowserConfig)mapper.readValue((InputStream)is, DocumentBrowserConfig.class);
                return documentBrowserConfig;
            }
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) return defaultConfig;
            ExceptionDialog.show((Throwable)ex, (String)"Could not get the document browser configuration file from the backend.", (UI)this.ui);
            return defaultConfig;
        }
        catch (IOException ex) {
            ExceptionDialog.show((Throwable)ex, (String)"Could not get the document browser configuration file from the backend.", (UI)this.ui);
        }
        return defaultConfig;
    }

    public void openVis(String docId, VisualizerRule config, Button btn) {
        this.ui.getSearchView().getDocBrowserController().openDocVis(this.corpus, docId, config, btn);
    }

    static /* synthetic */ AnnisUI access$000(DocBrowserPanel x0) {
        return x0.ui;
    }

    static /* synthetic */ String access$100(DocBrowserPanel x0) {
        return x0.corpus;
    }

    static /* synthetic */ DocBrowserTable access$202(DocBrowserPanel x0, DocBrowserTable x1) {
        x0.table = x1;
        return x0.table;
    }

    static /* synthetic */ VerticalLayout access$300(DocBrowserPanel x0) {
        return x0.layout;
    }

    static /* synthetic */ DocBrowserTable access$200(DocBrowserPanel x0) {
        return x0.table;
    }
}

