/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.docbrowser;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.annis.api.model.VisualizerRule;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserPanel;
import org.corpus_tools.annis.gui.docbrowser.DocBrowserTable;
import org.corpus_tools.annis.gui.objects.DocumentBrowserConfig;
import org.corpus_tools.annis.gui.objects.MetaDataColumn;
import org.corpus_tools.annis.gui.objects.OrderBy;
import org.corpus_tools.annis.gui.objects.Visualizer;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBrowserTable
extends Table {
    private static final long serialVersionUID = -4380116858337669345L;
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    private static final Resource INFO_ICON = FontAwesome.INFO_CIRCLE;
    public static final String PROP_DOC_NAME = "document name";
    private Logger log = LoggerFactory.getLogger(DocBrowserTable.class);
    private final DocBrowserPanel docBrowserPanel;
    private DocumentBrowserConfig docVisualizerConfig;
    private final Map<String, Map<String, Set<SMetaAnnotation>>> docMetaDataCache;
    private IndexedContainer container;

    public static DocBrowserTable getDocBrowserTable(DocBrowserPanel parent) {
        DocBrowserTable docBrowserTable = new DocBrowserTable(parent);
        return docBrowserTable;
    }

    private DocBrowserTable(DocBrowserPanel parent) {
        this.docBrowserPanel = parent;
        this.setSizeFull();
        this.addStyleName("striped");
        this.docMetaDataCache = new HashMap();
        this.addStyleName("docvis-table");
        this.docVisualizerConfig = this.docBrowserPanel.getDocBrowserConfig();
    }

    private String generateCell(List<String> path, MetaDataCol metaDatum) {
        Set metaData = new LinkedHashSet();
        if (path != null && !path.isEmpty()) {
            metaData = this.getDocMetaData(path.get(path.size() - 1));
        }
        for (SMetaAnnotation a : metaData) {
            if (metaDatum.namespace != null && metaDatum.namespace.equals(a.getNamespace()) && metaDatum.name.equals(a.getName())) {
                return a.getValue_STEXT();
            }
            if (metaDatum.namespace != null || a.getNamespace() != null || !metaDatum.name.equals(a.getName())) continue;
            return a.getValue_STEXT();
        }
        return "n/a";
    }

    public Button generateInfoButtonCell(String docName) {
        Button btn = new Button();
        btn.setStyleName("borderless");
        btn.setIcon(INFO_ICON);
        btn.addClickListener((Button.ClickListener & Serializable)event -> {
            Set annos = this.getDocMetaData(docName);
            BeanItemContainer metaContainer = new BeanItemContainer(SMetaAnnotation.class);
            if (annos != null) {
                metaContainer.addAll((Collection)annos);
            }
            metaContainer.sort(new Object[]{"namespace", "name"}, new boolean[]{true, true});
            Table metaTable = new Table();
            metaTable.setContainerDataSource((Container)metaContainer);
            metaTable.addGeneratedColumn((Object)"genname", (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> {
                SMetaAnnotation anno = (SMetaAnnotation)metaContainer.getItem(itemId).getBean();
                String qName = anno.getName();
                if (anno.getNamespace() != null) {
                    qName = anno.getNamespace() + ":" + qName;
                }
                Label l = new Label(qName);
                l.setSizeUndefined();
                return l;
            });
            metaTable.addGeneratedColumn((Object)"genvalue", (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> {
                SMetaAnnotation anno = (SMetaAnnotation)metaContainer.getItem(itemId).getBean();
                Label l = new Label(anno.getValue_STEXT(), ContentMode.HTML);
                return l;
            });
            metaTable.setVisibleColumns(new Object[]{"genname", "genvalue"});
            metaTable.setColumnHeaders(new String[]{"Name", "Value"});
            metaTable.setSizeFull();
            metaTable.setColumnWidth((Object)"genname", -1);
            metaTable.setColumnExpandRatio((Object)"genvalue", 1.0f);
            metaTable.addStyleName("striped");
            Window metaWin = new Window();
            metaWin.setContent((Component)metaTable);
            metaWin.setCaption("metadata doc " + docName);
            metaWin.center();
            metaWin.setWidth(400.0f, Sizeable.Unit.PIXELS);
            metaWin.setHeight(400.0f, Sizeable.Unit.PIXELS);
            this.docBrowserPanel.getUI().addWindow(metaWin);
        });
        return btn;
    }

    private MetaColumns generateMetaColumns() {
        MetaColumns metaColumns = new MetaColumns();
        if (this.docVisualizerConfig == null) {
            return metaColumns;
        }
        if (this.docVisualizerConfig.getMetaDataColumns() != null) {
            MetaDataColumn[] metaDataCols;
            for (MetaDataColumn metaDataColumn : metaDataCols = this.docVisualizerConfig.getMetaDataColumns()) {
                metaColumns.visibleColumns.add(new MetaDataCol(metaDataColumn.getNamespace(), metaDataColumn.getName()));
            }
        }
        if (this.docVisualizerConfig.getOrderBy() != null) {
            OrderBy[] orderBys = this.docVisualizerConfig.getOrderBy();
            for (MetaDataColumn metaDataColumn : orderBys) {
                metaColumns.sortColumns.add(new MetaDataCol(metaDataColumn.getNamespace(), metaDataColumn.getName(), metaDataColumn.isAscending()));
            }
        }
        return metaColumns;
    }

    private Panel generateVisualizerLinks(String docId) {
        List visualizers;
        Panel p = new Panel();
        VerticalLayout l = new VerticalLayout();
        p.addStyleName("borderless");
        if (this.docVisualizerConfig != null && (visualizers = this.docVisualizerConfig.getVisualizers()) != null) {
            for (Visualizer rawVis : visualizers) {
                VisualizerRule visualizer = rawVis.toVisualizerRule();
                Button openVis = new Button(visualizer.getDisplayName());
                openVis.setDescription("open visualizer for document");
                openVis.addClickListener((Button.ClickListener)new OpenVisualizerWindow(this, docId, visualizer, openVis));
                openVis.setStyleName("link");
                openVis.setDisableOnClick(true);
                l.addComponent((Component)openVis);
            }
        }
        p.setContent((Component)l);
        return p;
    }

    private Set<SMetaAnnotation> getDocMetaData(String document) {
        Set<SMetaAnnotation> metaAnnos;
        HashMap<String, Set<SMetaAnnotation>> metaDataMap = (HashMap<String, Set<SMetaAnnotation>>)this.docMetaDataCache.get(this.docBrowserPanel.getCorpus());
        if (metaDataMap == null) {
            metaDataMap = new HashMap<String, Set<SMetaAnnotation>>();
            this.docMetaDataCache.put(this.docBrowserPanel.getCorpus(), metaDataMap);
        }
        if ((metaAnnos = (Set<SMetaAnnotation>)metaDataMap.get(document)) != null) {
            return metaAnnos;
        }
        List annos = Helper.getMetaDataDoc((String)this.docBrowserPanel.getCorpus(), (String)document, (UI)UI.getCurrent());
        metaAnnos = Collections.unmodifiableSet(new LinkedHashSet(annos));
        metaDataMap.put(document, metaAnnos);
        return metaAnnos;
    }

    public void setContainerFilter(Container.Filter filter) {
        this.container.removeAllContainerFilters();
        this.container.addContainerFilter(filter);
    }

    void setDocuments(List<SDocument> docs) {
        this.container = new IndexedContainer();
        this.container.addContainerProperty((Object)PROP_DOC_NAME, String.class, (Object)"n/a");
        MetaColumns metaCols = this.generateMetaColumns();
        for (MetaDataCol metaDatum : metaCols.visibleColumns) {
            this.container.addContainerProperty((Object)metaDatum.getColName(), String.class, (Object)"n/a");
        }
        for (MetaDataCol metaDatum : metaCols.sortColumns) {
            this.container.addContainerProperty((Object)metaDatum.getColName(), String.class, (Object)"n/a");
        }
        this.container.addContainerProperty((Object)"corpus path", String.class, (Object)"n/a");
        this.container.addContainerProperty((Object)"info", Button.class, null);
        this.container.addContainerProperty((Object)"visualizer", Panel.class, null);
        for (SDocument d : docs) {
            String value;
            String path;
            Item row;
            String doc = d.getName();
            String docId = d.getId();
            LinkedList pathList = Helper.getCorpusPath((String)d.getId());
            if (pathList == null) {
                pathList = new LinkedList();
            }
            if ((row = this.container.addItem((Object)(path = StringUtils.join((Iterable)pathList, (String)" > ")))) == null) continue;
            row.getItemProperty((Object)PROP_DOC_NAME).setValue((Object)doc);
            for (MetaDataCol metaDataCol : metaCols.visibleColumns) {
                value = this.generateCell(pathList, metaDataCol);
                row.getItemProperty((Object)metaDataCol.getColName()).setValue((Object)value);
            }
            for (MetaDataCol metaDataCol : metaCols.sortColumns) {
                if (metaCols.visibleColumns.contains(metaDataCol)) continue;
                value = this.generateCell(pathList, metaDataCol);
                row.getItemProperty((Object)metaDataCol.getColName()).setValue((Object)value);
            }
            row.getItemProperty((Object)"corpus path").setValue((Object)path);
            row.getItemProperty((Object)"visualizer").setValue((Object)this.generateVisualizerLinks(docId));
            row.getItemProperty((Object)"info").setValue((Object)this.generateInfoButtonCell(doc));
        }
        this.setContainerDataSource((Container)this.container);
        Object[] metaDataColNames = new Object[metaCols.visibleColumns.size()];
        for (int i = 0; i < metaDataColNames.length; ++i) {
            metaDataColNames[i] = ((MetaDataCol)metaCols.visibleColumns.get(i)).getColName();
        }
        Object[] columnNames = ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])new Object[]{PROP_DOC_NAME}, (Object[])metaDataColNames), (Object[])new Object[]{"corpus path", "visualizer", "info"});
        this.setVisibleColumns(columnNames);
        for (Object colName : columnNames) {
            this.setColumnHeader((Object)((String)colName), (String)colName);
        }
        this.sortByMetaData(metaCols.sortColumns);
    }

    private void sortByMetaData(List<MetaDataCol> sortColumns) {
        if (sortColumns == null || sortColumns.isEmpty()) {
            this.sort(new Object[]{PROP_DOC_NAME}, new boolean[]{true});
            return;
        }
        Object[] sortByColumns = new Object[sortColumns.size()];
        boolean[] ascendingOrDescending = new boolean[sortColumns.size()];
        for (int i = 0; i < sortColumns.size(); ++i) {
            sortByColumns[i] = sortColumns.get(i).getColName();
            ascendingOrDescending[i] = sortColumns.get((int)i).ascending;
        }
        this.sort(sortByColumns, ascendingOrDescending);
    }

    static /* synthetic */ DocBrowserPanel access$000(DocBrowserTable x0) {
        return x0.docBrowserPanel;
    }
}

