/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.eventbus.EventBus;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.ExportHelper;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.hibernate.cache.CacheException;

public abstract class BaseMatrixExporter
implements ExporterPlugin,
Serializable {
    private static final long serialVersionUID = 787797500368376816L;

    private void processFirstPass(SaltProject p, Map<String, String> args, int offset, int nodeCount) throws IOException {
        int recordNumber = offset;
        if (p != null && p.getCorpusGraphs() != null) {
            for (SCorpusGraph corpusGraph : p.getCorpusGraphs()) {
                if (corpusGraph.getDocuments() == null) continue;
                for (SDocument doc : corpusGraph.getDocuments()) {
                    this.createAdjacencyMatrix(doc.getDocumentGraph(), args, recordNumber++, nodeCount);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exception convertText(String queryAnnisQL, QueryLanguage queryLanguage, int contextLeft, int contextRight, Set<String> corpora, List<String> keys, String argsAsString, boolean alignmc, Writer out, EventBus eventBus, Map<String, CorpusConfiguration> corpusConfigs, UI ui) {
        HashMap<String, String> args = new HashMap<String, String>();
        for (String s : argsAsString.split("&|;")) {
            String[] splitted = s.split("=", 2);
            String key = splitted[0];
            String val = "";
            if (splitted.length > 1) {
                val = splitted[1];
            }
            args.put(key, val);
        }
        SearchApi searchApi = new SearchApi(Helper.getClient((UI)ui));
        FindQuery query = new FindQuery();
        query.setCorpora(new LinkedList<String>(corpora));
        query.setQueryLanguage(queryLanguage);
        query.setQuery(queryAnnisQL);
        try {
            Optional p;
            String currentLine;
            File matches = searchApi.find(query);
            List nodeDescriptions = searchApi.nodeDescriptions(queryAnnisQL, queryLanguage);
            Integer nodeCount = nodeDescriptions.size();
            ArrayList listOfKeys = new ArrayList();
            Collections.sort(listOfKeys);
            CorporaApi corporaApi = new CorporaApi(Helper.getClient((UI)ui));
            int progress = 0;
            try (LineIterator lines = FileUtils.lineIterator((File)matches, (String)StandardCharsets.UTF_8.name());){
                int recordNumber = 0;
                while (lines.hasNext()) {
                    currentLine = lines.nextLine();
                    p = ExportHelper.getSubgraphForMatch((String)currentLine, (CorporaApi)corporaApi, (int)contextLeft, (int)contextRight, args);
                    if (p.isPresent()) {
                        this.processFirstPass((SaltProject)p.get(), args, recordNumber++, nodeCount.intValue());
                    }
                    if (eventBus != null && ++progress % 100 == 0) {
                        eventBus.post((Object)(progress / 2));
                    }
                    if (!Thread.interrupted()) continue;
                    InterruptedException interruptedException = new InterruptedException("Exporter job was interrupted");
                    return interruptedException;
                }
            }
            this.getOrderedMatchNumbers();
            int recordNumber = 0;
            try (LineIterator lines = FileUtils.lineIterator((File)matches, (String)StandardCharsets.UTF_8.name());){
                while (lines.hasNext()) {
                    currentLine = lines.nextLine();
                    p = ExportHelper.getSubgraphForMatch((String)currentLine, (CorporaApi)corporaApi, (int)contextLeft, (int)contextRight, args);
                    if (p.isPresent()) {
                        for (SCorpusGraph cg : ((SaltProject)p.get()).getCorpusGraphs()) {
                            for (SDocument doc : cg.getDocuments()) {
                                this.outputText(doc.getDocumentGraph(), alignmc, recordNumber++, out, ui);
                                if (eventBus == null || ++progress % 100 != 0) continue;
                                eventBus.post((Object)(progress / 2));
                            }
                        }
                    }
                    if (!Thread.interrupted()) continue;
                    InterruptedException interruptedException = new InterruptedException("Exporter job was interrupted");
                    return interruptedException;
                }
            }
            out.append("\n");
            return null;
        }
        catch (IOException | ClassCastException | IllegalStateException | XMLStreamException | ApiException | CacheException ex) {
            return ex;
        }
    }

    public abstract void createAdjacencyMatrix(SDocumentGraph var1, Map<String, String> var2, int var3, int var4) throws IOException;

    public String getFileEnding() {
        return "txt";
    }

    public abstract void getOrderedMatchNumbers();

    public boolean isCancelable() {
        return true;
    }

    public boolean needsContext() {
        return true;
    }

    public abstract void outputText(SDocumentGraph var1, boolean var2, int var3, Writer var4, UI var5) throws IOException;
}

