/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.SubgraphWithContext;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.graphml.DocumentGraphMapper;
import org.corpus_tools.annis.gui.objects.Match;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SaltProject;
import org.eclipse.emf.common.util.URI;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportHelper {
    private ExportHelper() {
    }

    protected static SaltProject documentGraphToProject(SDocumentGraph graph, List<String> corpusPath) {
        SaltProject p = SaltFactory.createSaltProject();
        SCorpusGraph cg = p.createCorpusGraph();
        URI docURI = URI.createURI((String)("salt:/" + Joiner.on((char)'/').join(corpusPath)));
        SDocument doc = cg.createDocument(docURI);
        doc.setDocumentGraph(graph);
        return p;
    }

    protected static Optional<SaltProject> getSubgraphForMatch(String match, CorporaApi corporaApi, int contextLeft, int contextRight, Map<String, String> args) throws ApiException, IOException, XMLStreamException {
        Match parsedMatch = Match.parseFromString((String)match);
        if (!parsedMatch.getSaltIDs().isEmpty()) {
            List corpusPath = Helper.getCorpusPath((String)((String)parsedMatch.getSaltIDs().get(0)));
            SubgraphWithContext subgraphQuery = new SubgraphWithContext();
            subgraphQuery.setLeft(Integer.valueOf(contextLeft));
            subgraphQuery.setRight(Integer.valueOf(contextRight));
            subgraphQuery.segmentation(null);
            subgraphQuery.setNodeIds(parsedMatch.getSaltIDs());
            if (args.containsKey("segmentation")) {
                subgraphQuery.setSegmentation(args.get("segmentation"));
            }
            File graphML = corporaApi.subgraphForNodes((String)corpusPath.get(0), subgraphQuery);
            SDocumentGraph docGraph = DocumentGraphMapper.map((File)graphML);
            SaltProject p = ExportHelper.documentGraphToProject((SDocumentGraph)docGraph, (List)corpusPath);
            Helper.addMatchToDocumentGraph((Match)parsedMatch, (SDocumentGraph)docGraph);
            return Optional.of(p);
        }
        return Optional.empty();
    }
}

