/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.base.Splitter;
import com.google.common.eventbus.EventBus;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.SearchApi;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.api.model.CorpusConfiguration;
import org.corpus_tools.annis.api.model.FindQuery;
import org.corpus_tools.annis.api.model.QueryLanguage;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.ExportHelper;
import org.corpus_tools.annis.gui.exporter.ExporterPlugin;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;

public abstract class GeneralTextExporter
implements ExporterPlugin,
Serializable {
    private static final long serialVersionUID = 1583693456515398514L;

    public void appendMetaData(Writer out, List<String> metaKeys, String toplevelCorpus, String documentName, Map<String, Map<String, SMetaAnnotation>> metadataCache, UI ui) throws IOException {
        Map<Object, Object> metaData = new HashMap();
        if (metadataCache.containsKey(toplevelCorpus + ":" + documentName)) {
            metaData = metadataCache.get(toplevelCorpus + ":" + documentName);
        } else {
            List asList = Helper.getMetaData((String)toplevelCorpus, Optional.ofNullable(documentName), (UI)ui);
            for (SMetaAnnotation anno : asList) {
                metaData.put(anno.getQName(), anno);
                metaData.put(anno.getName(), anno);
            }
            metadataCache.put(toplevelCorpus + ":" + documentName, metaData);
        }
        for (String key : metaKeys) {
            SMetaAnnotation anno;
            anno = (SMetaAnnotation)metaData.get(key);
            if (anno == null) continue;
            out.append("\tmeta::" + key + "\t" + anno.getValue()).append("\n");
        }
    }

    public void convertText(SaltProject queryResult, List<String> keys, Map<String, String> args, Writer out, int offset, UI ui) throws IOException {
        HashMap metadataCache = new HashMap();
        LinkedList<String> metaKeys = new LinkedList<String>();
        if (args.containsKey("metakeys")) {
            Iterable it = Splitter.on((String)",").trimResults().split((CharSequence)args.get("metakeys"));
            for (String s : it) {
                metaKeys.add(s);
            }
        }
        int counter = 0;
        for (SCorpusGraph corpusGraph : queryResult.getCorpusGraphs()) {
            for (SDocument doc : corpusGraph.getDocuments()) {
                SDocumentGraph graph = doc.getDocumentGraph();
                out.append(++counter + offset + ". ");
                List tok = graph.getSortedTokenByText();
                for (SToken annisNode : tok) {
                    Long match;
                    SFeature featMatched = annisNode.getFeature("annis", "matchednode");
                    Long l = match = featMatched == null ? null : featMatched.getValue_SNUMERIC();
                    if (match != null) {
                        out.append("[");
                        out.append(graph.getText((SNode)annisNode));
                        out.append("]");
                    } else {
                        out.append(graph.getText((SNode)annisNode));
                    }
                    out.append(" ");
                }
                out.append("\n");
                if (!metaKeys.isEmpty()) {
                    String[] path = Helper.getCorpusPath((SCorpusGraph)corpusGraph, (SDocument)doc).toArray(new String[0]);
                    this.appendMetaData(out, metaKeys, path[path.length - 1], path[0], metadataCache, ui);
                }
                out.append("\n");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exception convertText(String queryAnnisQL, QueryLanguage queryLanguage, int contextLeft, int contextRight, Set<String> corpora, List<String> keys, String argsAsString, boolean alignmc, Writer out, EventBus eventBus, Map<String, CorpusConfiguration> corpusConfigs, UI ui) {
        try {
            CorporaApi corporaApi = new CorporaApi(Helper.getClient((UI)ui));
            if (keys == null || keys.isEmpty()) {
                keys = this.getAllAnnotationsAsExporterKey(corpora, corporaApi);
            }
            List finalKeys = keys;
            HashMap<String, String> args = new HashMap<String, String>();
            for (String s : argsAsString.split("&|;")) {
                String[] splitted = s.split("=", 2);
                String key = splitted[0];
                String val = "";
                if (splitted.length > 1) {
                    val = splitted[1];
                }
                args.put(key, val);
            }
            SearchApi searchApi = new SearchApi(Helper.getClient((UI)ui));
            FindQuery query = new FindQuery();
            query.setCorpora(new LinkedList<String>(corpora));
            query.setQueryLanguage(queryLanguage);
            query.setQuery(queryAnnisQL);
            AtomicInteger offset = new AtomicInteger();
            File matches = searchApi.find(query);
            try (LineIterator lines = FileUtils.lineIterator((File)matches, (String)StandardCharsets.UTF_8.name());){
                do {
                    if (!lines.hasNext()) return null;
                    String currentLine = lines.nextLine();
                    Optional p = ExportHelper.getSubgraphForMatch((String)currentLine, (CorporaApi)corporaApi, (int)contextLeft, (int)contextRight, args);
                    if (!p.isPresent()) continue;
                    int currentOffset = offset.getAndIncrement();
                    this.convertText((SaltProject)p.get(), finalKeys, args, out, currentOffset, ui);
                    if (eventBus == null) continue;
                    eventBus.post((Object)(currentOffset + 1));
                } while (!Thread.interrupted());
                InterruptedException interruptedException = new InterruptedException("Exporter job was interrupted");
                return interruptedException;
            }
        }
        catch (IOException | XMLStreamException | ApiException ex) {
            return ex;
        }
    }

    public String getFileEnding() {
        return "txt";
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean needsContext() {
        return true;
    }

    protected List<String> getAllAnnotationsAsExporterKey(Collection<String> corpora, CorporaApi api) throws ApiException {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add("tok");
        LinkedList attributes = new LinkedList();
        for (String corpus : corpora) {
            attributes.addAll(api.nodeAnnotations(corpus, Boolean.valueOf(false), Boolean.valueOf(false)));
        }
        for (Annotation a : attributes) {
            if (a.getKey().getName() == null) continue;
            keys.add(a.getKey().getName());
        }
        return keys;
    }
}

