/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.base.Splitter;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.GeneralTextExporter;
import org.corpus_tools.annis.gui.exporter.GridExporter;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.springframework.stereotype.Component;

@Component
public class GridExporter
extends GeneralTextExporter {
    private static final long serialVersionUID = 5344106264419931470L;

    public void convertText(SaltProject queryResult, List<String> keys, Map<String, String> args, Writer out, int offset, UI ui) throws IOException {
        String arg;
        HashMap metadataCache = new HashMap();
        boolean showNumbers = true;
        if (args.containsKey("numbers") && ((arg = args.get("numbers")).equalsIgnoreCase("false") || arg.equalsIgnoreCase("0") || arg.equalsIgnoreCase("off"))) {
            showNumbers = false;
        }
        LinkedList<String> metaKeys = new LinkedList<String>();
        if (args.containsKey("metakeys")) {
            Iterable it = Splitter.on((String)",").trimResults().split((CharSequence)args.get("metakeys"));
            for (String s : it) {
                metaKeys.add(s);
            }
        }
        int counter = 0;
        for (SCorpusGraph corpusGraph : queryResult.getCorpusGraphs()) {
            for (SDocument doc : corpusGraph.getDocuments()) {
                SNode resolveNode;
                List coveredTokens;
                SDocumentGraph graph = doc.getDocumentGraph();
                HashMap annos = new HashMap();
                out.append(++counter + offset + ".");
                List tokens = graph.getSortedTokenByText();
                HashMap<SToken, Long> token2index = new HashMap<SToken, Long>();
                long i22 = 0L;
                for (Object t : tokens) {
                    token2index.put((SToken)t, i22++);
                }
                Iterator<Object> i22 = graph.getNodes().iterator();
                while (i22.hasNext() && (coveredTokens = graph.getOverlappedTokens(resolveNode = (SNode)i22.next())) != null && !coveredTokens.isEmpty()) {
                    Object t;
                    coveredTokens = graph.getSortedTokenByText(coveredTokens);
                    t = resolveNode.getAnnotations().iterator();
                    while (t.hasNext()) {
                        SAnnotation resolveAnnotation = (SAnnotation)t.next();
                        String k = resolveAnnotation.getName();
                        if (annos.get(k) == null) {
                            annos.put(k, new TreeMap());
                        }
                        long left_token_idx = (Long)token2index.get(coveredTokens.get(0));
                        long right_token_idx = (Long)token2index.get(coveredTokens.get(coveredTokens.size() - 1));
                        ((TreeMap)annos.get(k)).put(left_token_idx, new Span(left_token_idx, right_token_idx, resolveAnnotation.getValue().toString()));
                    }
                }
                for (String k : keys) {
                    if ("tok".equals(k)) {
                        out.append("\t" + k + "\t ");
                        for (SToken annisNode : tokens) {
                            out.append(graph.getText((SNode)annisNode) + " ");
                        }
                        out.append("\n");
                        continue;
                    }
                    if (annos.get(k) == null) continue;
                    out.append("\t" + k + "\t ");
                    for (Span s : ((TreeMap)annos.get(k)).values()) {
                        out.append(s.getValue());
                        if (showNumbers) {
                            long leftIndex = Math.max(1L, s.getStart());
                            long rightIndex = s.getEnd();
                            out.append("[" + leftIndex + "-" + rightIndex + "]");
                        }
                        out.append(" ");
                    }
                    out.append("\n");
                }
                if (!metaKeys.isEmpty()) {
                    String[] path = Helper.getCorpusPath((SCorpusGraph)corpusGraph, (SDocument)doc).toArray(new String[0]);
                    super.appendMetaData(out, metaKeys, path[path.length - 1], path[0], metadataCache, ui);
                }
                out.append("\n\n");
            }
        }
    }

    public String getHelpMessage() {
        return "The Grid Exporter can export all annotations of a search result and its context. Each annotation layer is represented in a separate line, and the tokens covered by each annotation are given as number ranges after each annotation in brackets. To suppress token numbers, input numbers=false into the parameters box below. To display only a subset of annotations in any order use the \"Annotation keys\" text field, input e.g. \"tok,pos,cat\" to show tokens and the annotations pos and cat.<br /><br />Parameters: <br/><em>metakeys</em> - comma seperated list of all meta data to include in the result (e.g. <code>metakeys=title,documentname</code>) <br /><em>numbers</em> - set to \"false\" if the grid event numbers should not be included in the output (e.g. <code>numbers=false</code>)";
    }

    public boolean isAlignable() {
        return false;
    }
}

