/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.vaadin.server.Page;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.BaseMatrixExporter;
import org.corpus_tools.annis.gui.exporter.TextColumnExporter;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.springframework.stereotype.Component;

@Component
public class TextColumnExporter
extends BaseMatrixExporter {
    private static final long serialVersionUID = -7626792232044137420L;
    private static final Escaper urlPathEscape = UrlEscapers.urlPathSegmentEscaper();
    private static final String TRAV_PREPROCESSING = "travPreprocessing";
    public static final String FILTER_PARAMETER_KEYWORD = "filter";
    public static final String PARAMETER_SEPARATOR = ",";
    public static final String METAKEYS_KEYWORD = "metakeys";
    private static final String NEWLINE = System.lineSeparator();
    private static final String TAB_MARK = "\t";
    private static final String SPACE = " ";
    private final HashMap<String, Boolean> speakerHasMatches = new HashMap();
    private String speakerName = "";
    private boolean isFirstSpeakerWithMatch = true;
    private final List<Long> dominatedMatchCodes = new ArrayList();
    private final Map<Long, Long> tokenToMatchNumber = new HashMap();
    private final Set<Long> filterNumbersSetByUser = new HashSet();
    private boolean filterNumbersIsEmpty = true;
    private final List<String> listOfMetakeys = new ArrayList();
    private int[][] adjacencyMatrix;
    private boolean matrixIsFilled = false;
    private final Set<Long> singleMatchesGlobal = new HashSet();
    private List<Long> orderedMatchNumbersGlobal = new ArrayList();
    private final Set<Integer> matchNumbersGlobal = new HashSet();
    private boolean dataIsAlignable = true;
    private int maxMatchesPerLine = 0;
    private long counterGlobal;

    private List<Long> calculateOrderedMatchNumbersGlobally(int[][] adjacencyMatrix, boolean matrixIsFilled, Set<Long> singleMatches) {
        ArrayList<Long> orderedMatchNumbers = new ArrayList<Long>();
        if (matrixIsFilled) {
            int first = -1;
            int second = -1;
            block0: for (int i = 0; i < adjacencyMatrix[0].length; ++i) {
                for (int j = 0; j < adjacencyMatrix.length; ++j) {
                    if (adjacencyMatrix[j][i] != 1) continue;
                    if (adjacencyMatrix[i][j] != 1) {
                        first = j + 1;
                        second = i + 1;
                        if (orderedMatchNumbers.contains(first)) {
                            if (orderedMatchNumbers.contains(second)) continue;
                            orderedMatchNumbers.add(Long.valueOf(second));
                            continue;
                        }
                        if (orderedMatchNumbers.contains(second)) {
                            int index = orderedMatchNumbers.indexOf(second);
                            orderedMatchNumbers.add(index, Long.valueOf(first));
                            continue;
                        }
                        orderedMatchNumbers.add(Long.valueOf(first));
                        orderedMatchNumbers.add(Long.valueOf(second));
                        continue;
                    }
                    this.dataIsAlignable = false;
                    break block0;
                }
            }
            if (this.dataIsAlignable) {
                for (Long match : singleMatches) {
                    if (orderedMatchNumbers.contains(match)) continue;
                    boolean matchIsMerged = false;
                    for (Long next : orderedMatchNumbers) {
                        if (next <= match) continue;
                        int index = orderedMatchNumbers.indexOf(next);
                        orderedMatchNumbers.add(index, match);
                        matchIsMerged = true;
                        break;
                    }
                    if (matchIsMerged) continue;
                    orderedMatchNumbers.add(match);
                }
            }
        } else {
            for (Long match : singleMatches) {
                orderedMatchNumbers.add(match);
            }
            Collections.sort(orderedMatchNumbers);
        }
        if (this.dataIsAlignable) {
            return orderedMatchNumbers;
        }
        return new ArrayList<Long>();
    }

    public void createAdjacencyMatrix(SDocumentGraph graph, Map<String, String> args, int recordNumber, int nodeCount) throws IOException {
        block20: {
            List orderedToken;
            String currSpeakerName = "";
            String prevSpeakerName = "";
            ArrayList matchNumbersOrdered = new ArrayList();
            if (recordNumber == 0) {
                int i;
                this.speakerHasMatches.clear();
                this.speakerName = "";
                this.tokenToMatchNumber.clear();
                this.filterNumbersSetByUser.clear();
                this.filterNumbersIsEmpty = true;
                this.listOfMetakeys.clear();
                this.adjacencyMatrix = new int[nodeCount][nodeCount];
                this.matrixIsFilled = false;
                this.singleMatchesGlobal.clear();
                this.orderedMatchNumbersGlobal.clear();
                this.matchNumbersGlobal.clear();
                this.dataIsAlignable = true;
                this.maxMatchesPerLine = 0;
                for (int i2 = 0; i2 < this.adjacencyMatrix.length; ++i2) {
                    for (int j = 0; j < this.adjacencyMatrix[0].length; ++j) {
                        this.adjacencyMatrix[i2][j] = -1;
                    }
                }
                if (args.containsKey(FILTER_PARAMETER_KEYWORD)) {
                    String parameters = args.get(FILTER_PARAMETER_KEYWORD);
                    String[] numbers = parameters.split(PARAMETER_SEPARATOR);
                    for (i = 0; i < numbers.length; ++i) {
                        try {
                            Long number = Long.parseLong(numbers[i]);
                            this.filterNumbersSetByUser.add(number);
                            continue;
                        }
                        catch (NumberFormatException number) {
                            // empty catch block
                        }
                    }
                }
                if (!this.filterNumbersSetByUser.isEmpty()) {
                    this.filterNumbersIsEmpty = false;
                }
                if (args.containsKey(METAKEYS_KEYWORD)) {
                    String parameters = args.get(METAKEYS_KEYWORD);
                    String[] metakeys = parameters.split(PARAMETER_SEPARATOR);
                    for (i = 0; i < metakeys.length; ++i) {
                        String metakey = metakeys[i].trim();
                        this.listOfMetakeys.add(metakey);
                    }
                }
            }
            if (graph == null || (orderedToken = graph.getSortedTokenByText()) == null) break block20;
            if (recordNumber == 0) {
                this.counterGlobal = 0L;
            }
            for (SToken token : orderedToken) {
                block21: {
                    block23: {
                        block22: {
                            ++this.counterGlobal;
                            String name = Helper.getTextualDSForNode((SNode)token, (SDocumentGraph)graph).getName();
                            if (name == null) {
                                name = "";
                            }
                            if (!(currSpeakerName = (this.speakerName = recordNumber + 1 + "_" + name)).equals(prevSpeakerName)) {
                                matchNumbersOrdered.clear();
                            }
                            if (!this.speakerHasMatches.containsKey(currSpeakerName)) {
                                this.speakerHasMatches.put(currSpeakerName, false);
                            }
                            LinkedList<SToken> root = new LinkedList<SToken>();
                            root.add(token);
                            IsDominatedByMatch traverserSpeakerSearch = new IsDominatedByMatch(this, null);
                            this.dominatedMatchCodes.clear();
                            graph.traverse(root, SGraph.GRAPH_TRAVERSE_TYPE.BOTTOM_UP_DEPTH_FIRST, TRAV_PREPROCESSING, (GraphTraverseHandler)traverserSpeakerSearch);
                            if (this.dominatedMatchCodes.isEmpty()) break block21;
                            if (!this.filterNumbersIsEmpty) break block22;
                            this.tokenToMatchNumber.put(this.counterGlobal, this.dominatedMatchCodes.get(this.dominatedMatchCodes.size() - 1));
                            if (matchNumbersOrdered.contains(this.dominatedMatchCodes.get(this.dominatedMatchCodes.size() - 1))) break block23;
                            matchNumbersOrdered.add(this.dominatedMatchCodes.get(this.dominatedMatchCodes.size() - 1));
                            break block23;
                        }
                        boolean filterNumberFound = false;
                        for (int i = this.dominatedMatchCodes.size() - 1; i >= 0; --i) {
                            if (!this.filterNumbersSetByUser.contains(this.dominatedMatchCodes.get(i))) continue;
                            this.tokenToMatchNumber.put(this.counterGlobal, this.dominatedMatchCodes.get(i));
                            if (matchNumbersOrdered.contains(this.dominatedMatchCodes.get(i)) || filterNumberFound) break;
                            matchNumbersOrdered.add(this.dominatedMatchCodes.get(i));
                            filterNumberFound = true;
                            break;
                        }
                    }
                    if (this.maxMatchesPerLine < matchNumbersOrdered.size()) {
                        this.maxMatchesPerLine = matchNumbersOrdered.size();
                    }
                    if (matchNumbersOrdered.size() > 1) {
                        Iterator it = matchNumbersOrdered.iterator();
                        int prev = Integer.parseInt(String.valueOf(it.next()));
                        this.matchNumbersGlobal.add(prev);
                        while (it.hasNext()) {
                            int curr = Integer.parseInt(String.valueOf(it.next()));
                            this.matchNumbersGlobal.add(curr);
                            this.adjacencyMatrix[prev - 1][curr - 1] = 1;
                            this.matrixIsFilled = true;
                            prev = curr;
                        }
                    } else {
                        this.matchNumbersGlobal.add(Integer.parseInt(String.valueOf(matchNumbersOrdered.get(0))));
                        this.singleMatchesGlobal.add(matchNumbersOrdered.get(0));
                    }
                }
                prevSpeakerName = currSpeakerName;
            }
        }
    }

    public String getFileEnding() {
        return "txt";
    }

    public String getHelpMessage() {
        return "The TextColumnExporter exports matches surrounded by the context as a csv file. The columns will be separated by tab mark. <br/>Parameters: <br/><em>metakeys</em> - comma separated list of all meta data to include in the result (e.g. <code>metakeys=title,comment</code>)  <br/><em>filter</em> - comma separated list of all node numbers to be represented in the result as a separated column (e.g. <code>filter=1,2</code>) <br/></br>Please note, if some matched nodes build a hierarchy, you can use one node number per hierarchy only. For instance, the matched nodes of the aql-query <br/><em>cat=\"SIMPX\" > cat = \"FRAG\" >* SPK101 = \"UNINTERPRETABLE\" </em> build a hierarchy by definition. There are three node numbers 1, 2  and 3. However, only one of them can be used for export. By default it is the highest node in the hierarchy, which determine the relevant node number. In our example it is the node with the node number 1. That means, all tokens covered by node with the node number 1 will appeare in the match column. If desired, by filter option you can choose an other node number from the hierarchy. In our case it could be 2 or 3.";
    }

    public void getOrderedMatchNumbers() {
        this.orderedMatchNumbersGlobal = this.calculateOrderedMatchNumbersGlobally(this.adjacencyMatrix, this.matrixIsFilled, this.singleMatchesGlobal);
    }

    public boolean isAlignable() {
        return true;
    }

    public void outputText(SDocumentGraph graph, boolean alignmc, int recordNumber, Writer out, UI ui) throws IOException {
        List orderedToken;
        String currSpeakerName = "";
        String prevSpeakerName = "";
        if (graph != null && (orderedToken = graph.getSortedTokenByText()) != null) {
            ListIterator it = orderedToken.listIterator();
            long lastTokenWasMatched = -1L;
            boolean noPreviousTokenInLine = false;
            if (recordNumber == 0) {
                this.isFirstSpeakerWithMatch = true;
                this.counterGlobal = 0L;
                String numbersString = "";
                String warnMessage = "";
                StringBuilder sb = new StringBuilder();
                ArrayList<Integer> copyOfFilterNumbersSetByUser = new ArrayList<Integer>();
                for (Number filterNumber : this.filterNumbersSetByUser) {
                    copyOfFilterNumbersSetByUser.add(Integer.parseInt(String.valueOf(filterNumber)));
                }
                for (Integer matchNumberGlobal : this.matchNumbersGlobal) {
                    copyOfFilterNumbersSetByUser.remove(matchNumberGlobal);
                }
                Collections.sort(copyOfFilterNumbersSetByUser);
                if (!copyOfFilterNumbersSetByUser.isEmpty()) {
                    Iterator iterator = copyOfFilterNumbersSetByUser.iterator();
                    while (iterator.hasNext()) {
                        Number filterNumber;
                        filterNumber = (Integer)iterator.next();
                        sb.append(filterNumber + ", ");
                    }
                    numbersString = copyOfFilterNumbersSetByUser.size() == 1 ? "number" : "numbers";
                    warnMessage = "1. Filter " + numbersString + SPACE + sb.toString().substring(0, sb.lastIndexOf(PARAMETER_SEPARATOR)) + " couldn't be represented.";
                }
                if (alignmc && !this.dataIsAlignable) {
                    warnMessage = !warnMessage.isEmpty() ? warnMessage + NEWLINE + NEWLINE + "2. " : warnMessage + "1. ";
                    warnMessage = warnMessage + "You have tried to align matches by node number via check box.Unfortunately this option is not applicable for this data set, so the data couldn't be aligned.";
                }
                if (!warnMessage.isEmpty()) {
                    String warnCaption = "Some export options couldn't be realized.";
                    Notification warn = new Notification(warnCaption, warnMessage, Notification.Type.WARNING_MESSAGE);
                    warn.setDelayMsec(20000);
                    warn.show(Page.getCurrent());
                }
            }
            int matchesWrittenForSpeaker = 0;
            while (it.hasNext()) {
                SToken tok = (SToken)it.next();
                ++this.counterGlobal;
                String name = Helper.getTextualDSForNode((SNode)tok, (SDocumentGraph)graph).getName();
                if (name == null) {
                    name = "";
                }
                if (!((Boolean)this.speakerHasMatches.get(currSpeakerName = recordNumber + 1 + "_" + name)).booleanValue()) {
                    prevSpeakerName = currSpeakerName;
                    continue;
                }
                if (!currSpeakerName.equals(prevSpeakerName)) {
                    matchesWrittenForSpeaker = 0;
                    if (this.isFirstSpeakerWithMatch) {
                        int i;
                        out.append("match_number\t");
                        out.append("speaker\t");
                        if (!this.listOfMetakeys.isEmpty()) {
                            for (String metakey : this.listOfMetakeys) {
                                out.append(metakey + TAB_MARK);
                            }
                        }
                        out.append("left_context\t");
                        String prefixAlignmc = "match_";
                        String prefix = "match_column";
                        String middle_context = "middle_context_";
                        if (alignmc && this.dataIsAlignable) {
                            for (i = 0; i < this.orderedMatchNumbersGlobal.size(); ++i) {
                                out.append(prefixAlignmc + this.orderedMatchNumbersGlobal.get(i) + TAB_MARK);
                                if (i >= this.orderedMatchNumbersGlobal.size() - 1) continue;
                                out.append(middle_context + (i + 1) + TAB_MARK);
                            }
                        } else {
                            for (i = 0; i < this.maxMatchesPerLine; ++i) {
                                out.append(prefix + TAB_MARK);
                                if (i >= this.maxMatchesPerLine - 1) continue;
                                out.append(middle_context + (i + 1) + TAB_MARK);
                            }
                        }
                        out.append("right_context");
                        out.append(NEWLINE);
                        this.isFirstSpeakerWithMatch = false;
                    } else {
                        out.append(NEWLINE);
                    }
                    out.append(String.valueOf(recordNumber + 1) + TAB_MARK);
                    String trimmedName = "";
                    if (currSpeakerName.indexOf("_") < currSpeakerName.length()) {
                        trimmedName = currSpeakerName.substring(currSpeakerName.indexOf("_") + 1);
                    }
                    out.append(trimmedName + TAB_MARK);
                    if (!this.listOfMetakeys.isEmpty()) {
                        String docName = graph.getDocument().getName();
                        List corpusPath = Helper.getCorpusPath((SCorpusGraph)graph.getDocument().getGraph(), (SDocument)graph.getDocument());
                        String corpusName = (String)corpusPath.get(corpusPath.size() - 1);
                        corpusName = urlPathEscape.escape(corpusName);
                        List metadata = Helper.getMetaData((String)corpusName, Optional.of(docName), (UI)ui);
                        HashMap annosWithoutNamespace = new HashMap();
                        HashMap annosWithNamespace = new HashMap();
                        for (SMetaAnnotation metaAnno : metadata) {
                            HashMap<String, String> data = new HashMap<String, String>();
                            data.put(metaAnno.getName(), metaAnno.getValue_STEXT());
                            String ns = metaAnno.getNamespace();
                            if (ns != null && !ns.isEmpty()) {
                                Map<String, String> nsMetadata = new HashMap<String, String>();
                                if (annosWithNamespace.get(ns) != null) {
                                    nsMetadata = (Map)annosWithNamespace.get(ns);
                                }
                                nsMetadata.putAll(data);
                                annosWithNamespace.put(ns, nsMetadata);
                                continue;
                            }
                            annosWithoutNamespace.putAll(data);
                        }
                        for (String metakey : this.listOfMetakeys) {
                            Map speakerAnnos;
                            String metaValue = "";
                            if (!trimmedName.isEmpty() && annosWithNamespace.containsKey(trimmedName) && (speakerAnnos = (Map)annosWithNamespace.get(trimmedName)).containsKey(metakey)) {
                                metaValue = ((String)speakerAnnos.get(metakey)).trim();
                            }
                            if (metaValue.isEmpty() && annosWithoutNamespace.containsKey(metakey)) {
                                metaValue = ((String)annosWithoutNamespace.get(metakey)).trim();
                            }
                            out.append(metaValue + TAB_MARK);
                        }
                    }
                    lastTokenWasMatched = -1L;
                    noPreviousTokenInLine = true;
                }
                String separator = SPACE;
                Long matchedNode = (Long)this.tokenToMatchNumber.get(this.counterGlobal);
                if (matchedNode != null) {
                    StringBuilder sb;
                    if (lastTokenWasMatched < 0L) {
                        if (alignmc && this.dataIsAlignable) {
                            int orderInList = this.orderedMatchNumbersGlobal.indexOf(matchedNode);
                            if (orderInList >= matchesWrittenForSpeaker) {
                                int diff = orderInList - matchesWrittenForSpeaker;
                                ++matchesWrittenForSpeaker;
                                sb = new StringBuilder(TAB_MARK);
                                for (int i = 0; i < diff; ++i) {
                                    sb.append("\t\t");
                                    ++matchesWrittenForSpeaker;
                                }
                                separator = sb.toString();
                            }
                        } else {
                            separator = TAB_MARK;
                        }
                    } else if (lastTokenWasMatched != matchedNode) {
                        if (alignmc && this.dataIsAlignable) {
                            int orderInList = this.orderedMatchNumbersGlobal.indexOf(matchedNode);
                            if (orderInList >= matchesWrittenForSpeaker) {
                                int diff = orderInList - matchesWrittenForSpeaker;
                                ++matchesWrittenForSpeaker;
                                sb = new StringBuilder("\t\t");
                                for (int i = 0; i < diff; ++i) {
                                    sb.append("\t\t");
                                    ++matchesWrittenForSpeaker;
                                }
                                separator = sb.toString();
                            }
                        } else {
                            separator = "\t\t";
                        }
                    }
                    lastTokenWasMatched = matchedNode;
                } else if (lastTokenWasMatched >= 0L) {
                    if (!this.tokenToMatchNumber.containsKey(this.counterGlobal) && this.tokenToMatchNumber.containsKey(this.counterGlobal - 1L) && this.tokenToMatchNumber.containsKey(this.counterGlobal + 1L)) {
                        if (Objects.equals(this.tokenToMatchNumber.get(this.counterGlobal - 1L), this.tokenToMatchNumber.get(this.counterGlobal + 1L))) {
                            separator = SPACE;
                            lastTokenWasMatched = (Long)this.tokenToMatchNumber.get(this.counterGlobal + 1L);
                        } else {
                            separator = TAB_MARK;
                            lastTokenWasMatched = -1L;
                        }
                    } else {
                        separator = TAB_MARK;
                        lastTokenWasMatched = -1L;
                    }
                }
                if (noPreviousTokenInLine && separator.equals(SPACE)) {
                    separator = "";
                }
                out.append(separator);
                out.append(graph.getText((SNode)tok));
                noPreviousTokenInLine = false;
                prevSpeakerName = currSpeakerName;
            }
        }
    }

    static /* synthetic */ Set access$000(TextColumnExporter x0) {
        return x0.filterNumbersSetByUser;
    }

    static /* synthetic */ boolean access$100(TextColumnExporter x0) {
        return x0.filterNumbersIsEmpty;
    }

    static /* synthetic */ List access$200(TextColumnExporter x0) {
        return x0.orderedMatchNumbersGlobal;
    }

    static /* synthetic */ List access$300(TextColumnExporter x0) {
        return x0.dominatedMatchCodes;
    }

    static /* synthetic */ String access$400(TextColumnExporter x0) {
        return x0.speakerName;
    }

    static /* synthetic */ HashMap access$500(TextColumnExporter x0) {
        return x0.speakerHasMatches;
    }
}

