/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.exporter;

import com.google.common.base.Splitter;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.exporter.GeneralTextExporter;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SNode;
import org.springframework.stereotype.Component;

@Component
public class TokenExporter
extends GeneralTextExporter {
    private static final long serialVersionUID = 218197959064424601L;

    public void convertText(SaltProject queryResult, List<String> keys, Map<String, String> args, Writer out, int offset, UI ui) throws IOException {
        HashMap metadataCache = new HashMap();
        LinkedList<String> metaKeys = new LinkedList<String>();
        if (args.containsKey("metakeys")) {
            Iterable it = Splitter.on((String)",").trimResults().split((CharSequence)args.get("metakeys"));
            for (String s : it) {
                metaKeys.add(s);
            }
        }
        int counter = 0;
        for (SCorpusGraph corpusGraph : queryResult.getCorpusGraphs()) {
            for (SDocument doc : corpusGraph.getDocuments()) {
                SDocumentGraph graph = doc.getDocumentGraph();
                out.append(++counter + offset + ". ");
                List tok = graph.getSortedTokenByText();
                for (SToken annisNode : tok) {
                    Long match;
                    SFeature featMatched = annisNode.getFeature("annis", "matchednode");
                    Long l = match = featMatched == null ? null : featMatched.getValue_SNUMERIC();
                    if (match != null) {
                        out.append("[");
                        out.append(graph.getText((SNode)annisNode));
                        out.append("]");
                    } else {
                        out.append(graph.getText((SNode)annisNode));
                    }
                    for (SAnnotation annotation : annisNode.getAnnotations()) {
                        out.append("/" + annotation.getValue());
                    }
                    out.append(" ");
                }
                out.append("\n");
                if (!metaKeys.isEmpty()) {
                    String[] path = Helper.getCorpusPath((SCorpusGraph)corpusGraph, (SDocument)doc).toArray(new String[0]);
                    super.appendMetaData(out, metaKeys, path[path.length - 1], path[0], metadataCache, ui);
                }
                out.append("\n");
            }
        }
    }

    public String getHelpMessage() {
        return "The Token Exporter exports the token covered by the matched nodes of every search result and its context, one line per result. Beside the text of the token it also contains all token annotations separated by \"/\".<p><strong>This exporter does not work well with dialog data (corpora that have more than one primary text). Use the GridExporter instead.</strong></p>";
    }

    public boolean isAlignable() {
        return false;
    }
}

