/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.NativeSelect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.corpus_tools.annis.ApiException;
import org.corpus_tools.annis.api.CorporaApi;
import org.corpus_tools.annis.api.model.AnnoKey;
import org.corpus_tools.annis.api.model.Annotation;
import org.corpus_tools.annis.gui.Helper;
import org.corpus_tools.annis.gui.IDGenerator;
import org.corpus_tools.annis.gui.QueryController;
import org.corpus_tools.annis.gui.flatquerybuilder.EdgeBox;
import org.corpus_tools.annis.gui.flatquerybuilder.MetaBox;
import org.corpus_tools.annis.gui.flatquerybuilder.ReducingStringComparator;
import org.corpus_tools.annis.gui.flatquerybuilder.SearchBox;
import org.corpus_tools.annis.gui.flatquerybuilder.SpanBox;
import org.corpus_tools.annis.gui.flatquerybuilder.VerticalNode;
import org.corpus_tools.annis.gui.objects.Query;
import org.corpus_tools.annis.gui.objects.QueryLanguage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatQueryBuilder
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = -1659782316940380300L;
    private static final Logger log = LoggerFactory.getLogger(FlatQueryBuilder.class);
    private static final String[] REGEX_CHARACTERS = new String[]{"\\", "+", ".", "[", "*", "^", "$", "|", "?", "(", ")"};
    private static final String BUTTON_GO_LABEL = "Create AQL Query";
    private static final String BUTTON_CLEAR_LABEL = "Clear the Query Builder";
    private static final String NO_CORPORA_WARNING = "No corpora selected, please select at least one corpus.";
    private static final String INCOMPLETE_QUERY_WARNING = "Query seems to be incomplete.";
    private static final String ADD_LING_PARAM = "Add";
    private static final String ADD_SPAN_PARAM = "Add";
    private static final String CHANGE_SPAN_PARAM = "Change";
    private static final String ADD_META_PARAM = "Add";
    private static final String INFO_INIT_LANG = "In this part of the Query Builder, blocks of the linguistic query can be constructed from left to right.";
    private static final String INFO_INIT_SPAN = "This part of the Query Builder allows you to define a span annotation within which the above query blocks are confined.";
    private static final String INFO_INIT_META = "Here, you can constrain the linguistic query by selecting meta levels.";
    private static final String INFO_FILTER = "When searching in the fields, the hits are sorted and filtered according to different mechanisms. Please choose a filtering mechanism here.";
    private static final String TOOLBAR_CAPTION = "Toolbar";
    private static final String META_CAPTION = "Meta information";
    private static final String SPAN_CAPTION = "Scope";
    private static final String LANG_CAPTION = "Linguistic sequence";
    private static final String ADVANCED_CAPTION = "Advanced settings";
    private Button btGo;
    private Button btClear;
    private Button btInitSpan;
    private Button btInitMeta;
    private Button btInitLanguage;
    private MenuBar addMenu;
    private MenuBar addMenuSpan;
    private MenuBar addMenuMeta;
    private QueryController cp;
    private HorizontalLayout language;
    private HorizontalLayout languagenodes;
    private HorizontalLayout span;
    private HorizontalLayout meta;
    private HorizontalLayout toolbar;
    private HorizontalLayout advanced;
    private VerticalLayout mainLayout;
    private NativeSelect filtering;
    private Collection<VerticalNode> vnodes;
    private Collection<EdgeBox> eboxes;
    private Collection<MetaBox> mboxes;
    private SpanBox spbox;
    private MenuBar.MenuItem spanMenu;
    private ReducingStringComparator rsc;

    public FlatQueryBuilder(QueryController cp) {
        this.setSizeFull();
        this.launch(cp);
    }

    public void addLinguisticSequenceBox(String annoName) {
        if (!this.vnodes.isEmpty()) {
            EdgeBox eb = new EdgeBox(this);
            this.languagenodes.addComponent((Component)eb);
            this.eboxes.add(eb);
        }
        VerticalNode vn = new VerticalNode(annoName, this);
        this.languagenodes.addComponent((Component)vn);
        this.vnodes.add(vn);
        this.addMenu.setAutoOpen(false);
    }

    void addSpanBox(String level) {
        this.spbox = new SpanBox(level, this);
        this.span.addComponent((Component)this.spbox);
        this.span.setComponentAlignment((Component)this.spbox, Alignment.MIDDLE_LEFT);
        this.spanMenu.setText(CHANGE_SPAN_PARAM);
    }

    void addMetaBox(String annoname) {
        MetaBox mb = new MetaBox(annoname, this);
        this.meta.addComponent((Component)mb);
        this.mboxes.add(mb);
        this.addMenuMeta.setAutoOpen(false);
        for (MenuBar.MenuItem textItem : this.addMenuMeta.getItems()) {
            if (!"Add".equals(textItem.getText())) continue;
            for (MenuBar.MenuItem item : textItem.getChildren()) {
                if (!annoname.equals(item.getText())) continue;
                item.setVisible(false);
            }
        }
    }

    public void attach() {
        super.attach();
        Binder binder = new Binder();
        binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.initialize());
        binder.setBean((Object)this.cp.getState());
        IDGenerator.assignIDForFields((HasComponents)this, (Component[])new Component[]{this.language, this.btInitLanguage, this.btGo});
    }

    public void buttonClick(Button.ClickEvent event) {
        if (this.cp.getState().getSelectedCorpora().isEmpty()) {
            Notification.show((String)NO_CORPORA_WARNING);
        } else {
            if (event.getButton() == this.btGo) {
                this.updateQuery();
            }
            if (event.getButton() == this.btClear) {
                this.clear();
                this.updateQuery();
                this.launch(this.cp);
            }
            if (event.getComponent() == this.btInitMeta || event.getComponent() == this.btInitSpan || event.getComponent() == this.btInitLanguage) {
                this.initialize();
            }
        }
    }

    private void clear() {
        this.language.removeAllComponents();
        this.span.removeAllComponents();
        this.meta.removeAllComponents();
        this.toolbar.removeAllComponents();
        this.mainLayout.removeComponent((Component)this.language);
        this.mainLayout.removeComponent((Component)this.span);
        this.mainLayout.removeComponent((Component)this.meta);
        this.mainLayout.removeComponent((Component)this.toolbar);
        this.vnodes.clear();
        this.eboxes.clear();
        this.mboxes.clear();
    }

    public String escapeRegexCharacters(String tok) {
        if (tok == null) {
            return "";
        }
        if (tok.equals("")) {
            return "";
        }
        String result = tok;
        for (int i = 0; i < REGEX_CHARACTERS.length; ++i) {
            result = result.replace(REGEX_CHARACTERS[i], "\\" + REGEX_CHARACTERS[i]);
        }
        return result.replace("/", "\\x2F");
    }

    public Collection<String> getAnnotationValues(String level) {
        TreeSet<String> values = new TreeSet<String>();
        for (String s : this.getAvailableAnnotationLevels(level)) {
            values.add(s);
        }
        return values;
    }

    private String getAQLFragment(SearchBox sb) {
        String result = "";
        String value = null;
        try {
            value = sb.getValue();
        }
        catch (NullPointerException ex) {
            value = null;
        }
        String level = sb.getAttribute();
        if (value == null) {
            result = level;
        }
        if (value != null) {
            if (sb.isRegEx() && !sb.isNegativeSearch()) {
                result = level + "=/" + value.replace("/", "\\x2F") + "/";
            }
            if (sb.isRegEx() && sb.isNegativeSearch()) {
                result = level + "!=/" + value.replace("/", "\\x2F") + "/";
            }
            if (!sb.isRegEx() && sb.isNegativeSearch()) {
                result = level + "!=\"" + value.replace("\"", "\\x22") + "\"";
            }
            if (!sb.isRegEx() && !sb.isNegativeSearch()) {
                result = level + "=\"" + value.replace("\"", "\\x22") + "\"";
            }
        }
        return result;
    }

    private String getAQLQuery() {
        int count = 1;
        StringBuilder ql = new StringBuilder();
        StringBuilder edgeQuery = new StringBuilder();
        StringBuilder sentenceQuery = new StringBuilder();
        ArrayList<Integer> sentenceVars = new ArrayList<Integer>();
        Iterator itEboxes = this.eboxes.iterator();
        for (VerticalNode v : this.vnodes) {
            Collection sboxes = v.getSearchBoxes();
            Iterator iterator = sboxes.iterator();
            while (iterator.hasNext()) {
                SearchBox s = (SearchBox)iterator.next();
                ql.append(" & " + this.getAQLFragment(s));
            }
            if (sboxes.isEmpty()) {
                ql.append("\n& /.*/");
            }
            sentenceVars.add(count);
            for (int i = 1; i < sboxes.size(); ++i) {
                String addQuery = "\n& #" + count + "_=_#" + ++count;
                edgeQuery.append(addQuery);
            }
            String edgeQueryAdds = itEboxes.hasNext() ? "\n& #" + (++count - 1) + " " + ((EdgeBox)itEboxes.next()).getValue() + " #" + count : "";
            edgeQuery.append(edgeQueryAdds);
        }
        String addQuery = "";
        try {
            SpanBox spb = (SpanBox)this.span.getComponent(1);
            if (!spb.isRegEx() && !spb.getValue().isEmpty()) {
                addQuery = "\n& " + spb.getAttribute() + " = \"" + spb.getValue() + "\"";
            }
            if (spb.isRegEx()) {
                addQuery = "\n& " + spb.getAttribute() + " = /" + spb.getValue().replace("/", "\\x2F") + "/";
            }
            if (spb.getValue().isEmpty()) {
                addQuery = "\n&" + spb.getAttribute();
            }
            ql.append(addQuery);
            for (Integer i : sentenceVars) {
                sentenceQuery.append("\n& #").append(count).append("_i_#").append(i.toString());
            }
        }
        catch (Exception spb) {
            // empty catch block
        }
        StringBuilder metaQuery = new StringBuilder();
        Iterator itMetaBoxes = this.mboxes.iterator();
        while (itMetaBoxes.hasNext()) {
            metaQuery.append(this.getMetaQueryFragment((MetaBox)itMetaBoxes.next()));
        }
        String fullQuery = ql.toString() + edgeQuery.toString() + sentenceQuery.toString() + metaQuery.toString();
        if (fullQuery.length() < 3) {
            return "";
        }
        fullQuery = fullQuery.substring(3);
        return fullQuery;
    }

    public Collection<String> getAvailableAnnotationLevels(String meta) {
        TreeSet<String> result = new TreeSet<String>();
        CorporaApi api = new CorporaApi(Helper.getClient((UI)UI.getCurrent()));
        Set corpusSelection = this.cp.getState().getSelectedCorpora();
        try {
            LinkedList atts = new LinkedList();
            for (String corpus : corpusSelection) {
                atts.addAll(api.nodeAnnotations(corpus, Boolean.valueOf(true), Boolean.valueOf(false)));
            }
            for (Annotation a : atts) {
                if (!a.getKey().getName().equals(meta)) continue;
                result.add(a.getVal());
            }
        }
        catch (ApiException ex) {
            log.error(null, (Throwable)ex);
        }
        return result;
    }

    public Set<String> getAvailableAnnotationNames() {
        TreeSet<String> result = new TreeSet<String>();
        Set corpusSelection = this.cp.getState().getSelectedCorpora();
        CorporaApi api = new CorporaApi(Helper.getClient((UI)UI.getCurrent()));
        try {
            for (String corpus : corpusSelection) {
                for (Annotation a : api.nodeAnnotations(corpus, Boolean.valueOf(false), Boolean.valueOf(false))) {
                    result.add(a.getKey().getName());
                }
            }
        }
        catch (ApiException ex) {
            log.error(null, (Throwable)ex);
        }
        result.add("tok");
        return result;
    }

    public Set<String> getAvailableMetaNames() {
        TreeSet<String> result = new TreeSet<String>();
        Set corpusSelection = this.cp.getState().getSelectedCorpora();
        try {
            for (String corpus : corpusSelection) {
                for (AnnoKey key : Helper.getMetaAnnotationNames((String)corpus, (UI)UI.getCurrent())) {
                    result.add(key.getName());
                }
            }
        }
        catch (ApiException ex) {
            log.error(null, (Throwable)ex);
        }
        return result;
    }

    public String getFilterMechanism() {
        return this.filtering.getItemCaption(this.filtering.getValue());
    }

    private String getMetaQueryFragment(MetaBox mb) {
        Collection values = mb.getValues();
        if (!values.isEmpty()) {
            StringBuilder result = new StringBuilder("\n& meta::" + mb.getMetaDatum() + " = ");
            if (values.size() == 1) {
                result.append("\"" + ((String)values.iterator().next()).replace("\"", "\\x22") + "\"");
            } else {
                Iterator itValues = values.iterator();
                result.append("/(" + this.escapeRegexCharacters((String)itValues.next()) + ")");
                while (itValues.hasNext()) {
                    result.append("|(" + this.escapeRegexCharacters((String)itValues.next()) + ")");
                }
                result.append("/");
            }
            return result.toString();
        }
        return "";
    }

    public ReducingStringComparator getRSC() {
        return this.rsc;
    }

    private void initialize() {
        try {
            if (this.addMenu != null) {
                this.language.removeComponent((Component)this.addMenu);
            }
            if (this.addMenuSpan != null) {
                this.span.removeComponent((Component)this.addMenuSpan);
            }
            if (this.addMenuMeta != null) {
                this.meta.removeComponent((Component)this.addMenuMeta);
            }
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        FlatQueryBuilder sq = this;
        Set annonames = this.getAvailableAnnotationNames();
        Set metanames = this.getAvailableMetaNames();
        this.addMenu = new MenuBar();
        this.addMenu.setAutoOpen(false);
        MenuBar.MenuItem add = this.addMenu.addItem("Add", null);
        for (Object annoname : annonames) {
            add.addItem((String)annoname, arg_0 -> this.lambda$initialize$3a1741f3$1((String)annoname, arg_0));
        }
        this.language.removeComponent((Component)this.btInitLanguage);
        this.language.addComponent((Component)this.addMenu);
        this.addMenuSpan = new MenuBar();
        this.addMenuSpan.setAutoOpen(false);
        MenuBar.MenuItem addSpan = this.addMenuSpan.addItem("Add", null);
        for (String annoname : annonames) {
            addSpan.addItem(annoname, (MenuBar.Command & Serializable)selectedItem -> {
                sq.removeSpanBox();
                sq.addSpanBox(annoname);
                this.addMenuSpan.setAutoOpen(false);
            });
        }
        this.spanMenu = addSpan;
        this.span.removeComponent((Component)this.btInitSpan);
        this.span.addComponent((Component)this.addMenuSpan);
        this.addMenuMeta = new MenuBar();
        this.addMenuMeta.setAutoOpen(false);
        MenuBar.MenuItem addMeta = this.addMenuMeta.addItem("Add", null);
        for (String annoname : metanames) {
            addMeta.addItem(annoname, (MenuBar.Command & Serializable)selectedItem -> this.addMetaBox(annoname));
        }
        this.meta.removeComponent((Component)this.btInitMeta);
        this.meta.addComponent((Component)this.addMenuMeta);
    }

    private void launch(QueryController cp) {
        int i;
        this.cp = cp;
        this.rsc = new ReducingStringComparator();
        this.mainLayout = new VerticalLayout();
        this.vnodes = new ArrayList();
        this.eboxes = new ArrayList();
        this.mboxes = new ArrayList();
        this.spbox = null;
        this.btGo = new Button(BUTTON_GO_LABEL, (Button.ClickListener)this);
        this.btGo.setStyleName("small");
        this.btClear = new Button(BUTTON_CLEAR_LABEL, (Button.ClickListener)this);
        this.btClear.setStyleName("small");
        this.btInitLanguage = new Button("Initialize", (Button.ClickListener)this);
        this.btInitLanguage.setDescription(INFO_INIT_LANG);
        this.btInitSpan = new Button("Initialize", (Button.ClickListener)this);
        this.btInitSpan.setDescription(INFO_INIT_SPAN);
        this.btInitMeta = new Button("Initialize", (Button.ClickListener)this);
        this.btInitMeta.setDescription(INFO_INIT_META);
        this.filtering = new NativeSelect("Filtering mechanisms");
        this.filtering.setDescription(INFO_FILTER);
        ReducingStringComparator rdc = new ReducingStringComparator();
        Set mappings = rdc.getMappings().keySet();
        for (i = 0; i < mappings.size(); ++i) {
            String mapname = (String)mappings.toArray()[i];
            this.filtering.addItem((Object)i);
            this.filtering.setItemCaption((Object)i, mapname);
        }
        this.filtering.addItem((Object)(i + 1));
        this.filtering.setItemCaption((Object)(i + 1), "generic");
        this.filtering.select((Object)(i + 1));
        this.filtering.setNullSelectionAllowed(false);
        this.filtering.setImmediate(true);
        this.language = new HorizontalLayout();
        this.languagenodes = new HorizontalLayout();
        this.language.addComponent((Component)this.languagenodes);
        this.language.addComponent((Component)this.btInitLanguage);
        this.language.setMargin(true);
        this.language.setCaption(LANG_CAPTION);
        this.language.addStyleName("linguistics-panel");
        this.span = new HorizontalLayout();
        this.span.setSpacing(true);
        this.span.addComponent((Component)this.btInitSpan);
        this.span.setMargin(true);
        this.span.setCaption(SPAN_CAPTION);
        this.span.addStyleName("span-panel");
        this.meta = new HorizontalLayout();
        this.meta.setSpacing(true);
        this.meta.addComponent((Component)this.btInitMeta);
        this.meta.setMargin(true);
        this.meta.setCaption(META_CAPTION);
        this.meta.addStyleName("meta-panel");
        this.toolbar = new HorizontalLayout();
        this.toolbar.setSpacing(true);
        this.toolbar.addComponent((Component)this.btGo);
        this.toolbar.addComponent((Component)this.btClear);
        this.toolbar.setMargin(true);
        this.toolbar.setCaption(TOOLBAR_CAPTION);
        this.toolbar.addStyleName("toolbar-panel");
        this.advanced = new HorizontalLayout();
        this.advanced.setSpacing(true);
        this.advanced.addComponent((Component)this.filtering);
        this.advanced.setMargin(true);
        this.advanced.setCaption(ADVANCED_CAPTION);
        this.advanced.addStyleName("advanced-panel");
        this.mainLayout.setSpacing(true);
        this.mainLayout.addComponent((Component)this.language);
        this.mainLayout.addComponent((Component)this.span);
        this.mainLayout.addComponent((Component)this.meta);
        this.mainLayout.addComponent((Component)this.toolbar);
        this.mainLayout.addComponent((Component)this.advanced);
        this.setContent((Component)this.mainLayout);
        this.getContent().setWidth("100%");
        this.getContent().setHeight("-1px");
    }

    public void removeMetaBox(MetaBox v) {
        this.meta.removeComponent((Component)v);
        this.mboxes.remove(v);
        List items = ((MenuBar.MenuItem)this.addMenuMeta.getItems().get(0)).getChildren();
        boolean found = false;
        String metalevel = v.getMetaDatum();
        for (int i = 0; i < items.size() && !found; ++i) {
            MenuBar.MenuItem itm = (MenuBar.MenuItem)items.get(i);
            if (!itm.getText().equals(metalevel)) continue;
            itm.setVisible(true);
            found = true;
        }
    }

    public void removeSpanBox() {
        if (this.spbox != null) {
            this.span.removeComponent((Component)this.spbox);
            this.spbox = null;
            this.spanMenu.setText("Add");
        }
    }

    public void removeSpanBox(SpanBox spb) {
        if (spb.equals((Object)this.spbox)) {
            this.removeSpanBox();
        }
    }

    public void removeVerticalNode(VerticalNode v) {
        Iterator itVnodes = this.vnodes.iterator();
        Iterator itEboxes = this.eboxes.iterator();
        VerticalNode vn = (VerticalNode)itVnodes.next();
        EdgeBox eb = null;
        while (!vn.equals((Object)v)) {
            vn = (VerticalNode)itVnodes.next();
            eb = (EdgeBox)itEboxes.next();
        }
        if (eb == null && itEboxes.hasNext()) {
            eb = (EdgeBox)itEboxes.next();
        }
        this.vnodes.remove(v);
        if (eb != null) {
            this.eboxes.remove(eb);
            this.languagenodes.removeComponent((Component)eb);
        }
        this.languagenodes.removeComponent((Component)v);
    }

    public String unescape(String s) {
        s = this.unescapeSlQ(s);
        int i = 1;
        block0: while (i < s.length()) {
            char c0 = s.charAt(i - 1);
            char c1 = s.charAt(i);
            for (int j = 0; j < REGEX_CHARACTERS.length; ++j) {
                if (c1 == REGEX_CHARACTERS[j].charAt(0) && c0 == '\\') {
                    s = s.substring(0, i - 1) + s.substring(i);
                    continue block0;
                }
                if (j != REGEX_CHARACTERS.length - 1) continue;
                ++i;
            }
        }
        return s;
    }

    public String unescapeSlQ(String s) {
        return s.replace("\\x2F", "/").replace("\\x22", "\"");
    }

    public void updateQuery() {
        try {
            this.cp.setQuery(new Query(this.getAQLQuery(), QueryLanguage.AQL, new LinkedHashSet(this.cp.getState().getSelectedCorpora())));
        }
        catch (NullPointerException ex) {
            Notification.show((String)INCOMPLETE_QUERY_WARNING);
        }
    }

    private /* synthetic */ void lambda$initialize$3a1741f3$1(String annoname, MenuBar.MenuItem selectedItem) {
        this.addLinguisticSequenceBox(annoname);
    }
}

