/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.gui.flatquerybuilder;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.CheckBox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.corpus_tools.annis.gui.flatquerybuilder.FlatQueryBuilder;
import org.corpus_tools.annis.gui.flatquerybuilder.ValueField;
import org.corpus_tools.annis.gui.flatquerybuilder.VerticalNode;

public class SearchBox
extends Panel
implements Button.ClickListener {
    private static final long serialVersionUID = 3840322293227356581L;
    public static final String BUTTON_CLOSE_LABEL = "X";
    private static final String CAPTION_REBOX = "Regex";
    private static final String NEGATIVE_SEARCH_LABEL = "Neg. search";
    private static final String LABEL_BUTTON_ADD = "+";
    private Collection<ValueField> vfs;
    private Button btAdd;
    private Label lbl;
    private boolean reBoxSingleValue;
    private Button btClose;
    private VerticalNode vn;
    private VerticalLayout vnframe;
    private String ebene;
    private CheckBox reBox;
    private CheckBox negSearchBox;
    private FlatQueryBuilder sq;
    private VerticalLayout sb;

    public SearchBox(String level, FlatQueryBuilder sq, VerticalNode vn) {
        this(level, sq, vn, false, false);
    }

    public SearchBox(String ebene, FlatQueryBuilder sq, VerticalNode vn, boolean isRegex, boolean negativeSearch) {
        this.vn = vn;
        this.ebene = ebene;
        this.sq = sq;
        this.vfs = new ArrayList();
        this.vnframe = new VerticalLayout();
        this.vnframe.setSpacing(true);
        this.sb = new VerticalLayout();
        this.sb.setSpacing(false);
        this.lbl = new Label(ebene);
        HorizontalLayout sbtoolbar = new HorizontalLayout();
        sbtoolbar.setSpacing(false);
        this.reBox = new CheckBox(CAPTION_REBOX);
        sbtoolbar.addComponent((Component)this.reBox);
        this.reBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            if (((Boolean)this.reBox.getValue()).booleanValue()) {
                for (ValueField vf1 : this.vfs) {
                    String value1 = vf1.getValue();
                    vf1.setValueMode(ValueField.ValueMode.REGEX);
                    if (value1 == null) continue;
                    vf1.setValue(sq.escapeRegexCharacters(value1));
                }
            } else {
                for (ValueField vf2 : this.vfs) {
                    String value2 = vf2.getValue();
                    vf2.setValueMode(ValueField.ValueMode.NORMAL);
                    if (value2 == null) continue;
                    vf2.setValue(sq.unescape(value2));
                }
            }
        });
        this.reBox.setValue((Object)isRegex);
        this.reBox.setEnabled(true);
        this.reBoxSingleValue = isRegex;
        this.negSearchBox = new CheckBox(NEGATIVE_SEARCH_LABEL);
        this.negSearchBox.setImmediate(true);
        this.negSearchBox.setValue((Object)negativeSearch);
        sbtoolbar.addComponent((Component)this.negSearchBox);
        this.btClose = new Button(BUTTON_CLOSE_LABEL, (Button.ClickListener)this);
        this.btClose.setStyleName("small");
        HorizontalLayout titleBar = new HorizontalLayout();
        titleBar.setWidth(this.vnframe.getWidth(), this.vnframe.getWidthUnits());
        titleBar.addComponent((Component)this.lbl);
        titleBar.setComponentAlignment((Component)this.lbl, Alignment.BOTTOM_LEFT);
        titleBar.addComponent((Component)this.btClose);
        titleBar.setComponentAlignment((Component)this.btClose, Alignment.TOP_RIGHT);
        this.btAdd = new Button(LABEL_BUTTON_ADD);
        this.btAdd.addClickListener((Button.ClickListener)this);
        this.btAdd.setStyleName("small");
        this.vnframe.addComponent((Component)titleBar);
        this.vnframe.addComponent((Component)this.sb);
        this.vnframe.addComponent((Component)this.btAdd);
        this.vnframe.setComponentAlignment((Component)this.btAdd, Alignment.BOTTOM_RIGHT);
        this.vnframe.addComponent((Component)sbtoolbar);
        ValueField vf = new ValueField(sq, this, ebene);
        vf.setProtected(true);
        this.vfs.add(vf);
        this.sb.addComponent((Component)vf);
        this.setContent((Component)this.vnframe);
    }

    public ValueField addInputField() {
        ValueField vf = new ValueField(this.sq, this, this.ebene);
        this.vfs.add(vf);
        this.sb.addComponent((Component)vf);
        if (this.vfs.size() > 1) {
            ((ValueField)this.vfs.iterator().next()).setProtected(false);
        } else {
            ((ValueField)this.vfs.iterator().next()).setProtected(true);
        }
        return vf;
    }

    private void addValue(String value) {
        ValueField vf = this.addInputField();
        vf.setValue(value);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.btClose) {
            this.vn.removeSearchBox(this);
            this.sq.updateQuery();
        } else if (event.getButton() == this.btAdd) {
            this.addInputField();
            if (this.vfs.size() == 2) {
                this.reBoxSingleValue = (Boolean)this.reBox.getValue();
                this.reBox.setValue((Object)true);
                this.reBox.setEnabled(false);
            }
        }
    }

    public String getAttribute() {
        return this.ebene;
    }

    public String getValue() {
        StringBuilder stringbuild = new StringBuilder();
        for (ValueField vf : this.vfs) {
            if (this.vfs.size() > 1) {
                stringbuild.append("(");
            }
            stringbuild.append(vf.getValue());
            if (this.vfs.size() > 1) {
                stringbuild.append(")");
            }
            stringbuild.append("|");
        }
        return stringbuild.toString().substring(0, stringbuild.toString().length() - 1);
    }

    public boolean isNegativeSearch() {
        return (Boolean)this.negSearchBox.getValue();
    }

    public boolean isRegEx() {
        return (Boolean)this.reBox.getValue();
    }

    public void removeValueField(ValueField vf) {
        this.sb.removeComponent((Component)vf);
        this.vfs.remove(vf);
        if (this.vfs.size() < 2) {
            this.reBox.setEnabled(true);
            this.reBox.setValue((Object)this.reBoxSingleValue);
            ((ValueField)this.vfs.iterator().next()).setProtected(true);
        }
    }

    public void setValue(Collection<String> values) {
        for (ValueField vf : this.vfs) {
            this.sb.removeComponent((Component)vf);
        }
        this.vfs.clear();
        this.reBox.setValue((Object)true);
        this.reBox.setEnabled(false);
        for (String s : values) {
            this.addValue(s);
        }
    }

    public void setValue(String value) {
        for (ValueField vf : this.vfs) {
            this.sb.removeComponent((Component)vf);
        }
        this.vfs.clear();
        this.reBox.setEnabled(true);
        this.reBox.setValue((Object)this.reBoxSingleValue);
        ValueField vf = this.addInputField();
        vf.setValue(value);
    }
}

